/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowAudioLanguageFilter
extends AbstractCheckComboBoxTvShowUIFilter<String> {
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();

    public TvShowAudioLanguageFilter() {
        this.checkComboBox.enableFilter((s, s2) -> String.valueOf(s).startsWith(s2.toLowerCase(Locale.ROOT)));
        this.buildAudioLanguageArray();
        this.tvShowList.addPropertyChangeListener("audioLanugages", evt -> SwingUtilities.invokeLater(this::buildAudioLanguageArray));
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        for (TvShowEpisode episode : episodes) {
            List<MediaFile> mfs = episode.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO);
            for (MediaFile mf : mfs) {
                if (!invert && selectedItems.isEmpty() && mf.getAudioLanguagesList().isEmpty()) {
                    return true;
                }
                if (invert && selectedItems.isEmpty() && !mf.getAudioLanguagesList().isEmpty()) {
                    return true;
                }
                if (invert != Collections.disjoint(selectedItems, mf.getAudioLanguagesList())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.language"));
    }

    @Override
    public String getId() {
        return "tvShowAudioLanguage";
    }

    private void buildAudioLanguageArray() {
        ArrayList<String> audios = new ArrayList<String>(this.tvShowList.getAudioLanguagesInEpisodes());
        Collections.sort(audios);
        this.setValues(audios);
    }
}

