/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBox;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowDatasourceFilter
extends AbstractCheckComboBoxTvShowUIFilter<String> {
    private final TvShowSettings tvShowSettings = TvShowModuleManager.getInstance().getSettings();

    public TvShowDatasourceFilter() {
        this.buildAndInstallDatasourceArray();
        PropertyChangeListener propertyChangeListener = evt -> this.buildAndInstallDatasourceArray();
        this.tvShowSettings.addPropertyChangeListener("dataSource", propertyChangeListener);
    }

    @Override
    public String getId() {
        return "tvShowDatasource";
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List dataSources = this.checkComboBox.getSelectedItems();
        return invert ^ dataSources.contains(tvShow.getDataSource());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.datasource"));
    }

    @Override
    protected JComponent createFilterComponent() {
        this.checkComboBox = new TmmCheckComboBox();
        return this.checkComboBox;
    }

    private void buildAndInstallDatasourceArray() {
        ArrayList<String> datasources = new ArrayList<String>(this.tvShowSettings.getTvShowDataSource());
        Collections.sort(datasources);
        this.setValues(datasources);
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

