/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.datepicker.DatePicker;
import org.tinymediamanager.ui.tvshows.filters.AbstractTvShowUIFilter;

public class TvShowDateAddedFilter
extends AbstractTvShowUIFilter {
    private DatePicker datePicker;

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.dateadded"));
    }

    @Override
    protected JComponent createFilterComponent() {
        this.datePicker = new DatePicker();
        this.datePicker.addPropertyChangeListener("date", e -> this.filterChanged());
        return this.datePicker;
    }

    @Override
    public String getId() {
        return "tvShowDateAdded";
    }

    @Override
    public String getFilterValueAsString() {
        Date date = this.datePicker.getDate();
        if (date != null) {
            return String.valueOf(date.getTime());
        }
        return null;
    }

    @Override
    public void setFilterValue(Object value) {
        if (value != null && StringUtils.isNotBlank((CharSequence)value.toString())) {
            try {
                Date date = new Date(Long.parseLong(value.toString()));
                this.datePicker.setDate(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void clearFilter() {
        this.datePicker.setDate(null);
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        if (this.datePicker.getDate() == null) {
            return true;
        }
        Date date = this.datePicker.getDate();
        try {
            for (TvShowEpisode episode : episodes) {
                if (episode.isDummy()) continue;
                boolean foundEpisode = false;
                if (DateUtils.isSameDay((Date)date, (Date)episode.getDateAddedForUi())) {
                    foundEpisode = true;
                }
                if (invert && !foundEpisode) {
                    return true;
                }
                if (invert || !foundEpisode) continue;
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }
}

