/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowMissingArtworkFilter
extends AbstractCheckComboBoxTvShowUIFilter<MetadataField> {
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();

    public TvShowMissingArtworkFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toString().toLowerCase(Locale.ROOT).startsWith(s2.toLowerCase(Locale.ROOT)));
        ArrayList<MetadataField> values = new ArrayList<MetadataField>();
        for (TvShowScraperMetadataConfig config : TvShowScraperMetadataConfig.values()) {
            if (!config.isArtwork()) continue;
            values.add(new MetadataField(config));
        }
        this.setValues(values);
    }

    @Override
    public String getId() {
        return "tvShowMissingArtwork";
    }

    @Override
    protected String parseTypeToString(MetadataField type) throws Exception {
        return type.config.name();
    }

    @Override
    protected MetadataField parseStringToType(String string) throws Exception {
        try {
            return new MetadataField(TvShowScraperMetadataConfig.valueOf(string));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        ArrayList<TvShowScraperMetadataConfig> tvShowValues = new ArrayList<TvShowScraperMetadataConfig>();
        ArrayList<TvShowEpisodeScraperMetadataConfig> episodeValues = new ArrayList<TvShowEpisodeScraperMetadataConfig>();
        for (MetadataField metadataField : this.checkComboBox.getSelectedItems()) {
            tvShowValues.add(metadataField.config);
            if (metadataField.config != TvShowScraperMetadataConfig.THUMB) continue;
            episodeValues.add(TvShowEpisodeScraperMetadataConfig.THUMB);
        }
        if (invert ^ !this.tvShowList.detectMissingFields(tvShow, tvShowValues).isEmpty()) {
            return true;
        }
        for (TvShowEpisode episode : episodes) {
            if (episode.isDummy() || !(invert ^ !this.tvShowList.detectMissingFields(episode, episodeValues).isEmpty())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.missingartwork"));
    }

    public static class MetadataField {
        private final TvShowScraperMetadataConfig config;

        public MetadataField(TvShowScraperMetadataConfig config) {
            this.config = config;
        }

        public String toString() {
            return this.config.getDescription();
        }
    }
}

