/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.panels.tvshow;

import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.ui.ColumnLayout;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.LinkTextArea;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.ReadOnlyTextPane;
import org.tinymediamanager.ui.components.ReadOnlyTextPaneHTML;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.converter.CertificationImageConverter;
import org.tinymediamanager.ui.converter.ZeroIdConverter;
import org.tinymediamanager.ui.panels.InformationPanel;
import org.tinymediamanager.ui.panels.MediaInformationLogosPanel;
import org.tinymediamanager.ui.panels.RatingPanel;
import org.tinymediamanager.ui.tvshows.TvShowOtherIdsConverter;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;

public class TvShowInformationPanel
extends InformationPanel {
    private static final long serialVersionUID = 1911808562993073590L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowInformationPanel.class);
    private static final String LAYOUT_ARTWORK_VISIBLE = "[n:100lp:20%, grow][300lp:300lp,grow 350]";
    private static final String LAYOUT_ARTWORK_HIDDEN = "[][300lp:300lp,grow 350]";
    private final TvShowSelectionModel tvShowSelectionModel;
    private JTextPane taGenres;
    private JLabel lblCertification;
    private LinkLabel lblThetvdbId;
    private LinkLabel lblImdbId;
    private LinkLabel lblTmdbId;
    private LinkTextArea lblPath;
    private JLabel lblPremiered;
    private JTextPane taStudio;
    private JLabel lblStatus;
    private JLabel lblYear;
    private JTextPane taTags;
    private JTextPane taOtherIds;
    private JLabel lblCountry;
    private JLabel lblRuntime;
    private JTextPane taNote;
    private JLabel lblTvShowName;
    private JTextPane taOverview;
    private MediaInformationLogosPanel panelLogos;
    private JLabel lblOriginalTitle;
    private JScrollPane scrollPane;
    private JLabel lblCertificationLogo;
    private RatingPanel ratingPanel;

    public TvShowInformationPanel(TvShowSelectionModel tvShowSelectionModel) {
        this.tvShowSelectionModel = tvShowSelectionModel;
        this.initComponents();
        this.initDataBindings();
        this.lblImdbId.addActionListener(arg0 -> {
            String url = "https://www.imdb.com/title/" + this.lblImdbId.getText();
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e) {
                LOGGER.error("browse to imdbid", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
        this.lblThetvdbId.addActionListener(arg0 -> {
            String url = "https://thetvdb.com/?tab=series&id=" + this.lblThetvdbId.getText();
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e) {
                LOGGER.error("browse to thetvdb", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
        this.lblTmdbId.addActionListener(arg0 -> {
            String url = "https://www.themoviedb.org/tv/" + this.lblTmdbId.getText();
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e) {
                LOGGER.error("browse to tmdb", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
        this.lblPath.addActionListener(e -> {
            if (StringUtils.isNotBlank((CharSequence)this.lblPath.getText())) {
                Path path = Paths.get(this.lblPath.getText(), new String[0]);
                try {
                    if (Files.exists(path, new LinkOption[0])) {
                        TmmUIHelper.openFile(path);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("open filemanager", (Throwable)ex);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)path, "message.erroropenfolder", new String[]{":", ex.getLocalizedMessage()}));
                }
            }
        });
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source.getClass() != TvShowSelectionModel.class) {
                return;
            }
            TvShowSelectionModel model = (TvShowSelectionModel)source;
            TvShow tvShow = model.getSelectedTvShow();
            if ("selectedTvShow".equals(property) || "poster".equals(property)) {
                this.setArtwork(tvShow, MediaFileType.POSTER);
            }
            if ("selectedTvShow".equals(property) || "fanart".equals(property)) {
                this.setArtwork(tvShow, MediaFileType.FANART);
            }
            if ("selectedTvShow".equals(property) || "banner".equals(property)) {
                this.setArtwork(tvShow, MediaFileType.BANNER);
            }
            if ("selectedTvShow".equals(property) || "thumb".equals(property)) {
                this.setArtwork(tvShow, MediaFileType.THUMB);
            }
            if ("selectedTvShow".equals(property) || "clearlogo".equals(property)) {
                this.setArtwork(tvShow, MediaFileType.CLEARLOGO);
            }
            if ("selectedTvShow".equals(property) || "mediaFiles".equals(property) || "mediaInformation".equals(property)) {
                this.panelLogos.setMediaInformationSource(tvShow);
            }
            if ("selectedTvShow".equals(property) || "rating".equals(property)) {
                this.setRating(tvShow);
            }
            if ("selectedTvShow".equals(property)) {
                SwingUtilities.invokeLater(() -> this.scrollPane.getVerticalScrollBar().setValue(0));
            }
        };
        tvShowSelectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", LAYOUT_ARTWORK_VISIBLE, "[][grow]"));
        JPanel panelLeft = new JPanel();
        panelLeft.setLayout(new ColumnLayout());
        this.add((Component)panelLeft, "cell 0 0 1 2,grow");
        for (Component component : this.generateArtworkComponents(MediaFileType.POSTER)) {
            panelLeft.add(component);
        }
        for (Component component : this.generateArtworkComponents(MediaFileType.FANART)) {
            panelLeft.add(component);
        }
        for (Component component : this.generateArtworkComponents(MediaFileType.BANNER)) {
            panelLeft.add(component);
        }
        for (Component component : this.generateArtworkComponents(MediaFileType.THUMB)) {
            panelLeft.add(component);
        }
        for (Component component : this.generateArtworkComponents(MediaFileType.CLEARLOGO)) {
            panelLeft.add(component);
        }
        JPanel panelTitle = new JPanel();
        this.add((Component)panelTitle, "cell 1 0,grow");
        panelTitle.setLayout((LayoutManager)new MigLayout("insets 0 0 n n", "[grow]", "[][][shrink 0]"));
        this.lblTvShowName = new TmmLabel("", 1.33);
        panelTitle.add((Component)this.lblTvShowName, "cell 0 0,growx,wmin 0");
        this.lblOriginalTitle = new JLabel("");
        panelTitle.add((Component)this.lblOriginalTitle, "cell 0 1,growx,wmin 0");
        panelTitle.add((Component)new JSeparator(), "cell 0 2,growx");
        JPanel panelRight = new JPanel();
        panelRight.setLayout((LayoutManager)new MigLayout("insets n 0 n n, hidemode 2", "[100lp,grow]", "[][shrink 0][][shrink 0][][shrink 0][][grow][][]"));
        this.scrollPane = new NoBorderScrollPane(panelRight);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(8);
        this.add((Component)this.scrollPane, "cell 1 1,grow, wmin 0");
        JPanel panelTopDetails = new JPanel();
        panelRight.add((Component)panelTopDetails, "cell 0 0,growx");
        panelTopDetails.setLayout((LayoutManager)new MigLayout("insets 0", "[][][40lp!][][grow][]", "[]2lp[]2lp[]2lp[]2lp[]2lp[]2lp[]2lp[]"));
        TmmLabel lblYearT = new TmmLabel(TmmResourceBundle.getString("metatag.year"));
        panelTopDetails.add((Component)lblYearT, "flowy,cell 0 0");
        this.lblYear = new JLabel("");
        panelTopDetails.add((Component)this.lblYear, "cell 1 0");
        TmmLabel lblImdbIdT = new TmmLabel("IMDB ID");
        panelTopDetails.add((Component)lblImdbIdT, "cell 3 0");
        this.lblImdbId = new LinkLabel("");
        panelTopDetails.add((Component)this.lblImdbId, "cell 4 0");
        this.lblCertificationLogo = new JLabel("");
        panelTopDetails.add((Component)this.lblCertificationLogo, "cell 5 0 1 3, top");
        TmmLabel lblPremieredT = new TmmLabel(TmmResourceBundle.getString("metatag.premiered"));
        panelTopDetails.add((Component)lblPremieredT, "cell 0 1");
        this.lblPremiered = new JLabel("");
        panelTopDetails.add((Component)this.lblPremiered, "cell 1 1");
        TmmLabel lblThetvdbIdT = new TmmLabel("TheTVDB ID");
        panelTopDetails.add((Component)lblThetvdbIdT, "cell 3 1");
        this.lblThetvdbId = new LinkLabel("");
        panelTopDetails.add((Component)this.lblThetvdbId, "cell 4 1");
        TmmLabel lblCertificationT = new TmmLabel(TmmResourceBundle.getString("metatag.certification"));
        panelTopDetails.add((Component)lblCertificationT, "cell 0 2");
        this.lblCertification = new JLabel("");
        panelTopDetails.add((Component)this.lblCertification, "cell 1 2");
        TmmLabel lblTmdbIdT = new TmmLabel(TmmResourceBundle.getString("metatag.tmdb"));
        panelTopDetails.add((Component)lblTmdbIdT, "cell 3 2");
        this.lblTmdbId = new LinkLabel();
        panelTopDetails.add((Component)this.lblTmdbId, "cell 4 2");
        TmmLabel lblOtherIdsT = new TmmLabel(TmmResourceBundle.getString("metatag.otherids"));
        panelTopDetails.add((Component)lblOtherIdsT, "cell 3 3");
        this.taOtherIds = new ReadOnlyTextPane();
        panelTopDetails.add((Component)this.taOtherIds, "cell 4 3 2 1,growx,wmin 0");
        TmmLabel lblRuntimeT = new TmmLabel(TmmResourceBundle.getString("metatag.runtime"));
        panelTopDetails.add((Component)lblRuntimeT, "cell 0 3,aligny top");
        this.lblRuntime = new JLabel("");
        panelTopDetails.add((Component)this.lblRuntime, "cell 1 3,aligny top");
        TmmLabel lblGenresT = new TmmLabel(TmmResourceBundle.getString("metatag.genre"));
        panelTopDetails.add((Component)lblGenresT, "cell 0 4");
        this.taGenres = new ReadOnlyTextPane();
        panelTopDetails.add((Component)this.taGenres, "cell 1 4 5 1,growx,wmin 0");
        TmmLabel lblStatusT = new TmmLabel(TmmResourceBundle.getString("metatag.status"));
        panelTopDetails.add((Component)lblStatusT, "cell 0 5");
        this.lblStatus = new JLabel("");
        panelTopDetails.add((Component)this.lblStatus, "cell 1 5 4 1");
        TmmLabel lblStudioT = new TmmLabel(TmmResourceBundle.getString("metatag.studio"));
        panelTopDetails.add((Component)lblStudioT, "cell 0 6,wmin 0");
        this.taStudio = new ReadOnlyTextPane();
        panelTopDetails.add((Component)this.taStudio, "cell 1 6 5 1,growx, wmin 0");
        TmmLabel lblCountryT = new TmmLabel(TmmResourceBundle.getString("metatag.country"));
        panelTopDetails.add((Component)lblCountryT, "cell 0 7");
        this.lblCountry = new JLabel("");
        panelTopDetails.add((Component)this.lblCountry, "cell 1 7 5 1, wmin 0");
        panelRight.add((Component)new JSeparator(), "cell 0 1,growx");
        this.ratingPanel = new RatingPanel();
        panelRight.add((Component)this.ratingPanel, "flowx,cell 0 2,aligny center");
        JSeparator sepLogos = new JSeparator();
        panelRight.add((Component)sepLogos, "cell 0 3,growx");
        this.panelLogos = new MediaInformationLogosPanel();
        panelRight.add((Component)this.panelLogos, "cell 0 4,wmin 0");
        panelRight.add((Component)new JSeparator(), "cell 0 5,growx");
        TmmLabel lblPlot = new TmmLabel(TmmResourceBundle.getString("metatag.plot"));
        panelRight.add((Component)lblPlot, "cell 0 6");
        TmmFontHelper.changeFont((JComponent)lblPlot, 1);
        this.taOverview = new ReadOnlyTextPaneHTML();
        panelRight.add((Component)this.taOverview, "cell 0 7,growx,wmin 0,aligny top");
        panelRight.add((Component)new JSeparator(), "cell 0 8,growx");
        JPanel panelBottomDetails = new JPanel();
        panelBottomDetails.setLayout((LayoutManager)new MigLayout("insets 0", "[][grow]", "[]2lp[]2lp[]"));
        panelRight.add((Component)panelBottomDetails, "cell 0 9,grow");
        TmmLabel lblTagsT = new TmmLabel(TmmResourceBundle.getString("metatag.tags"));
        panelBottomDetails.add((Component)lblTagsT, "cell 0 0");
        this.taTags = new ReadOnlyTextPane();
        panelBottomDetails.add((Component)this.taTags, "cell 1 0,growx,wmin 0");
        TmmLabel lblPathT = new TmmLabel(TmmResourceBundle.getString("metatag.path"));
        panelBottomDetails.add((Component)lblPathT, "cell 0 1");
        this.lblPath = new LinkTextArea("");
        panelBottomDetails.add((Component)this.lblPath, "cell 1 1,growx,wmin 0");
        TmmLabel lblNoteT = new TmmLabel(TmmResourceBundle.getString("metatag.note"));
        panelBottomDetails.add((Component)lblNoteT, "cell 0 2");
        this.taNote = new ReadOnlyTextPaneHTML();
        panelBottomDetails.add((Component)this.taNote, "cell 1 2,growx,wmin 0");
    }

    @Override
    protected List<MediaFileType> getShowArtworkFromSettings() {
        return TvShowModuleManager.getInstance().getSettings().getShowTvShowArtworkTypes();
    }

    @Override
    protected void setColumnLayout(boolean artworkVisible) {
        if (artworkVisible) {
            ((MigLayout)this.getLayout()).setColumnConstraints((Object)LAYOUT_ARTWORK_VISIBLE);
        } else {
            ((MigLayout)this.getLayout()).setColumnConstraints((Object)LAYOUT_ARTWORK_HIDDEN);
        }
    }

    private void setRating(TvShow tvShow) {
        HashMap<String, MediaRating> ratings = new HashMap<String, MediaRating>(tvShow.getRatings());
        MediaRating customRating = tvShow.getRating();
        if (customRating != MediaMetadata.EMPTY_RATING) {
            ratings.put("custom", customRating);
        }
        this.ratingPanel.setRatings(ratings);
    }

    protected void initDataBindings() {
        BeanProperty tvShowSelectionModelBeanProperty = BeanProperty.create((String)"selectedTvShow.title");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty, (Object)this.lblTvShowName, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedTvShow.plot");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_1, (Object)this.taOverview, (Property)jTextPaneBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowSelectionModelBeanProperty_4 = BeanProperty.create((String)"selectedTvShow.originalTitle");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_4, (Object)this.lblOriginalTitle, (Property)jLabelBeanProperty);
        autoBinding_5.bind();
        BeanProperty tvShowSelectionModelBeanProperty_6 = BeanProperty.create((String)"selectedTvShow.year");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_6, (Object)this.lblYear, (Property)jLabelBeanProperty);
        autoBinding_6.bind();
        BeanProperty tvShowSelectionModelBeanProperty_7 = BeanProperty.create((String)"selectedTvShow.imdbId");
        BeanProperty linkLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_7, (Object)this.lblImdbId, (Property)linkLabelBeanProperty);
        autoBinding_7.bind();
        BeanProperty tvShowSelectionModelBeanProperty_8 = BeanProperty.create((String)"selectedTvShow.certification.localizedName");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_8, (Object)this.lblCertification, (Property)jLabelBeanProperty);
        autoBinding_8.bind();
        BeanProperty tvShowSelectionModelBeanProperty_9 = BeanProperty.create((String)"selectedTvShow.tvdbId");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_9, (Object)this.lblThetvdbId, (Property)linkLabelBeanProperty);
        autoBinding_9.bind();
        BeanProperty tvShowSelectionModelBeanProperty_10 = BeanProperty.create((String)"selectedTvShow.runtime");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_10, (Object)this.lblRuntime, (Property)jLabelBeanProperty);
        autoBinding_10.bind();
        BeanProperty tvShowSelectionModelBeanProperty_11 = BeanProperty.create((String)"selectedTvShow.ids");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_11, (Object)this.taOtherIds, (Property)jTextPaneBeanProperty);
        autoBinding_11.setConverter((Converter)new TvShowOtherIdsConverter());
        autoBinding_11.bind();
        BeanProperty tvShowSelectionModelBeanProperty_12 = BeanProperty.create((String)"selectedTvShow.status.localizedName");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_12, (Object)this.lblStatus, (Property)jLabelBeanProperty);
        autoBinding_12.bind();
        BeanProperty tvShowSelectionModelBeanProperty_13 = BeanProperty.create((String)"selectedTvShow.genresAsString");
        AutoBinding autoBinding_13 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_13, (Object)this.taGenres, (Property)jTextPaneBeanProperty);
        autoBinding_13.bind();
        BeanProperty tvShowSelectionModelBeanProperty_14 = BeanProperty.create((String)"selectedTvShow.firstAiredAsString");
        AutoBinding autoBinding_14 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_14, (Object)this.lblPremiered, (Property)jLabelBeanProperty);
        autoBinding_14.bind();
        BeanProperty tvShowSelectionModelBeanProperty_15 = BeanProperty.create((String)"selectedTvShow.productionCompany");
        AutoBinding autoBinding_15 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_15, (Object)this.taStudio, (Property)jTextPaneBeanProperty);
        autoBinding_15.bind();
        BeanProperty tvShowSelectionModelBeanProperty_16 = BeanProperty.create((String)"selectedTvShow.country");
        AutoBinding autoBinding_16 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_16, (Object)this.lblCountry, (Property)jLabelBeanProperty);
        autoBinding_16.bind();
        BeanProperty tvShowSelectionModelBeanProperty_17 = BeanProperty.create((String)"selectedTvShow.tagsAsString");
        AutoBinding autoBinding_17 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_17, (Object)this.taTags, (Property)jTextPaneBeanProperty);
        autoBinding_17.bind();
        BeanProperty tvShowSelectionModelBeanProperty_18 = BeanProperty.create((String)"selectedTvShow.path");
        BeanProperty linkTextAreaBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_18 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_18, (Object)this.lblPath, (Property)linkTextAreaBeanProperty);
        autoBinding_18.bind();
        BeanProperty tvShowSelectionModelBeanProperty_19 = BeanProperty.create((String)"selectedTvShow.note");
        AutoBinding autoBinding_19 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_19, (Object)this.taNote, (Property)jTextPaneBeanProperty);
        autoBinding_19.bind();
        BeanProperty tvShowSelectionModelBeanProperty_20 = BeanProperty.create((String)"selectedTvShow.certification");
        BeanProperty jLabelBeanProperty_1 = BeanProperty.create((String)"icon");
        AutoBinding autoBinding_20 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_20, (Object)this.lblCertificationLogo, (Property)jLabelBeanProperty_1);
        autoBinding_20.setConverter((Converter)new CertificationImageConverter());
        autoBinding_20.bind();
        BeanProperty tvShowSelectionModelBeanProperty_21 = BeanProperty.create((String)"selectedTvShow.tmdbId");
        AutoBinding autoBinding_21 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_21, (Object)this.lblTmdbId, (Property)linkLabelBeanProperty);
        autoBinding_21.setConverter((Converter)new ZeroIdConverter());
        autoBinding_21.bind();
    }
}

