/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.ui.ScraperInTable;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.DocsButton;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.ReadOnlyTextPane;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.panels.MediaScraperConfigurationPanel;
import org.tinymediamanager.ui.panels.ScrollablePanel;
import org.tinymediamanager.ui.tvshows.TvShowScraper;

class TvShowScraperSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 4999827736720726395L;
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
    private final List<TvShowScraper> scrapers = new ArrayList<TvShowScraper>();
    private TmmTable tableScraper;
    private JTextPane tpScraperDescription;
    private JScrollPane scrollPaneScraperDetails;
    private JPanel panelScraperOptions;

    TvShowScraperSettingsPanel() {
        MediaScraper defaultMediaScraper = TvShowModuleManager.getInstance().getTvShowList().getDefaultMediaScraper();
        int selectedIndex = 0;
        for (MediaScraper mediaScraper : TvShowModuleManager.getInstance().getTvShowList().getAvailableMediaScrapers()) {
            TvShowScraper tvShowScraper = new TvShowScraper(mediaScraper);
            this.scrapers.add(tvShowScraper);
        }
        Collections.sort(this.scrapers);
        for (int i = 0; i < this.scrapers.size(); ++i) {
            TvShowScraper tvShowScraper = this.scrapers.get(i);
            if (!tvShowScraper.getMediaScraper().equals(defaultMediaScraper)) continue;
            tvShowScraper.setDefaultScraper(true);
            selectedIndex = i;
            break;
        }
        this.initComponents();
        this.initDataBindings();
        Font font = UIManager.getFont("Label.font");
        Color color = UIManager.getColor("Label.foreground");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; color: rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "); }";
        ((HTMLDocument)this.tpScraperDescription.getDocument()).getStyleSheet().addRule(bodyRule);
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 0, 2);
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 1, 10);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableScraper, 5);
        this.tableScraper.getModel().addTableModelListener(arg0 -> {
            int row;
            TvShowScraper changedScraper;
            if (arg0.getColumn() == 0 && (changedScraper = this.scrapers.get(row = arg0.getFirstRow())).getDefaultScraper().booleanValue()) {
                this.settings.setScraper(changedScraper.getScraperId());
                for (TvShowScraper scraper : this.scrapers) {
                    if (scraper == changedScraper) continue;
                    scraper.setDefaultScraper(Boolean.FALSE);
                }
            }
        });
        this.tableScraper.getSelectionModel().addListSelectionListener(e -> {
            int index = this.tableScraper.convertRowIndexToModel(this.tableScraper.getSelectedRow());
            if (index > -1) {
                this.panelScraperOptions.removeAll();
                if (this.scrapers.get(index).getMediaProvider().getProviderInfo().getConfig().hasConfig()) {
                    this.panelScraperOptions.add(new MediaScraperConfigurationPanel(this.scrapers.get(index).getMediaProvider()));
                }
                this.scrollPaneScraperDetails.revalidate();
                this.scrollPaneScraperDetails.repaint();
            }
        });
        if (!this.scrapers.isEmpty()) {
            this.tableScraper.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[400lp,grow]"));
        JPanel panelScraper = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][grow]", "[][shrink 0][200lp:600lp,grow]"));
        TmmLabel lblScraper = new TmmLabel(TmmResourceBundle.getString("scraper.metadata"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelScraper, lblScraper, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#scraper"));
        this.add((Component)collapsiblePanel, "cell 0 0,wmin 0,grow");
        this.tableScraper = new TmmTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                ScraperInTable scraper = TvShowScraperSettingsPanel.this.scrapers.get(row);
                comp.setEnabled(scraper.isEnabled());
                return comp;
            }
        };
        this.tableScraper.setRowHeight(29);
        this.tableScraper.setShowGrid(true);
        panelScraper.add((Component)this.tableScraper, "cell 1 0,grow");
        JSeparator separator = new JSeparator();
        panelScraper.add((Component)separator, "cell 1 1,growx");
        this.scrollPaneScraperDetails = new NoBorderScrollPane();
        panelScraper.add((Component)this.scrollPaneScraperDetails, "cell 1 2,grow");
        this.scrollPaneScraperDetails.setHorizontalScrollBarPolicy(31);
        this.scrollPaneScraperDetails.setVerticalScrollBarPolicy(20);
        ScrollablePanel panelScraperDetails = new ScrollablePanel();
        this.scrollPaneScraperDetails.setViewportView(panelScraperDetails);
        panelScraperDetails.setLayout((LayoutManager)new MigLayout("insets 0", "[grow]", "[][grow]"));
        this.tpScraperDescription = new ReadOnlyTextPane();
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        panelScraperDetails.add((Component)this.tpScraperDescription, "cell 0 0,grow");
        this.panelScraperOptions = new JPanel();
        this.panelScraperOptions.setLayout(new FlowLayout(0));
        panelScraperDetails.add((Component)this.panelScraperOptions, "cell 0 1,grow");
    }

    protected void initDataBindings() {
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.scrapers, (JTable)this.tableScraper);
        BeanProperty tvShowScraperBeanProperty = BeanProperty.create((String)"defaultScraper");
        jTableBinding.addColumnBinding((Property)tvShowScraperBeanProperty).setColumnName(TmmResourceBundle.getString("Settings.active")).setColumnClass(Boolean.class);
        BeanProperty tvShowScraperBeanProperty_1 = BeanProperty.create((String)"scraperLogo");
        jTableBinding.addColumnBinding((Property)tvShowScraperBeanProperty_1).setColumnName(TmmResourceBundle.getString("mediafiletype.logo")).setColumnClass(Icon.class).setEditable(false);
        BeanProperty tvShowScraperBeanProperty_2 = BeanProperty.create((String)"scraperName");
        jTableBinding.addColumnBinding((Property)tvShowScraperBeanProperty_2).setColumnName(TmmResourceBundle.getString("metatag.name")).setEditable(false);
        jTableBinding.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.scraperDescription");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableScraper, (Property)jTableBeanProperty, (Object)this.tpScraperDescription, (Property)jTextPaneBeanProperty);
        autoBinding_3.bind();
    }
}

