/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.LayoutManager;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.TvShowSettingsDefaults;
import org.tinymediamanager.thirdparty.trakttv.TvShowClearTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.DocsButton;
import org.tinymediamanager.ui.components.JHintCheckBox;
import org.tinymediamanager.ui.components.TmmLabel;

class TvShowSettingsPanel
extends JPanel {
    private static final long serialVersionUID = -675729644848101096L;
    private static final int COL_COUNT = 7;
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
    private JCheckBox chckbxImageCache;
    private JCheckBox chckbxExtractArtworkFromVsmeta;
    private JCheckBox chckbxTraktTv;
    private JButton btnClearTraktTvShows;
    private JButton btnPresetKodi;
    private JButton btnPresetXbmc;
    private JButton btnPresetMediaPortal1;
    private JButton btnPresetMediaPortal2;
    private JButton btnPresetPlex;
    private JButton btnPresetJellyfin;
    private JButton btnPresetEmby;
    private JCheckBox chckbxRenameAfterScrape;
    private JCheckBox chckbxARDAfterScrape;
    private JCheckBox chckbxAutoUpdateOnStart;
    private JCheckBox chckbxMetadataFromMediainfo;
    private JCheckBox chckbxTraktCollection;
    private JCheckBox chckbxTraktWatched;
    private JCheckBox chckbxTraktRating;

    TvShowSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.btnClearTraktTvShows.addActionListener(e -> {
            Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
            int confirm = JOptionPane.showOptionDialog(null, TmmResourceBundle.getString("Settings.trakt.cleartvshows.hint"), TmmResourceBundle.getString("Settings.trakt.cleartvshows"), 0, 3, null, options, null);
            if (confirm == 0) {
                TvShowClearTraktTvTask task = new TvShowClearTraktTvTask();
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
        });
        this.btnPresetXbmc.addActionListener(evt -> TvShowSettingsDefaults.setDefaultSettingsForXbmc());
        this.btnPresetKodi.addActionListener(evt -> TvShowSettingsDefaults.setDefaultSettingsForKodi());
        this.btnPresetMediaPortal1.addActionListener(evt -> TvShowSettingsDefaults.setDefaultSettingsForMediaPortal());
        this.btnPresetMediaPortal2.addActionListener(evt -> TvShowSettingsDefaults.setDefaultSettingsForMediaPortal());
        this.btnPresetPlex.addActionListener(evt -> TvShowSettingsDefaults.setDefaultSettingsForPlex());
        this.btnPresetEmby.addActionListener(evt -> TvShowSettingsDefaults.setDefaultSettingsForEmby());
        this.btnPresetJellyfin.addActionListener(evt -> TvShowSettingsDefaults.setDefaultSettingsForJellyfin());
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][15lp!][][15lp!][]"));
        JPanel panelAutomaticTasks = new JPanel();
        panelAutomaticTasks.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][10lp!][][][10lp!][]"));
        TmmLabel lblAutomaticTasksT = new TmmLabel(TmmResourceBundle.getString("Settings.automatictasks"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelAutomaticTasks, lblAutomaticTasksT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#automatic-tasks"));
        JPanel panelPresets = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][15lp][120lp:n][15lp!][120lp:n][15lp!][120lp:n][grow]", "[]"));
        TmmLabel lblPresets = new TmmLabel(TmmResourceBundle.getString("Settings.preset"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel_1 = new CollapsiblePanel((JComponent)panelPresets, lblPresets, true);
        collapsiblePanel_1.addExtraTitleComponent(new DocsButton("/tvshows/settings#media-center-presets"));
        this.add((Component)collapsiblePanel_1, "cell 0 0,growx,wmin 0");
        JLabel lblPresetHintT = new JLabel(TmmResourceBundle.getString("Settings.preset.desc"));
        panelPresets.add((Component)lblPresetHintT, "cell 1 0 7 1");
        this.btnPresetKodi = new JButton("Kodi v17+");
        panelPresets.add((Component)this.btnPresetKodi, "cell 2 1,growx");
        this.btnPresetXbmc = new JButton("XBMC/Kodi <v17");
        panelPresets.add((Component)this.btnPresetXbmc, "cell 4 1,growx");
        this.btnPresetPlex = new JButton("Plex");
        panelPresets.add((Component)this.btnPresetPlex, "cell 2 2,growx");
        this.btnPresetJellyfin = new JButton("Jellyfin");
        panelPresets.add((Component)this.btnPresetJellyfin, "cell 4 2,growx");
        this.btnPresetEmby = new JButton("Emby");
        panelPresets.add((Component)this.btnPresetEmby, "cell 6 2,growx");
        this.btnPresetMediaPortal1 = new JButton("MediaPortal 1.x");
        panelPresets.add((Component)this.btnPresetMediaPortal1, "cell 2 3,growx");
        this.btnPresetMediaPortal2 = new JButton("MediaPortal 2.x");
        panelPresets.add((Component)this.btnPresetMediaPortal2, "cell 4 3,growx");
        this.add((Component)collapsiblePanel, "cell 0 2,growx,wmin 0");
        this.chckbxRenameAfterScrape = new JCheckBox(TmmResourceBundle.getString("Settings.tvshow.automaticrename"));
        panelAutomaticTasks.add((Component)this.chckbxRenameAfterScrape, "cell 1 0 2 1");
        JLabel lblAutomaticRenameHint = new JLabel(IconManager.HINT);
        lblAutomaticRenameHint.setToolTipText(TmmResourceBundle.getString("Settings.tvshow.automaticrename.desc"));
        panelAutomaticTasks.add((Component)lblAutomaticRenameHint, "cell 1 0 2 1");
        this.chckbxARDAfterScrape = new JCheckBox(TmmResourceBundle.getString("Settings.tvshow.automaticard"));
        panelAutomaticTasks.add((Component)this.chckbxARDAfterScrape, "cell 1 1 2 1");
        JLabel lblAutomaticARDHint = new JLabel(IconManager.HINT);
        lblAutomaticARDHint.setToolTipText(TmmResourceBundle.getString("Settings.tvshow.automaticard.desc"));
        panelAutomaticTasks.add((Component)lblAutomaticARDHint, "cell 1 1 2 1");
        this.chckbxTraktTv = new JCheckBox(TmmResourceBundle.getString("Settings.trakt"));
        panelAutomaticTasks.add((Component)this.chckbxTraktTv, "cell 1 2 2 1");
        this.btnClearTraktTvShows = new JButton(TmmResourceBundle.getString("Settings.trakt.cleartvshows"));
        panelAutomaticTasks.add((Component)this.btnClearTraktTvShows, "cell 1 2 2 1");
        this.chckbxTraktCollection = new JCheckBox(TmmResourceBundle.getString("Settings.trakt.collection"));
        panelAutomaticTasks.add((Component)this.chckbxTraktCollection, "cell 2 4");
        this.chckbxTraktWatched = new JCheckBox(TmmResourceBundle.getString("Settings.trakt.watched"));
        panelAutomaticTasks.add((Component)this.chckbxTraktWatched, "cell 2 4");
        this.chckbxTraktRating = new JCheckBox(TmmResourceBundle.getString("Settings.trakt.rating"));
        panelAutomaticTasks.add((Component)this.chckbxTraktRating, "cell 2 5");
        this.chckbxAutoUpdateOnStart = new JCheckBox(TmmResourceBundle.getString("Settings.tvshow.automaticupdate"));
        panelAutomaticTasks.add((Component)this.chckbxAutoUpdateOnStart, "cell 1 7 2 1");
        JLabel lblAutomaticUpdateHint = new JLabel(IconManager.HINT);
        lblAutomaticUpdateHint.setToolTipText(TmmResourceBundle.getString("Settings.tvshow.automaticupdate.desc"));
        panelAutomaticTasks.add((Component)lblAutomaticUpdateHint, "cell 1 7 2 1");
        JPanel panelMisc = new JPanel();
        panelMisc.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][]"));
        TmmLabel lblMiscT = new TmmLabel(TmmResourceBundle.getString("Settings.misc"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelMisc, lblMiscT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#misc-settings"));
        this.add((Component)collapsiblePanel, "cell 0 4,growx,wmin 0");
        this.chckbxMetadataFromMediainfo = new JCheckBox(TmmResourceBundle.getString("Settings.usemediainfometadata"));
        panelMisc.add((Component)this.chckbxMetadataFromMediainfo, "cell 1 0 2 1");
        this.chckbxExtractArtworkFromVsmeta = new JCheckBox(TmmResourceBundle.getString("Settings.extractartworkfromvsmeta"));
        panelMisc.add((Component)this.chckbxExtractArtworkFromVsmeta, "cell 1 1 2 1");
        this.chckbxImageCache = new JCheckBox(TmmResourceBundle.getString("Settings.imagecacheimport"));
        panelMisc.add((Component)this.chckbxImageCache, "cell 1 2 2 1");
        JLabel lblBuildImageCacheHint = new JLabel(IconManager.HINT);
        lblBuildImageCacheHint.setToolTipText(TmmResourceBundle.getString("Settings.imagecacheimporthint"));
        panelMisc.add((Component)lblBuildImageCacheHint, "cell 1 2 2 1");
    }

    private <E extends ScraperMetadataConfig> void addMetadataCheckbox(JPanel panel, E config, Map<E, JCheckBox> map, GridBagConstraints gbc) {
        JCheckBox checkBox;
        if (StringUtils.isNotBlank((CharSequence)config.getToolTip())) {
            checkBox = new JHintCheckBox(config.getDescription());
            checkBox.setToolTipText(config.getToolTip());
            ((JHintCheckBox)checkBox).setHintIcon(IconManager.HINT);
        } else {
            checkBox = new JCheckBox(config.getDescription());
        }
        map.put(config, checkBox);
        if (gbc.gridx >= 7) {
            gbc.gridx = 1;
            ++gbc.gridy;
        }
        panel.add((Component)checkBox, gbc.clone());
        ++gbc.gridx;
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"syncTrakt");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (Object)this.chckbxTraktTv, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowSettingsBeanProperty = BeanProperty.create((String)"buildImageCacheOnImport");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty, (Object)this.chckbxImageCache, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowSettingsBeanProperty_5 = BeanProperty.create((String)"renameAfterScrape");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_5, (Object)this.chckbxRenameAfterScrape, (Property)jCheckBoxBeanProperty);
        autoBinding_6.bind();
        BeanProperty tvShowSettingsBeanProperty_8 = BeanProperty.create((String)"extractArtworkFromVsmeta");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_8, (Object)this.chckbxExtractArtworkFromVsmeta, (Property)jCheckBoxBeanProperty);
        autoBinding_10.bind();
        BeanProperty tvShowSettingsBeanProperty_11 = BeanProperty.create((String)"updateOnStart");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_11, (Object)this.chckbxAutoUpdateOnStart, (Property)jCheckBoxBeanProperty);
        autoBinding_11.bind();
        BeanProperty tvShowSettingsBeanProperty_9 = BeanProperty.create((String)"useMediainfoMetadata");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_9, (Object)this.chckbxMetadataFromMediainfo, (Property)jCheckBoxBeanProperty);
        autoBinding_12.bind();
        BeanProperty jCheckBoxBeanProperty_1 = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_13 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxTraktTv, (Property)jCheckBoxBeanProperty, (Object)this.chckbxTraktCollection, (Property)jCheckBoxBeanProperty_1);
        autoBinding_13.bind();
        AutoBinding autoBinding_14 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxTraktTv, (Property)jCheckBoxBeanProperty, (Object)this.chckbxTraktWatched, (Property)jCheckBoxBeanProperty_1);
        autoBinding_14.bind();
        AutoBinding autoBinding_15 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxTraktTv, (Property)jCheckBoxBeanProperty, (Object)this.chckbxTraktRating, (Property)jCheckBoxBeanProperty_1);
        autoBinding_15.bind();
        BeanProperty tvShowSettingsBeanProperty_10 = BeanProperty.create((String)"syncTraktCollection");
        AutoBinding autoBinding_16 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_10, (Object)this.chckbxTraktCollection, (Property)jCheckBoxBeanProperty);
        autoBinding_16.bind();
        BeanProperty tvShowSettingsBeanProperty_12 = BeanProperty.create((String)"syncTraktWatched");
        AutoBinding autoBinding_17 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_12, (Object)this.chckbxTraktWatched, (Property)jCheckBoxBeanProperty);
        autoBinding_17.bind();
        BeanProperty tvShowSettingsBeanProperty_13 = BeanProperty.create((String)"syncTraktRating");
        AutoBinding autoBinding_18 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_13, (Object)this.chckbxTraktRating, (Property)jCheckBoxBeanProperty);
        autoBinding_18.bind();
        BeanProperty tvShowSettingsBeanProperty_20 = BeanProperty.create((String)"ardAfterScrape");
        AutoBinding autoBinding_20 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_20, (Object)this.chckbxARDAfterScrape, (Property)jCheckBoxBeanProperty);
        autoBinding_20.bind();
    }
}

