/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.TrailerQuality;
import org.tinymediamanager.core.TrailerSources;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.filenaming.TvShowTrailerNaming;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.ui.ScraperInTable;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.DocsButton;
import org.tinymediamanager.ui.components.ReadOnlyTextPane;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.panels.MediaScraperConfigurationPanel;
import org.tinymediamanager.ui.panels.ScrollablePanel;

public class TvShowTrailerSettingsPanel
extends JPanel {
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
    private final List<ScraperInTable> scrapers = ObservableCollections.observableList(new ArrayList());
    private final ItemListener checkBoxListener;
    private final ButtonGroup trailerFilenameButtonGroup = new ButtonGroup();
    private TmmTable tableTrailerScraper;
    private JTextPane tpScraperDescription;
    private JComboBox<TrailerSources> cbTrailerSource;
    private JComboBox<TrailerQuality> cbTrailerQuality;
    private JCheckBox checkBox;
    private JCheckBox chckbxAutomaticTrailerDownload;
    private JPanel panelScraperOptions;
    private JCheckBox cbTrailerFilename1;
    private JCheckBox cbTrailerFilename2;
    private JCheckBox cbTrailerFilename3;

    TvShowTrailerSettingsPanel() {
        this.checkBoxListener = e -> this.checkChanges();
        this.settings.addPropertyChangeListener(evt -> {
            if ("preset".equals(evt.getPropertyName())) {
                this.buildCheckBoxes();
            }
        });
        List<String> enabledTrailerProviders = this.settings.getTrailerScrapers();
        int selectedIndex = -1;
        int counter = 0;
        for (MediaScraper scraper : TvShowModuleManager.getInstance().getTvShowList().getAvailableTrailerScrapers()) {
            ScraperInTable trailerScraper = new ScraperInTable(scraper);
            if (enabledTrailerProviders.contains(trailerScraper.getScraperId())) {
                trailerScraper.setActive(true);
                if (selectedIndex < 0) {
                    selectedIndex = counter;
                }
            }
            this.scrapers.add(trailerScraper);
            ++counter;
        }
        this.initComponents();
        this.initDataBindings();
        TableColumnResizer.setMaxWidthForColumn(this.tableTrailerScraper, 0, 2);
        TableColumnResizer.setMaxWidthForColumn(this.tableTrailerScraper, 1, 10);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableTrailerScraper, 5);
        this.tableTrailerScraper.getModel().addTableModelListener(arg0 -> {
            if (arg0.getColumn() == 0) {
                int row = arg0.getFirstRow();
                ScraperInTable changedScraper = this.scrapers.get(row);
                if (changedScraper.getActive().booleanValue()) {
                    this.settings.addTvShowTrailerScraper(changedScraper.getScraperId());
                } else {
                    this.settings.removeTvShowTrailerScraper(changedScraper.getScraperId());
                }
            }
        });
        this.tableTrailerScraper.getSelectionModel().addListSelectionListener(e -> {
            int index = this.tableTrailerScraper.convertRowIndexToModel(this.tableTrailerScraper.getSelectedRow());
            if (index > -1) {
                this.panelScraperOptions.removeAll();
                if (this.scrapers.get(index).getMediaProvider().getProviderInfo().getConfig().hasConfig()) {
                    this.panelScraperOptions.add(new MediaScraperConfigurationPanel(this.scrapers.get(index).getMediaProvider()));
                }
                this.panelScraperOptions.revalidate();
            }
        });
        Font font = UIManager.getFont("Label.font");
        Color color = UIManager.getColor("Label.foreground");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; color: rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "); }";
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        ((HTMLDocument)this.tpScraperDescription.getDocument()).getStyleSheet().addRule(bodyRule);
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        if (counter > 0) {
            this.tableTrailerScraper.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
        this.buildCheckBoxes();
    }

    private void buildCheckBoxes() {
        this.cbTrailerFilename1.removeItemListener(this.checkBoxListener);
        this.cbTrailerFilename2.removeItemListener(this.checkBoxListener);
        this.cbTrailerFilename3.removeItemListener(this.checkBoxListener);
        this.clearSelection(this.cbTrailerFilename1, this.cbTrailerFilename2, this.cbTrailerFilename3);
        List<TvShowTrailerNaming> trailerFilenames = this.settings.getTrailerFilenames();
        if (trailerFilenames.contains(TvShowTrailerNaming.TVSHOW_TRAILER)) {
            this.cbTrailerFilename1.setSelected(true);
        } else if (trailerFilenames.contains(TvShowTrailerNaming.TVSHOWNAME_TRAILER)) {
            this.cbTrailerFilename2.setSelected(true);
        } else if (trailerFilenames.contains(TvShowTrailerNaming.TRAILERS_TVSHOWNAME_TRAILER)) {
            this.cbTrailerFilename3.setSelected(true);
        }
        this.cbTrailerFilename1.addItemListener(this.checkBoxListener);
        this.cbTrailerFilename2.addItemListener(this.checkBoxListener);
        this.cbTrailerFilename3.addItemListener(this.checkBoxListener);
    }

    private void clearSelection(JCheckBox ... checkBoxes) {
        for (JCheckBox checkBox : checkBoxes) {
            checkBox.setSelected(false);
        }
    }

    private void checkChanges() {
        this.settings.clearTrailerFilenames();
        if (this.cbTrailerFilename1.isSelected()) {
            this.settings.addTrailerFilename(TvShowTrailerNaming.TVSHOW_TRAILER);
        }
        if (this.cbTrailerFilename2.isSelected()) {
            this.settings.addTrailerFilename(TvShowTrailerNaming.TVSHOWNAME_TRAILER);
        }
        if (this.cbTrailerFilename3.isSelected()) {
            this.settings.addTrailerFilename(TvShowTrailerNaming.TRAILERS_TVSHOWNAME_TRAILER);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 0", "[60lp,grow]", "[][15lp!][]"));
        JPanel panelScraper = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][grow]", "[][shrink 0][]"));
        TmmLabel lblScraper = new TmmLabel(TmmResourceBundle.getString("scraper.trailer"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelScraper, lblScraper, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#trailer"));
        this.add((Component)collapsiblePanel, "cell 0 0,wmin 0,grow");
        this.tableTrailerScraper = new TmmTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                ScraperInTable scraper = TvShowTrailerSettingsPanel.this.scrapers.get(row);
                comp.setEnabled(scraper.isEnabled());
                return comp;
            }
        };
        this.tableTrailerScraper.setRowHeight(29);
        this.tableTrailerScraper.setShowGrid(true);
        panelScraper.add((Component)this.tableTrailerScraper, "cell 1 0,grow");
        JSeparator separator = new JSeparator();
        panelScraper.add((Component)separator, "cell 1 1,growx");
        ScrollablePanel panelScraperDetails = new ScrollablePanel();
        panelScraper.add((Component)panelScraperDetails, "cell 1 2,grow");
        panelScraperDetails.setLayout((LayoutManager)new MigLayout("insets 0", "[grow]", "[][grow]"));
        this.tpScraperDescription = new ReadOnlyTextPane();
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        panelScraperDetails.add((Component)this.tpScraperDescription, "cell 0 0,grow");
        this.panelScraperOptions = new ScrollablePanel();
        this.panelScraperOptions.setLayout(new FlowLayout(0));
        panelScraperDetails.add((Component)this.panelScraperOptions, "cell 0 1,grow");
        JPanel panelOptions = new JPanel();
        panelOptions.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", ""));
        TmmLabel lblOptionsT = new TmmLabel(TmmResourceBundle.getString("Settings.advancedoptions"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelOptions, lblOptionsT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#advanced-options-2"));
        this.add((Component)collapsiblePanel, "cell 0 2,growx, wmin 0");
        this.checkBox = new JCheckBox(TmmResourceBundle.getString("Settings.trailer.preferred"));
        panelOptions.add((Component)this.checkBox, "cell 1 0 2 1");
        JLabel lblTrailerSource = new JLabel(TmmResourceBundle.getString("Settings.trailer.source"));
        panelOptions.add((Component)lblTrailerSource, "cell 2 1");
        this.cbTrailerSource = new JComboBox();
        this.cbTrailerSource.setModel(new DefaultComboBoxModel<TrailerSources>(TrailerSources.values()));
        panelOptions.add(this.cbTrailerSource, "cell 2 1");
        JLabel lblTrailerQuality = new JLabel(TmmResourceBundle.getString("Settings.trailer.quality"));
        panelOptions.add((Component)lblTrailerQuality, "cell 2 2");
        this.cbTrailerQuality = new JComboBox();
        this.cbTrailerQuality.setModel(new DefaultComboBoxModel<TrailerQuality>(TrailerQuality.values()));
        panelOptions.add(this.cbTrailerQuality, "cell 2 2");
        this.chckbxAutomaticTrailerDownload = new JCheckBox(TmmResourceBundle.getString("Settings.trailer.automaticdownload"));
        panelOptions.add((Component)this.chckbxAutomaticTrailerDownload, "cell 1 3 2 1");
        JLabel lblAutomaticTrailerDownloadHint = new JLabel(TmmResourceBundle.getString("Settings.trailer.automaticdownload.hint"));
        panelOptions.add((Component)lblAutomaticTrailerDownloadHint, "cell 2 4");
        TmmFontHelper.changeFont((JComponent)lblAutomaticTrailerDownloadHint, TmmFontHelper.L2);
        JPanel panelTrailerFilenames = new JPanel();
        panelOptions.add((Component)panelTrailerFilenames, "cell 1 5 2 1");
        panelTrailerFilenames.setLayout((LayoutManager)new MigLayout("insets 0", "[][]", "[][][]"));
        JLabel lblTrailerFileNaming = new JLabel(TmmResourceBundle.getString("Settings.trailerFileNaming"));
        panelTrailerFilenames.add((Component)lblTrailerFileNaming, "cell 0 0");
        this.cbTrailerFilename1 = new JCheckBox("tvshow-trailer." + TmmResourceBundle.getString("Settings.artwork.extension"));
        this.trailerFilenameButtonGroup.add(this.cbTrailerFilename1);
        panelTrailerFilenames.add((Component)this.cbTrailerFilename1, "cell 1 0");
        this.cbTrailerFilename2 = new JCheckBox(TmmResourceBundle.getString("Settings.trailer.tvshowtitle") + "-trailer." + TmmResourceBundle.getString("Settings.artwork.extension"));
        this.trailerFilenameButtonGroup.add(this.cbTrailerFilename2);
        panelTrailerFilenames.add((Component)this.cbTrailerFilename2, "cell 1 1");
        this.cbTrailerFilename3 = new JCheckBox("trailers/" + TmmResourceBundle.getString("Settings.trailer.tvshowtitle") + "-trailer." + TmmResourceBundle.getString("Settings.artwork.extension"));
        this.trailerFilenameButtonGroup.add(this.cbTrailerFilename3);
        panelTrailerFilenames.add((Component)this.cbTrailerFilename3, "cell 1 2");
    }

    protected void initDataBindings() {
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.scrapers, (JTable)this.tableTrailerScraper);
        BeanProperty trailerScraperBeanProperty = BeanProperty.create((String)"active");
        jTableBinding.addColumnBinding((Property)trailerScraperBeanProperty).setColumnName(TmmResourceBundle.getString("Settings.active")).setColumnClass(Boolean.class);
        BeanProperty trailerScraperBeanProperty_1 = BeanProperty.create((String)"scraperLogo");
        jTableBinding.addColumnBinding((Property)trailerScraperBeanProperty_1).setColumnName(TmmResourceBundle.getString("mediafiletype.logo")).setEditable(false).setColumnClass(ImageIcon.class);
        BeanProperty trailerScraperBeanProperty_2 = BeanProperty.create((String)"scraperName");
        jTableBinding.addColumnBinding((Property)trailerScraperBeanProperty_2).setColumnName(TmmResourceBundle.getString("metatag.name")).setEditable(false).setColumnClass(String.class);
        jTableBinding.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.scraperDescription");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableTrailerScraper, (Property)jTableBeanProperty, (Object)this.tpScraperDescription, (Property)jTextPaneBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowSettingsBeanProperty = BeanProperty.create((String)"trailerSource");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty, this.cbTrailerSource, (Property)jComboBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowSettingsBeanProperty_1 = BeanProperty.create((String)"trailerQuality");
        BeanProperty jComboBoxBeanProperty_1 = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_1, this.cbTrailerQuality, (Property)jComboBoxBeanProperty_1);
        autoBinding_2.bind();
        BeanProperty tvShowSettingsBeanProperty_2 = BeanProperty.create((String)"useTrailerPreference");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_2, (Object)this.checkBox, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty tvShowSettingsBeanProperty_3 = BeanProperty.create((String)"automaticTrailerDownload");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_3, (Object)this.chckbxAutomaticTrailerDownload, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
    }
}

