/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.wizard;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.TmmModuleManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.tasks.MovieUpdateDatasourceTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.tasks.TvShowUpdateDatasourceTask;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.wizard.DisclaimerPanel;
import org.tinymediamanager.ui.wizard.EntrancePanel;
import org.tinymediamanager.ui.wizard.MovieScraperPanel;
import org.tinymediamanager.ui.wizard.MovieSourcePanel;
import org.tinymediamanager.ui.wizard.TvShowScraperPanel;
import org.tinymediamanager.ui.wizard.TvShowSourcePanel;
import org.tinymediamanager.ui.wizard.UiSettingsPanel;

public class TinyMediaManagerWizard
extends TmmDialog {
    private static final long serialVersionUID = 1112053710541745443L;
    private final List<JPanel> panels;
    private int activePanelIndex = 0;
    private JButton btnBack;
    private JButton btnNext;
    private JButton btnFinish;
    private JPanel panelContent;

    public TinyMediaManagerWizard() {
        super("tinyMediaManager Setup Wizard", "wizard");
        this.setMinimumSize(new Dimension(800, 600));
        this.initComponents();
        this.panels = new ArrayList<JPanel>();
        this.panels.add(new EntrancePanel());
        this.panels.add(new DisclaimerPanel(this));
        this.panels.add(new UiSettingsPanel());
        this.panels.add(new MovieSourcePanel());
        this.panels.add(new MovieScraperPanel());
        this.panels.add(new TvShowSourcePanel());
        this.panels.add(new TvShowScraperPanel());
        for (int i = 0; i < this.panels.size(); ++i) {
            JPanel panel = this.panels.get(i);
            this.panelContent.add((Component)panel, "" + i);
        }
        this.btnBack.setEnabled(false);
        this.btnFinish.setVisible(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Utils.deleteFileSafely(Paths.get("data", "tmm.json"));
                System.exit(0);
            }
        });
    }

    private void initComponents() {
        JPanel panelSizing = new JPanel();
        this.getContentPane().add((Component)panelSizing, "Center");
        panelSizing.setLayout((LayoutManager)new MigLayout("", "[650lp:850lp,grow]", "[450lp:550lp,grow]"));
        this.panelContent = new JPanel();
        this.panelContent.setLayout(new CardLayout());
        panelSizing.add((Component)this.panelContent, "cell 0 0,grow");
        this.btnBack = new JButton(new BackAction());
        this.addButton(this.btnBack);
        this.btnNext = new JButton(new NextAction());
        this.addButton(this.btnNext);
        this.btnFinish = new JButton(new FinishAction());
        this.addButton(this.btnFinish);
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            TmmModuleManager.getInstance().saveSettings();
        }
        super.setVisible(visible);
    }

    JButton getBtnBack() {
        return this.btnBack;
    }

    JButton getBtnNext() {
        return this.btnNext;
    }

    JButton getBtnFinish() {
        return this.btnFinish;
    }

    @Override
    public void pack() {
    }

    private class FinishAction
    extends AbstractAction {
        private static final long serialVersionUID = 8047070989186510289L;

        public FinishAction() {
            this.putValue("Name", TmmResourceBundle.getString("wizard.finish"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TmmThreadPool task;
            MovieModuleManager.getInstance().getSettings().firePropertyChange("wizard", false, true);
            TvShowModuleManager.getInstance().getSettings().firePropertyChange("wizard", false, true);
            TinyMediaManagerWizard.this.setVisible(false);
            if (!MovieModuleManager.getInstance().getSettings().getMovieDataSource().isEmpty()) {
                task = new MovieUpdateDatasourceTask();
                TmmTaskManager.getInstance().addMainTask(task);
            }
            if (!TvShowModuleManager.getInstance().getSettings().getTvShowDataSource().isEmpty()) {
                task = new TvShowUpdateDatasourceTask();
                TmmTaskManager.getInstance().addMainTask(task);
            }
        }
    }

    private class NextAction
    extends AbstractAction {
        private static final long serialVersionUID = -7813935881525980050L;

        public NextAction() {
            this.putValue("Name", TmmResourceBundle.getString("wizard.next"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ++TinyMediaManagerWizard.this.activePanelIndex;
            if (TinyMediaManagerWizard.this.panels.size() == TinyMediaManagerWizard.this.activePanelIndex + 1) {
                TinyMediaManagerWizard.this.btnNext.setEnabled(false);
                TinyMediaManagerWizard.this.btnFinish.setVisible(true);
            }
            TinyMediaManagerWizard.this.btnBack.setEnabled(true);
            CardLayout cl = (CardLayout)TinyMediaManagerWizard.this.panelContent.getLayout();
            cl.show(TinyMediaManagerWizard.this.panelContent, "" + TinyMediaManagerWizard.this.activePanelIndex);
            TinyMediaManagerWizard.this.panelContent.revalidate();
        }
    }

    private class BackAction
    extends AbstractAction {
        private static final long serialVersionUID = -510135441507847318L;

        public BackAction() {
            this.putValue("Name", TmmResourceBundle.getString("wizard.back"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            --TinyMediaManagerWizard.this.activePanelIndex;
            if (TinyMediaManagerWizard.this.activePanelIndex == 0) {
                TinyMediaManagerWizard.this.btnBack.setEnabled(false);
            }
            TinyMediaManagerWizard.this.btnNext.setEnabled(true);
            TinyMediaManagerWizard.this.btnFinish.setVisible(false);
            CardLayout cl = (CardLayout)TinyMediaManagerWizard.this.panelContent.getLayout();
            cl.show(TinyMediaManagerWizard.this.panelContent, "" + TinyMediaManagerWizard.this.activePanelIndex);
            TinyMediaManagerWizard.this.panelContent.revalidate();
        }
    }
}

