/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.wizard;

import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;

class UiSettingsPanel
extends JPanel {
    private static final long serialVersionUID = -1241134514329815223L;
    private static final Logger LOGGER = LoggerFactory.getLogger(UiSettingsPanel.class);
    private static final Integer[] DEFAULT_FONT_SIZES = new Integer[]{12, 14, 16, 18, 20, 22, 24, 26, 28};
    private Settings settings = Settings.getInstance();
    private List<LocaleComboBox> locales = new ArrayList<LocaleComboBox>();
    private JComboBox cbLanguage;
    private JRadioButton rdbtnLight;
    private JRadioButton rdbtnDark;
    private JComboBox cbFontSize;
    private JComboBox cbFontFamily;

    public UiSettingsPanel() {
        LocaleComboBox actualLocale = null;
        Locale settingsLang = Utils.getLocaleFromLanguage(Settings.getInstance().getLanguage());
        for (Locale l : Utils.getLanguages()) {
            LocaleComboBox localeComboBox = new LocaleComboBox(l);
            this.locales.add(localeComboBox);
            if (!l.equals(settingsLang)) continue;
            actualLocale = localeComboBox;
        }
        this.initComponents();
        if (actualLocale != null) {
            this.cbLanguage.setSelectedItem(actualLocale);
        }
        this.cbFontFamily.setSelectedItem(this.settings.getFontFamily());
        int index = this.cbFontFamily.getSelectedIndex();
        if (index < 0) {
            this.cbFontFamily.setSelectedItem("Dialog");
            index = this.cbFontFamily.getSelectedIndex();
        }
        if (index < 0) {
            this.cbFontFamily.setSelectedIndex(0);
        }
        this.cbFontSize.setSelectedItem(this.settings.getFontSize());
        index = this.cbFontSize.getSelectedIndex();
        if (index < 0) {
            this.cbFontSize.setSelectedIndex(0);
        }
        if ("Dark".equals(this.settings.getTheme())) {
            this.rdbtnDark.setSelected(true);
        } else {
            this.rdbtnLight.setSelected(true);
        }
        ActionListener actionListener = e -> this.checkChanges();
        this.cbLanguage.addActionListener(actionListener);
        this.cbFontFamily.addActionListener(actionListener);
        this.cbFontSize.addActionListener(actionListener);
        this.rdbtnLight.addActionListener(actionListener);
        this.rdbtnDark.addActionListener(actionListener);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[20lp!][200lp,grow][200lp,grow]", "[][][10lp!][][10lp!][][grow][][10lp!][][][]"));
        JLabel lblUiSettings = new JLabel(TmmResourceBundle.getString("wizard.ui"));
        TmmFontHelper.changeFont(lblUiSettings, 1.3333, 1);
        this.add((Component)lblUiSettings, "cell 0 0 3 1,growx");
        ReadOnlyTextArea taSettingsHint = new ReadOnlyTextArea(TmmResourceBundle.getString("wizard.ui.hint"));
        this.add((Component)taSettingsHint, "cell 1 1 2 1,growx");
        JLabel lblLanguageT = new JLabel(TmmResourceBundle.getString("Settings.language"));
        this.add((Component)lblLanguageT, "flowx,cell 1 3 2 1");
        this.cbLanguage = new JComboBox<Object>(this.locales.toArray());
        this.add((Component)this.cbLanguage, "cell 1 3 2 1");
        JLabel lblThemeT = new JLabel(TmmResourceBundle.getString("Settings.uitheme"));
        this.add((Component)lblThemeT, "cell 1 5");
        ImageLabel lblLight = new ImageLabel(false);
        try (InputStream is = UiSettingsPanel.class.getResourceAsStream("light.png");){
            lblLight.setOriginalImage(IOUtils.toByteArray((InputStream)is));
        }
        catch (Exception e) {
            LOGGER.error("could not load image: {}", (Object)e.getMessage());
        }
        this.add((Component)lblLight, "cell 1 6, grow");
        ImageLabel lblDark = new ImageLabel(false);
        try (InputStream is = UiSettingsPanel.class.getResourceAsStream("dark.png");){
            lblDark.setOriginalImage(IOUtils.toByteArray((InputStream)is));
        }
        catch (Exception e) {
            LOGGER.error("could not load image: {}", (Object)e.getMessage());
        }
        this.add((Component)lblDark, "cell 2 6, grow");
        ButtonGroup buttonGroup = new ButtonGroup();
        this.rdbtnLight = new JRadioButton(TmmResourceBundle.getString("Settings.uitheme.light"));
        buttonGroup.add(this.rdbtnLight);
        this.add((Component)this.rdbtnLight, "cell 1 7,alignx center");
        this.rdbtnDark = new JRadioButton(TmmResourceBundle.getString("Settings.uitheme.dark"));
        buttonGroup.add(this.rdbtnDark);
        this.add((Component)this.rdbtnDark, "cell 2 7,alignx center");
        JLabel lblFontT = new JLabel(TmmResourceBundle.getString("Settings.font"));
        this.add((Component)lblFontT, "flowx,cell 1 9 2 1");
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.cbFontFamily = new JComboBox<String>(env.getAvailableFontFamilyNames());
        this.add((Component)this.cbFontFamily, "cell 1 9 2 1");
        JLabel lblSize = new JLabel(TmmResourceBundle.getString("Settings.fontsize"));
        this.add((Component)lblSize, "flowx,cell 1 10");
        this.cbFontSize = new JComboBox<Integer>(DEFAULT_FONT_SIZES);
        this.add((Component)this.cbFontSize, "cell 1 10");
        ReadOnlyTextArea taFontHint = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.fonts.hint"));
        this.add((Component)taFontHint, "cell 1 11 2 1,grow");
    }

    private void checkChanges() {
        String fontFamily;
        String theme;
        Locale actualLocale2;
        Locale locale;
        LocaleComboBox loc = (LocaleComboBox)this.cbLanguage.getSelectedItem();
        if (loc != null && !(locale = loc.loc).equals(actualLocale2 = Utils.getLocaleFromLanguage(this.settings.getLanguage()))) {
            this.settings.setLanguage(locale.toString());
        }
        if (!(theme = this.rdbtnDark.isSelected() ? "Dark" : "Light").equals(this.settings.getTheme())) {
            this.settings.setTheme(theme);
            try {
                TmmUIHelper.setTheme();
                TmmUIHelper.updateUI();
            }
            catch (Exception actualLocale2) {
                // empty catch block
            }
        }
        boolean fontChanged = false;
        Integer fontSize = (Integer)this.cbFontSize.getSelectedItem();
        if (fontSize != null && fontSize.intValue() != this.settings.getFontSize()) {
            this.settings.setFontSize(fontSize);
            fontChanged = true;
        }
        if ((fontFamily = (String)this.cbFontFamily.getSelectedItem()) != null && !fontFamily.equals(this.settings.getFontFamily())) {
            this.settings.setFontFamily(fontFamily);
            fontChanged = true;
        }
        if (fontChanged) {
            Font font = UIManager.getFont("defaultFont");
            Font newFont = new Font(fontFamily, font.getStyle(), fontSize);
            UIManager.put("defaultFont", newFont);
            TmmUIHelper.updateUI();
        }
    }

    private class LocaleComboBox {
        private Locale loc;
        private List<Locale> countries;

        LocaleComboBox(Locale loc) {
            this.loc = loc;
            this.countries = LocaleUtils.countriesByLanguage((String)loc.getLanguage().toLowerCase(Locale.ROOT));
        }

        public Locale getLocale() {
            return this.loc;
        }

        public String toString() {
            if (this.loc.getLanguage().equalsIgnoreCase(this.loc.getCountry())) {
                return this.loc.getDisplayLanguage(this.loc);
            }
            if (this.loc.toString().equals("en_US")) {
                return this.loc.getDisplayLanguage(this.loc);
            }
            if (this.countries.size() == 1) {
                return this.loc.getDisplayLanguage(this.loc);
            }
            if (StringUtils.isNotBlank((CharSequence)this.loc.getDisplayCountry(this.loc))) {
                return this.loc.getDisplayLanguage(this.loc) + " (" + this.loc.getDisplayCountry(this.loc) + ")";
            }
            return this.loc.getDisplayLanguage(this.loc);
        }
    }
}

