/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.updater;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.scraper.util.UrlUtil;

public class UpdateCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateCheck.class);
    private String changelog = "";
    private boolean forceUpdate = false;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isUpdateAvailable() {
        if (ReleaseInfo.isGitBuild()) {
            return false;
        }
        Path getdownFile = Paths.get("getdown.txt", new String[0]);
        Path digestFile = Paths.get("digest.txt", new String[0]);
        LOGGER.info("Checking for updates...");
        ArrayList<String> updateUrls = new ArrayList<String>();
        try (Scanner scanner = new Scanner(getdownFile.toFile());){
            while (scanner.hasNextLine()) {
                String[] kv = scanner.nextLine().split("=");
                if (!"appbase".equals(kv[0].trim()) && !"mirror".equals(kv[0].trim())) continue;
                updateUrls.add(kv[1].trim());
            }
            boolean valid = false;
            String remoteDigest = "";
            String remoteUrl = "";
            for (String string2 : updateUrls) {
                void string;
                if (!string2.endsWith("/")) {
                    String exception = string2 + "/";
                }
                String url = (String)string + "digest.txt";
                LOGGER.trace("Checking {}", (Object)string);
                try {
                    remoteDigest = UrlUtil.getStringFromUrl(url);
                    if (remoteDigest != null && remoteDigest.contains("tmm.jar")) {
                        remoteDigest = remoteDigest.trim();
                        valid = true;
                        remoteUrl = string;
                    }
                }
                catch (InterruptedIOException | InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    LOGGER.warn("Unable to download from url {} - {}", (Object)url, (Object)e.getMessage());
                }
                if (!valid) continue;
            }
            if (!valid) {
                throw new IOException("Error downloading remote checksum information.");
            }
            String localDigest = "";
            try {
                localDigest = Utils.readFileToString(digestFile).trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!localDigest.equals(remoteDigest)) {
                LOGGER.info("Update needed...");
                String string = UrlUtil.getStringFromUrl(remoteUrl + "getdown.txt");
                if (string.contains("forceUpdate")) {
                    this.forceUpdate = true;
                }
                this.changelog = UrlUtil.getStringFromUrl(remoteUrl + "changelog.txt");
                boolean bl = true;
                return bl;
            }
            LOGGER.info("Already up2date :)");
            return false;
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Update task failed badly! {}", (Object)e.getMessage());
            try {
                LOGGER.info("Trying fallback...");
                Object fallback = "https://www.tinymediamanager.org";
                fallback = ReleaseInfo.isPreRelease() ? (String)fallback + "/getdown_prerelease.txt" : (ReleaseInfo.isNightly() ? (String)fallback + "/getdown_nightly.txt" : (String)fallback + "/getdown.txt");
                String gd = UrlUtil.getStringFromUrl((String)fallback);
                if (StringUtils.isBlank((CharSequence)gd)) throw new IOException("could not even download our fallback");
                if (!gd.contains("appbase")) {
                    throw new IOException("could not even download our fallback");
                }
                Utils.writeStringToFile(getdownFile, gd);
                return true;
            }
            catch (InterruptedIOException | InterruptedException e2) {
                Thread.currentThread().interrupt();
                return false;
            }
            catch (Exception e2) {
                LOGGER.error("Update fallback failed - {}", (Object)e2.getMessage());
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "Update check failed :(", e2.getMessage()));
            }
        }
        return false;
    }

    public String getChangelog() {
        return this.changelog;
    }

    public boolean isForcedUpdate() {
        return this.forceUpdate;
    }
}

