--@Author: Alex2009, Sven777b
--@Web: www.ls-landtechnik.de, www.alex2009.de

-- Basis fr eigene "Placeables" by Alex2009 & Sven777b, Spezifikation "PlaceableTipTrigger" by rafftnix. (February 2013) Erlaubnis dafr von Sven777b erhalten.


PlaceableTipTrigger = {};
PlaceableTipTrigger_mt = Class(PlaceableTipTrigger, Placeable);
InitObjectClass(PlaceableTipTrigger, "PlaceableTipTrigger");

function PlaceableTipTrigger:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, PlaceableTipTrigger_mt);
    registerObjectClassName(self, "PlaceableTipTrigger");
	g_currentMission:addTipTrigger(self);
    return self;
end;

function PlaceableTipTrigger:delete()
	if self.mapHotspot ~= nil then
		g_currentMission.missionPDA:deleteMapHotspot(self.mapHotspot);
	end;
	
	for k, v in pairs(g_currentMission.trailerTipTriggers) do
		for a=1, table.getn(v) do
			if v[a] == self then
				g_currentMission.trailerTipTriggers[k] = nil;
				break;
			end;
		end;
	end;
	
	g_currentMission:removeTipTrigger(self);
	if self.triggerId ~= 0 then
		removeTrigger(self.triggerId);
		removeTrigger(self.destroyerTriggerId);
		Utils.deleteParticleSystem(self.particleSystems);
	end;
   
    unregisterObjectClassName(self);
    PlaceableTipTrigger:superClass().delete(self);
end;

function PlaceableTipTrigger:deleteFinal()
    PlaceableTipTrigger:superClass().deleteFinal(self);
end;

function PlaceableTipTrigger:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not PlaceableTipTrigger:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
        return false;
    end;
    if not moveMode then
		local xmlFile = loadXMLFile("TempXML", xmlFilename);
		self.triggerNodeId = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.trigger#index"));
		TipTrigger.load(self, self.triggerNodeId);
		--BaleDestroyerTrigger
		self.destroyerTriggerId = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.baledestroyer#index"));
		BaleDestroyerTrigger:onCreate(self.destroyerTriggerId);
		--PS
		self.particleSystems = {};
		local i = 0;
		while true do
			local ps = string.format("placeable.particleSystems.system(%d)", i);
			local index = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, ps .. "#index"));
			if index == nil then
				break;
			end; 
			Utils.loadParticleSystem(xmlFile, self.particleSystems, ps, index, false, nil, self.baseDirectory)		
			i = i +1;		
		end;
		Utils.setEmittingState(self.particleSystems, true);
		delete(xmlFile);
	end;
    return true;
end;

function PlaceableTipTrigger:readStream(streamId, connection)
	PlaceableTipTrigger:superClass().readStream(self, streamId, connection);
	TipTrigger.readStream(self, streamId, connection)
end;

function PlaceableTipTrigger:writeStream(streamId, connection)
	PlaceableTipTrigger:superClass().writeStream(self, streamId, connection)
	TipTrigger.writeStream(self, streamId, connection)
end;

function PlaceableTipTrigger:readUpdateStream(streamId, timestamp, connection)
	PlaceableTipTrigger:superClass().readUpdateStream(self, streamId, timestamp, connection);
	TipTrigger.readStream(self, streamId, connection);
end;
  
function PlaceableTipTrigger:writeUpdateStream(streamId, connection, dirtyMask)
	PlaceableTipTrigger:superClass().writeUpdateStream(self, streamId, connection, dirtyMask);
	TipTrigger.writeStream(self, streamId, connection);
end;
 
function PlaceableTipTrigger:update(dt)
	TipTrigger.update(self, dt);
end;

function PlaceableTipTrigger:updateMoving(delta)
	TipTrigger.updateMoving(self, delta);
end;

function PlaceableTipTrigger:updateTrailerTipping(trailer, fillDelta, fillType)
	TipTrigger.updateTrailerTipping(self, trailer, fillDelta, fillType)
end;

function PlaceableTipTrigger:getTipInfoForTrailer(trailer, tipReferencePointIndex)
	return TipTrigger.getTipInfoForTrailer(self, trailer, tipReferencePointIndex);
end;

function PlaceableTipTrigger:getTipDistanceFromTrailer(trailer, tipReferencePointIndex)
	return TipTrigger.getTipDistanceFromTrailer(self, trailer, tipReferencePointIndex);
end;

function PlaceableTipTrigger:getNoAllowedText(trailer)
	return TipTrigger.getNoAllowedText(self, trailer);
end;

function PlaceableTipTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	TipTrigger.triggerCallback(self, triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
end;

registerPlaceableType("placeableTipTrigger", PlaceableTipTrigger);