/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.TestResult;

public class ObjectIdentifierTest
extends SimpleTest {
    @Override
    public String getName() {
        return "ObjectIdentifier";
    }

    @Override
    public void performTest() throws Exception {
        ASN1ObjectIdentifier oid3;
        byte[] encoded1;
        ASN1ObjectIdentifier oid2;
        ASN1ObjectIdentifier oid1;
        int j;
        int i = 0;
        while (i < 100) {
            j = 0;
            while (j < 100) {
                byte[] encoded2;
                ASN1ObjectIdentifier oid4;
                oid1 = new ASN1ObjectIdentifier("1.1." + i + "." + j);
                if (oid1 == (oid2 = ASN1ObjectIdentifier.getInstance(encoded1 = oid1.getEncoded()))) {
                    this.fail("Shouldn't be the same: " + oid1 + " " + oid2);
                }
                if (!oid1.equals(oid2)) {
                    this.fail("Should be equal: " + oid1 + " " + oid2);
                }
                if (oid2 != (oid3 = oid2.intern())) {
                    this.fail("Should be the same: " + oid2 + " " + oid3);
                }
                if (!oid2.equals(oid3)) {
                    this.fail("Should be equal: " + oid2 + " " + oid3);
                }
                if (oid3 != (oid4 = ASN1ObjectIdentifier.getInstance(encoded2 = oid3.getEncoded()))) {
                    this.fail("Should be taken from cache: " + oid3 + " " + oid4);
                }
                if (!oid3.equals(oid4)) {
                    this.fail("Should be equal: " + oid3 + " " + oid4);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 100) {
            j = 0;
            while (j < 100) {
                oid1 = new ASN1ObjectIdentifier("1.1.2." + i + "." + j);
                encoded1 = oid1.getEncoded();
                oid2 = ASN1ObjectIdentifier.getInstance(encoded1);
                oid3 = ASN1ObjectIdentifier.getInstance(encoded1);
                if (oid1 == oid2) {
                    this.fail("Shouldn't be the same: " + oid1 + " " + oid2);
                }
                if (oid2 == oid3) {
                    this.fail("Shouldn't be the same: " + oid2 + " " + oid3);
                }
                ++j;
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        ObjectIdentifierTest test = new ObjectIdentifierTest();
        TestResult result = test.perform();
        System.out.println(result);
    }
}

