/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class PKCS10Test
implements Test {
    byte[] req1 = Base64.decode("MIHoMIGTAgEAMC4xDjAMBgNVBAMTBVRlc3QyMQ8wDQYDVQQKEwZBbmFUb20xCzAJBgNVBAYTAlNFMFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBALlEt31Tzt2MlcOljvacJgzQVhmlMoqAOgqJ9Pgd3GuxZ7/WcIlgW4QCB7WZT21O1YoghwBhPDMcNGrHei9kHQkCAwEAAaAAMA0GCSqGSIb3DQEBBQUAA0EANDEI4ecNtJ3uHwGGlitNFq9WxcoZ0djbQJ5hABMotav6gtqlrwKXY2evaIrsNwkJtNdwwH18aQDUKCjOuBL38Q==");
    byte[] req2 = Base64.decode("MIIB6TCCAVICAQAwgagxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpDYWxpZm9ybmlhMRQwEgYDVQQHEwtTYW50YSBDbGFyYTEMMAoGA1UEChMDQUJCMVEwTwYDVQQLHEhQAAAAAAAAAG8AAAAAAAAAdwAAAAAAAABlAAAAAAAAAHIAAAAAAAAAIAAAAAAAAABUAAAAAAAAABxIAAAAAAAARAAAAAAAAAAxDTALBgNVBAMTBGJsdWUwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBANETRZ+6occCOrFxNhfKIp4CmMkxwhBNb7TnnahpbM9O0r4hrBPcfYuL7u9YX/jN0YNUP+/CiT39HhSe/bikaBPDEyNsl988I8vXpiEdgxYq/+LTgGHbjRsRYCkPtmzwBbuBldNF8bV7pu0v4UScSsExmGqqDlX1TbPU8KkPU1iTAgMBAAGgADANBgkqhkiG9w0BAQQFAAOBgQAFbrs9qUwh93CtETk7DeUD5HcdCnxauo1bck44snSV6MZVOCIGaYu1501kmhEvAtVVRr6SEHwimfQDDIjnrWwYsEr/DT6tkTZAbfRd3qUu3iKjT0H0vlUZp0hJ66mINtBM84uZFBfoXiWY8M3FuAnGmvy6ah/dYtJorTxLKiGkew==");

    @Override
    public String getName() {
        return "PKCS10";
    }

    public TestResult pkcs10Test(String testName, byte[] req) {
        try {
            ByteArrayInputStream bIn = new ByteArrayInputStream(req);
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            CertificationRequest r = new CertificationRequest((ASN1Sequence)aIn.readObject());
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            dOut.writeObject(r.toASN1Primitive());
            byte[] bytes = bOut.toByteArray();
            if (bytes.length != req.length) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": " + testName + " failed length test");
            }
            int i = 0;
            while (i != req.length) {
                if (bytes[i] != req[i]) {
                    return new SimpleTestResult(false, String.valueOf(this.getName()) + ": " + testName + " failed comparison test");
                }
                ++i;
            }
        }
        catch (Exception e) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Exception - " + testName + " " + e.toString());
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }

    @Override
    public TestResult perform() {
        TestResult res = this.pkcs10Test("basic CR", this.req1);
        if (!res.isSuccessful()) {
            return res;
        }
        return this.pkcs10Test("Universal CR", this.req2);
    }

    public static void main(String[] args) {
        PKCS10Test test = new PKCS10Test();
        TestResult result = test.perform();
        System.out.println(result);
    }
}

