/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.isismtt.x509.Restriction;
import org.bouncycastle.asn1.test.ASN1UnitTest;
import org.bouncycastle.asn1.x500.DirectoryString;

public class RestrictionUnitTest
extends ASN1UnitTest {
    @Override
    public String getName() {
        return "Restriction";
    }

    @Override
    public void performTest() throws Exception {
        DirectoryString res = new DirectoryString("test");
        Restriction restriction = new Restriction(res.getString());
        this.checkConstruction(restriction, res);
        try {
            Restriction.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(Restriction restriction, DirectoryString res) throws IOException {
        this.checkValues(restriction, res);
        restriction = Restriction.getInstance(restriction);
        this.checkValues(restriction, res);
        ASN1InputStream aIn = new ASN1InputStream(restriction.toASN1Primitive().getEncoded());
        ASN1String str = (ASN1String)((Object)aIn.readObject());
        restriction = Restriction.getInstance(str);
        this.checkValues(restriction, res);
    }

    private void checkValues(Restriction restriction, DirectoryString res) {
        this.checkMandatoryField("restriction", res, restriction.getRestriction());
    }

    public static void main(String[] args) {
        RestrictionUnitTest.runTest(new RestrictionUnitTest());
    }
}

