/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.params.DESParameters;
import org.bouncycastle.util.test.SimpleTest;

class DESParametersTest
extends SimpleTest {
    private static byte[] weakKeys = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 31, 31, 31, 31, 14, 14, 14, 14, -32, -32, -32, -32, -15, -15, -15, -15, -2, -2, -2, -2, -2, -2, -2, -2, 1, -2, 1, -2, 1, -2, 1, -2, 31, -32, 31, -32, 14, -15, 14, -15, 1, -32, 1, -32, 1, -15, 1, -15, 31, -2, 31, -2, 14, -2, 14, -2, 1, 31, 1, 31, 1, 14, 1, 14, -32, -2, -32, -2, -15, -2, -15, -2, -2, 1, -2, 1, -2, 1, -2, 1, -32, 31, -32, 31, -15, 14, -15, 14, -32, 1, -32, 1, -15, 1, -15, 1, -2, 31, -2, 31, -2, 14, -2, 14, 31, 1, 31, 1, 14, 1, 14, 1, -2, -32, -2, -32, -2, -15, -2, -15};

    DESParametersTest() {
    }

    @Override
    public String getName() {
        return "DESParameters";
    }

    @Override
    public void performTest() throws Exception {
        block7: {
            block6: {
                try {
                    DESParameters.isWeakKey(new byte[4], 0);
                    this.fail("no exception on small key");
                }
                catch (IllegalArgumentException e) {
                    if (e.getMessage().equals("key material too short.")) break block6;
                    this.fail("wrong exception");
                }
            }
            try {
                new DESParameters(weakKeys);
                this.fail("no exception on weak key");
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().equals("attempt to create weak DES key")) break block7;
                this.fail("wrong exception");
            }
        }
        int i = 0;
        while (i != weakKeys.length) {
            if (!DESParameters.isWeakKey(weakKeys, i)) {
                this.fail("weakKey test failed");
            }
            i += 8;
        }
    }
}

