/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls.test;

import java.io.IOException;
import java.io.PrintStream;
import org.bouncycastle.crypto.tls.AlertDescription;
import org.bouncycastle.crypto.tls.AlertLevel;
import org.bouncycastle.crypto.tls.PSKTlsServer;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.TlsEncryptionCredentials;
import org.bouncycastle.crypto.tls.TlsPSKIdentityManager;
import org.bouncycastle.crypto.tls.test.TlsTestUtils;
import org.bouncycastle.util.Strings;

class MockPSKTlsServer
extends PSKTlsServer {
    MockPSKTlsServer() {
        super(new MyIdentityManager());
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("TLS-PSK server raised alert: " + AlertLevel.getText(alertLevel) + ", " + AlertDescription.getText(alertDescription));
        if (message != null) {
            out.println("> " + message);
        }
        if (cause != null) {
            cause.printStackTrace(out);
        }
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("TLS-PSK server received alert: " + AlertLevel.getText(alertLevel) + ", " + AlertDescription.getText(alertDescription));
    }

    @Override
    public void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        byte[] pskIdentity = this.context.getSecurityParameters().getPSKIdentity();
        if (pskIdentity != null) {
            String name = Strings.fromUTF8ByteArray(pskIdentity);
            System.out.println("TLS-PSK server completed handshake for PSK identity: " + name);
        }
    }

    @Override
    protected int[] getCipherSuites() {
        return new int[]{49208, 179, 183, 141};
    }

    @Override
    protected ProtocolVersion getMaximumVersion() {
        return ProtocolVersion.TLSv12;
    }

    @Override
    protected ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.TLSv12;
    }

    @Override
    public ProtocolVersion getServerVersion() throws IOException {
        ProtocolVersion serverVersion = super.getServerVersion();
        System.out.println("TLS-PSK server negotiated " + serverVersion);
        return serverVersion;
    }

    @Override
    protected TlsEncryptionCredentials getRSAEncryptionCredentials() throws IOException {
        return TlsTestUtils.loadEncryptionCredentials(this.context, new String[]{"x509-server.pem", "x509-ca.pem"}, "x509-server-key.pem");
    }

    static class MyIdentityManager
    implements TlsPSKIdentityManager {
        MyIdentityManager() {
        }

        @Override
        public byte[] getHint() {
            return Strings.toUTF8ByteArray("hint");
        }

        @Override
        public byte[] getPSK(byte[] identity) {
            String name;
            if (identity != null && (name = Strings.fromUTF8ByteArray(identity)).equals("client")) {
                return new byte[16];
            }
            return null;
        }
    }
}

