/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.SecureRandom;
import org.bouncycastle.crypto.tls.BasicTlsPSKIdentity;
import org.bouncycastle.crypto.tls.TlsClient;
import org.bouncycastle.crypto.tls.TlsClientProtocol;
import org.bouncycastle.crypto.tls.TlsPSKIdentity;
import org.bouncycastle.crypto.tls.test.MockPSKTlsClient;

public class PSKTlsClientTest {
    private static final SecureRandom secureRandom = new SecureRandom();

    public static void main(String[] args) throws Exception {
        String line;
        InetAddress address = InetAddress.getLocalHost();
        int port = 5556;
        long time1 = System.currentTimeMillis();
        String psk_identity = "Client_identity";
        byte[] psk = new byte[]{97, 97, 97, 97, 97};
        BasicTlsPSKIdentity pskIdentity = new BasicTlsPSKIdentity(psk_identity, psk);
        MockPSKTlsClient client = new MockPSKTlsClient(null, (TlsPSKIdentity)pskIdentity);
        TlsClientProtocol protocol = PSKTlsClientTest.openTlsConnection(address, port, client);
        protocol.close();
        long time2 = System.currentTimeMillis();
        System.out.println("Elapsed 1: " + (time2 - time1) + "ms");
        client = new MockPSKTlsClient(client.getSessionToResume(), (TlsPSKIdentity)pskIdentity);
        protocol = PSKTlsClientTest.openTlsConnection(address, port, client);
        long time3 = System.currentTimeMillis();
        System.out.println("Elapsed 2: " + (time3 - time2) + "ms");
        OutputStream output = protocol.getOutputStream();
        output.write("GET / HTTP/1.1\r\n\r\n".getBytes("UTF-8"));
        output.flush();
        InputStream input = protocol.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        while ((line = reader.readLine()) != null) {
            System.out.println(">>> " + line);
        }
        protocol.close();
    }

    static TlsClientProtocol openTlsConnection(InetAddress address, int port, TlsClient client) throws IOException {
        Socket s = new Socket(address, port);
        TlsClientProtocol protocol = new TlsClientProtocol(s.getInputStream(), s.getOutputStream(), secureRandom);
        protocol.connect(client);
        return protocol;
    }
}

