/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.TestFailedException;

public abstract class BaseBlockCipherTest
extends SimpleTest {
    String algorithm;

    BaseBlockCipherTest(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public String getName() {
        return this.algorithm;
    }

    protected void oidTest(String[] oids, String[] names, int groupSize) throws Exception {
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        IvParameterSpec ivSpec = new IvParameterSpec(new byte[16]);
        int i = 0;
        while (i != oids.length) {
            Cipher c1 = Cipher.getInstance(oids[i], "BC");
            Cipher c2 = Cipher.getInstance(names[i], "BC");
            KeyGenerator kg = KeyGenerator.getInstance(oids[i], "BC");
            SecretKey k = kg.generateKey();
            if (names[i].indexOf("/ECB/") > 0) {
                c1.init(1, k);
                c2.init(2, k);
            } else {
                c1.init(1, (Key)k, ivSpec);
                c2.init(2, (Key)k, ivSpec);
            }
            byte[] result = c2.doFinal(c1.doFinal(data));
            if (!this.areEqual(data, result)) {
                this.fail("failed OID test");
            }
            if (k.getEncoded().length != 16 + i / groupSize * 8) {
                this.fail("failed key length test");
            }
            ++i;
        }
    }

    protected void wrapOidTest(String[] oids, String name) throws Exception {
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        int i = 0;
        while (i != oids.length) {
            Cipher c1 = Cipher.getInstance(oids[i], "BC");
            Cipher c2 = Cipher.getInstance(name, "BC");
            KeyGenerator kg = KeyGenerator.getInstance(oids[i], "BC");
            SecretKey k = kg.generateKey();
            c1.init(3, k);
            c2.init(4, k);
            Key wKey = c2.unwrap(c1.wrap(new SecretKeySpec(data, this.algorithm)), this.algorithm, 3);
            if (!this.areEqual(data, wKey.getEncoded())) {
                this.fail("failed wrap OID test");
            }
            if (k.getEncoded().length != 16 + i * 8) {
                this.fail("failed key length test");
            }
            ++i;
        }
    }

    protected void wrapTest(int id, String wrappingAlgorithm, byte[] kek, byte[] in, byte[] out) throws Exception {
        this.wrapTest(id, wrappingAlgorithm, kek, null, null, in, out);
    }

    protected void wrapTest(int id, String wrappingAlgorithm, byte[] kek, byte[] iv, SecureRandom rand, byte[] in, byte[] out) throws Exception {
        Cipher wrapper = Cipher.getInstance(wrappingAlgorithm, "BC");
        if (iv != null) {
            wrapper.init(3, (Key)new SecretKeySpec(kek, this.algorithm), new IvParameterSpec(iv), rand);
        } else {
            wrapper.init(3, (Key)new SecretKeySpec(kek, this.algorithm), rand);
        }
        try {
            byte[] cText = wrapper.wrap(new SecretKeySpec(in, this.algorithm));
            if (!this.areEqual(cText, out)) {
                this.fail("failed wrap test " + id + " expected " + new String(Hex.encode(out)) + " got " + new String(Hex.encode(cText)));
            }
        }
        catch (TestFailedException e) {
            throw e;
        }
        catch (Exception e) {
            this.fail("failed wrap test exception " + e.toString(), e);
        }
        if (iv != null) {
            wrapper.init(4, (Key)new SecretKeySpec(kek, this.algorithm), new IvParameterSpec(iv));
        } else {
            wrapper.init(4, new SecretKeySpec(kek, this.algorithm));
        }
        try {
            Key pText = wrapper.unwrap(out, this.algorithm, 3);
            if (!this.areEqual(pText.getEncoded(), in)) {
                this.fail("failed unwrap test " + id + " expected " + new String(Hex.encode(in)) + " got " + new String(Hex.encode(pText.getEncoded())));
            }
        }
        catch (Exception e) {
            this.fail("failed unwrap test exception " + e.toString(), e);
        }
    }
}

