/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.misc.NetscapeCertType;
import org.bouncycastle.asn1.misc.NetscapeRevocationURL;
import org.bouncycastle.asn1.misc.VerisignCzagExtension;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.test.CertPathTest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class CertPathValidatorTest
extends SimpleTest {
    private byte[] AC_PR = Base64.decode("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");
    private byte[] AC_RAIZ_ICPBRASIL = Base64.decode("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");
    private byte[] schefer = Base64.decode("MIIEnDCCBAWgAwIBAgICIPAwDQYJKoZIhvcNAQEEBQAwgcAxCzAJBgNVBAYTAkRFMQ8wDQYDVQQIEwZIRVNTRU4xGDAWBgNVBAcTDzY1MDA4IFdpZXNiYWRlbjEaMBgGA1UEChMRU0NIVUZBIEhPTERJTkcgQUcxGjAYBgNVBAsTEVNDSFVGQSBIT0xESU5HIEFHMSIwIAYDVQQDExlJbnRlcm5ldCBCZW51dHplciBTZXJ2aWNlMSowKAYJKoZIhvcNAQkBFht6ZXJ0aWZpa2F0QHNjaHVmYS1vbmxpbmUuZGUwHhcNMDQwMzMwMTEwODAzWhcNMDUwMzMwMTEwODAzWjCBnTELMAkGA1UEBhMCREUxCjAIBgNVBAcTASAxIzAhBgNVBAoTGlNIUyBJbmZvcm1hdGlvbnNzeXN0ZW1lIEFHMRwwGgYDVQQLExM2MDAvMDU5NDktNjAwLzA1OTQ5MRgwFgYDVQQDEw9TY2hldHRlciBTdGVmYW4xJTAjBgkqhkiG9w0BCQEWFlN0ZWZhbi5TY2hldHRlckBzaHMuZGUwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAJD095Bi76fkAMjJNTGPDiLPHmZXNsmakngDeS0juzKMeJA+TjXFouhYh6QyE4BlNf18fT4mInlgLefwf4t6meIWbiseeTo7VQdM+YrbXERMx2uHsRcgZMsiMYHMkVfYMK3SMJ4nhCmZxrBkoTRed4gXzVA1AA8YjjTqMyyjvt4TAgMBAAGjggHEMIIBwDAJBgNVHRMEAjAAMBEGCWCGSAGG+EIBAQQEAwIEsDALBgNVHQ8EBAMCBNAwOQYJYIZIAYb4QgENBCwWKlplcnRpZmlrYXQgbnVyIGZ1ZXIgU0NIVUZBLU9ubGluZSBndWVsdGlnLjAdBgNVHQ4EFgQUXReirhBfg0Yhf6MsBWoo/nPahGwwge0GA1UdIwSB5TCB4oAUf2UyCaBV9JUeG9lS1Yo6OFBUdEKhgcakgcMwgcAxCzAJBgNVBAYTAkRFMQ8wDQYDVQQIEwZIRVNTRU4xGDAWBgNVBAcTDzY1MDA4IFdpZXNiYWRlbjEaMBgGA1UEChMRU0NIVUZBIEhPTERJTkcgQUcxGjAYBgNVBAsTEVNDSFVGQSBIT0xESU5HIEFHMSIwIAYDVQQDExlJbnRlcm5ldCBCZW51dHplciBTZXJ2aWNlMSowKAYJKoZIhvcNAQkBFht6ZXJ0aWZpa2F0QHNjaHVmYS1vbmxpbmUuZGWCAQAwIQYDVR0RBBowGIEWU3RlZmFuLlNjaGV0dGVyQHNocy5kZTAmBgNVHRIEHzAdgRt6ZXJ0aWZpa2F0QHNjaHVmYS1vbmxpbmUuZGUwDQYJKoZIhvcNAQEEBQADgYEAWzZtN9XQ9uyrFXqSy3hViYwV751+XZr0YH5IFhIS+9ixNAu8orP3bxqTaMhpwoU7T/oSsyGGSkb3fhzclgUADbA2lrOIGkeB/m+FArTwRbwpqhCNTwZywOp0eDosgPjCX1t53BB/m/2EYkRiYdDGsot0kQPOVGSjQSQ4+/D+TM8=");
    private static final byte[] circCA = Base64.decode("MIIDTzCCAjegAwIBAgIDARAAMA0GCSqGSIb3DQEBBQUAMDkxCzAJBgNVBAYTAkZSMRAwDgYDVQQKEwdHSVAtQ1BTMRgwFgYDVQQLEw9HSVAtQ1BTIEFOT05ZTUUwHhcNMDQxMDExMDAwMDAxWhcNMTQxMjMxMjM1OTU5WjA5MQswCQYDVQQGEwJGUjEQMA4GA1UEChMHR0lQLUNQUzEYMBYGA1UECxMPR0lQLUNQUyBBTk9OWU1FMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA3WyWDwcM58aUhPX4ueI1mwETt3WdQtMfIdRiCXeBrjCkYCc7nIgCmGbnfTzXSplHRgKColWhq/Z+1rHYayje1gjAEU2+4/r1P2pnBmPgquDuguktCIbDtCcGZu0ylyKeHh37aeIKzkcmRSLRzvGf/eO3RdFksrvaPaSjqCVfGRXVDKK2uftE8rIFJE+bCqow6+WiaAaDDiJaSJPuu5hC1NA5jw0/BFodlCuAvl1GJ8A+TICkYWcSpKS9bkSC0i8xdGbSSk94shA1PdDvRdFMfFys8g4aupBXV8yqqEAUkBYmOtZSJckc3W4y2Gx53y7vY07Xh63mcgtJs2T82WJICwIDAQABo2AwXjAdBgNVHQ4EFgQU8c/PNNJaL0srd9SwHwgtvwPB/3cwDgYDVR0PAQH/BAQDAgIEMBkGA1UdIAQSMBAwDgYMKoF6AUcDBwgAAAABMBIGA1UdEwEB/wQIMAYBAf8CAQEwDQYJKoZIhvcNAQEFBQADggEBAHRjYDPJKlfUzID0YzajZpgR/i2ngJrJqYeaWCmwzBgNUPaduBKSGHmPVg21sfULMSnirnR+e90i/D0EVzLwQzcbjPDD/85rp9QDCeMxqqPe9ZCHGs2BpE/HOQMP0QfQ3/Kpk7SvOH/ZcpIf6+uE6lLBQYAGs5cxvtTGOzZkjCVFG+TrAnF4V5sNkn3maCWiYLmyqcnxtKEFSONy2bYqqudx/dBBlRrDbRfZ9XsCBdiXAHY1hFHldbfDs8rslmkXJi3fJC028HZYB6oiBX/JE7BbMk7bRnUfHSpP7Sjxeso2SY7Yit+hQDVAlqTDGmh6kLt/hQMpsOMry4vgBL6XHKw=");
    private static final byte[] circCRLCA = Base64.decode("MIIDXDCCAkSgAwIBAgIDASAAMA0GCSqGSIb3DQEBBQUAMDkxCzAJBgNVBAYTAkZSMRAwDgYDVQQKEwdHSVAtQ1BTMRgwFgYDVQQLEw9HSVAtQ1BTIEFOT05ZTUUwHhcNMDQxMDExMDAwMDAxWhcNMTQxMjMxMjM1OTU5WjA5MQswCQYDVQQGEwJGUjEQMA4GA1UEChMHR0lQLUNQUzEYMBYGA1UECxMPR0lQLUNQUyBBTk9OWU1FMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwfEcFK0g7Kfoo5f2IBF7VEd/AG+RVGSds0Yg+u2kNYu4k04HR/+tOdBQtJvyr4W5jrQKsC5XskeFWMyWaFKzAjZDWB52HWp/kiMivGcxnYDuYf5piukSC+d2+vL8YaAphDzVHPnxEKqoM/J66uUussDTqfcL3JC/Bc7kBwn4srrsZOsamMWTQQtEqVQxNN7AROSRsdiTt3hMOKditc9/NBNmjZWxgc7Twr/SaZ8CfN5wf2wuOl23knWL0QsJ0lSMBSBTzTcfAke4/jIT7d4nVMp3t7dsna8rt56pFK4wpRFGuCt+1P5gi51xxVSdI+JoNXv6zGO4o8YVaRpC5rQeGQIDAQABo20wazAfBgNVHSMEGDAWgBTxz8800lovSyt31LAfCC2/A8H/dzAdBgNVHQ4EFgQUGa3SbBrJx/wa2MQwhWPldwLw1+IwDgYDVR0PAQH/BAQDAgECMBkGA1UdIAQSMBAwDgYMKoF6AUcDBwgAAAABMA0GCSqGSIb3DQEBBQUAA4IBAQAPDpYe2WPYnXTLsXSIUREBNMLmg+/74Yhq9uOm5Hb5LVkDuHoEHGfmpXXEvucx5Ehu69hw+F4YSrd9wPjOiG8G6GXiRcrK8nE8XDvvV+E1HpJ7NKN4fSAoSb+0gliiq3aF15bvXP8nfespdd/x1xWQmpYCx/mJeuqONQv2/D/7hfRKYoDBaAkWGodenPFPVs6FxwnEuH2R+KWCUdA9L04v8JBeL3kZiALkU7+DCCm7A0imUAgeeArbAbfIPu6eDygm+XndZ9qi7o4OAntPxrqbeXFIbDrQ4GV1kpxnW+XpSGDd96SWKe715gxkkDBppR5IKYJwRb6O1TRQIf2F+muQ");
    private static final byte[] circCRL = Base64.decode("MIIB1DCBvQIBATANBgkqhkiG9w0BAQUFADA5MQswCQYDVQQGEwJGUjEQMA4GA1UEChMHR0lQLUNQUzEYMBYGA1UECxMPR0lQLUNQUyBBTk9OWU1FFw0xMDAxMDcwMzAwMTVaFw0xMDAxMTMwMzAwMTVaMACgTjBMMB8GA1UdIwQYMBaAFBmt0mwaycf8GtjEMIVj5XcC8NfiMAsGA1UdFAQEAgILgzAcBgNVHRIEFTATgRFhYy1naXBAZ2lwLWNwcy5mcjANBgkqhkiG9w0BAQUFAAOCAQEAtF1DdFl1MQvfvNkbrCPuppNYcHen4+za/ZDepKuwHsH/OpKuaDJc4LndRgd5IwzfpCHkQGztshK50bakN8oaYJgthKIOIJzR+fn6NMjftfR2a27Hdk2o3eQXRHQ360qMbpSyqPb3WfuBhxO2/DlLChJP+OxZIHtT/rNYgE0tlIv7swYi81Gq+DafzaZ9+A5tI0L2Gp/NUDsp5dF6PllAGiXQzl27qkcu+r50w+u0gul3nobXgbwPcMSYuWUz1lhA+uDn/EUWV4RSiJciCGSS10WCkFh1/YPo++mV15KDB0m+8chscrSu/bAlB19LxL/pCX3qr5iLE9ss3olVImyFZg==");
    static byte[] extEE = Base64.decode("MIICtDCCAh2gAwIBAgIBAzANBgkqhkiG9w0BAQUFADCBkjELMAkGA1UEBhMCQVUxKDAmBgNVBAoMH1RoZSBMZWdpb24gb2YgdGhlIEJvdW5jeSBDYXN0bGUxKDAmBgNVBAsMH0JvdW5jeSBJbnRlcm1lZGlhdGUgQ2VydGlmaWNhdGUxLzAtBgkqhkiG9w0BCQEWIGZlZWRiYWNrLWNyeXB0b0Bib3VuY3ljYXN0bGUub3JnMB4XDTE1MDMyNDAzNTEwOVoXDTE1MDUyMzAzNTEwOVowgZYxCzAJBgNVBAYTAkFVMSgwJgYDVQQKDB9UaGUgTGVnaW9uIG9mIHRoZSBCb3VuY3kgQ2FzdGxlMRIwEAYDVQQHDAlNZWxib3VybmUxGDAWBgNVBAMMD0VyaWMgSC4gRWNoaWRuYTEvMC0GCSqGSIb3DQEJARYgZmVlZGJhY2stY3J5cHRvQGJvdW5jeWNhc3RsZS5vcmcwWjANBgkqhkiG9w0BAQEFAANJADBGAkEAtKfkYXBXTxapcIKyK+WLaipil5hBm+EocqS9umJs+umQD3ar+xITnc5d5WVk+rK2VDFloEDGBoh0IOM9ke1+1wIBEaNaMFgwHQYDVR0OBBYEFNBs7G01g7xVEhsMyz7+1yamFmRoMB8GA1UdIwQYMBaAFJQIM28yQPeHN9rRIKrtLqduyckeMBYGA1UdJQEB/wQMMAoGCCsGAQUFBwMDMA0GCSqGSIb3DQEBBQUAA4GBAICrsNswvaXFMreUHHRHrhU4QqPOds8XJe0INx3v/5TfyjPPDMihMEm8WtWbVpFgFAqUQoZscf8cE/SO5375unYFgxrK+p2/je9E82VLF4Xb0cWizjQoWvvTmvFYjt43cGGXgySFLTrW87ju9uNFr/l4W9xvI0hoLI96vEW7Ccho");
    static byte[] extCA = Base64.decode("MIIDIzCCAoygAwIBAgIBAjANBgkqhkiG9w0BAQUFADBcMQswCQYDVQQGEwJBVTEoMCYGA1UECgwfVGhlIExlZ2lvbiBvZiB0aGUgQm91bmN5IENhc3RsZTEjMCEGA1UECwwaQm91bmN5IFByaW1hcnkgQ2VydGlmaWNhdGUwHhcNMTUwMzI0MDM1MTA5WhcNMTUwNTIzMDM1MTA5WjCBkjELMAkGA1UEBhMCQVUxKDAmBgNVBAoMH1RoZSBMZWdpb24gb2YgdGhlIEJvdW5jeSBDYXN0bGUxKDAmBgNVBAsMH0JvdW5jeSBJbnRlcm1lZGlhdGUgQ2VydGlmaWNhdGUxLzAtBgkqhkiG9w0BCQEWIGZlZWRiYWNrLWNyeXB0b0Bib3VuY3ljYXN0bGUub3JnMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCN4NETxec2lpyNKwR6JD+P4Y7a1kzenoQtNmkjDKSG98/d4fjuxU0ZBf/wSsyF5hCT4YDK3GzqQH8ZPUS7DpRJuNu0l4TNnjYmDDngapRymZeMbtgwByTohxmM/t4g8/veZY+ivQeL6Uajkr00nytJxIbiDEBViOMGcGyQFzCOaQIDAP//o4G9MIG6MB0GA1UdDgQWBBSUCDNvMkD3hzfa0SCq7S6nbsnJHjCBhAYDVR0jBH0we4AUwDYZB63EiJeoXnJvawnr5ebxKVyhYKReMFwxCzAJBgNVBAYTAkFVMSgwJgYDVQQKDB9UaGUgTGVnaW9uIG9mIHRoZSBCb3VuY3kgQ2FzdGxlMSMwIQYDVQQLDBpCb3VuY3kgUHJpbWFyeSBDZXJ0aWZpY2F0ZYIBATASBgNVHRMBAf8ECDAGAQH/AgEAMA0GCSqGSIb3DQEBBQUAA4GBAJqUlDjse7Og+7qkkFsiXHzQ8FxT82hzfcji8W7bPwZddCPBEluxCJiJBPYXWsLvwo6BEmCDzT9lLQZ+QZyL1fVbOVHiI24hAalbEBEIrEO4GXMD9spqRQ5yoTJ8CgZHTPo0rJkH/ebprp0YHtahVF440zBOvuLM0QTYpERgO2Oe");
    static byte[] extTrust = Base64.decode("MIICJTCCAY4CAQEwDQYJKoZIhvcNAQEFBQAwXDELMAkGA1UEBhMCQVUxKDAmBgNVBAoMH1RoZSBMZWdpb24gb2YgdGhlIEJvdW5jeSBDYXN0bGUxIzAhBgNVBAsMGkJvdW5jeSBQcmltYXJ5IENlcnRpZmljYXRlMB4XDTE1MDMyNDAzNTEwOVoXDTE1MDUyMzAzNTEwOVowXDELMAkGA1UEBhMCQVUxKDAmBgNVBAoMH1RoZSBMZWdpb24gb2YgdGhlIEJvdW5jeSBDYXN0bGUxIzAhBgNVBAsMGkJvdW5jeSBQcmltYXJ5IENlcnRpZmljYXRlMIGdMA0GCSqGSIb3DQEBAQUAA4GLADCBhwKBgQCyWdLW5ienaMlL42Fkwtn8edl6q5JTFA5b8XdRGXcx1vdUDSUJ57n/7gpwpuJtVuktLt1/hauoVgC2kInzX2vb88KY4FhCU12fBk5rA5HLfTBuCi0gxN+057SalkC96ibBCtacPwUAfOJRPO5Ez+AZmOYrbDY30/wDkQebJu421QIBETANBgkqhkiG9w0BAQUFAAOBgQCDNfqQnQbbmnGzZTl7ccWIyw7SPzWnijpKsQpuRNGkoXfkCcuQLZudytEFZGEL0cycNBnierjJWAn78zGpCQtab01r1GwytRMYz8qO5IIrhsJ4XNafNypYZbi0WtPa07UCQp8tipMbfQNLzSkvkIAaD5IfhdaWKLrSQJwmGg7YAg==");
    static byte[] extInvEE = Base64.decode("MIICJjCCAY+gAwIBAAIGAV3Y0TnDMA0GCSqGSIb3DQEBCwUAMBExDzANBgNVBAMMBktQMSBDQTAeFw0xNzA4MTIyMzM5MzJaFw0xNzA4MTMwMDA5MzdaMBExDzANBgNVBAMMBktQMSBFRTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAuOcqkp2+HBCuwRDwfR7kkUYXMdhScDG8m6A3Af6hpG86nAimNoVIQe3REaQ6IO0XSdd13rjjRwIXsUFLsrQhQJczF5JeyWXcaYqZyNNbUwFuLeSqOsLS63ltjOJYqOJRxY03Cr//baGWvxGXcRvHoZkg1nEXPcMZhgsy/9JxVoUCAwEAAaOBiDCBhTBABgNVHSMEOTA3gBSPMqzNmTdyjQmr9W1TSDW1h0ZzFaEXpBUwEzERMA8GA1UEAwwIS1AxIFJPT1SCBgFd2NE5wjAdBgNVHQ4EFgQUC1rtYrQdQkA3CLTeV1kbVIdysKQwEgYDVR0TAQH/BAgwBgEB/wIBADAOBgNVHQ8BAf8EBAMCAYYwDQYJKoZIhvcNAQELBQADgYEAGr841G7E84Ow9+fFGW1zzXeTRfxsafdT/bHXCS75bjF2YPitKLcRLkm92VPxANRXIpmt++3iU/oduWqkLsfXnfTGmCwtjj/XrCvkCBQ4GONwmegltJEThMud0XOEB1UN6tfTINfLYpbyfOdE/wLy4Rte0t43aOTTOBo+/SapYOE=");
    static byte[] extInvCA = Base64.decode("MIICKDCCAZGgAwIBAgIGAV3Y0TnCMA0GCSqGSIb3DQEBCwUAMBMxETAPBgNVBAMMCEtQMSBST09UMB4XDTE3MDgxMjIzMzkzMloXDTE3MDgxMzAwMDkzN1owETEPMA0GA1UEAwwGS1AxIENBMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC7Qd/cTP5S0GoPcomcZU5QlJcb1uWydvmQx3U6p4/KOZBhk6JXQeSzT8QZ/gd+9vfosA62SEX+dq7MvxxzeERxdIsVU0zZ1TrYNxlQjnYXiYRVXBczowsxseQ9oSGD94Y4buhrMAltmIHijdzGRVMY41FZmWqNXqsEwQXj6ULX+QIDAQABo4GIMIGFMEAGA1UdIwQ5MDeAFAbfd2S3aiwFww3/0ocLa6ULQjJMoRekFTATMREwDwYDVQQDDAhLUDEgUk9PVIIGAV3Y0TnBMB0GA1UdDgQWBBSPMqzNmTdyjQmr9W1TSDW1h0ZzFTASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB/wQEAwIBhjANBgkqhkiG9w0BAQsFAAOBgQCnmxQYy6LnvRSMxkTsGIQa4LB51O8skbWc4KYVDfcvTYQuvn6rE/ZoYf82jKXJzXksffanfjn/b38l4l8hwAcBQ8we9yjCkjO8OVDUlYiSGYUhH2ZJrl2+K2Z6wpakZ9Lz3pZ/PSS1FIsVd4I1jkexAdAm1+uMlfWXVt/uTZx98w==");
    static byte[] extInvTrust = Base64.decode("MIIBmjCCAQMCBgFd2NE5wTANBgkqhkiG9w0BAQsFADATMREwDwYDVQQDDAhLUDEgUk9PVDAeFw0xNzA4MTIyMzM5MzJaFw0xNzA4MTMwMDA5MzdaMBMxETAPBgNVBAMMCEtQMSBST09UMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC8U3p6Y9ah0yQ58wpI3H6vQPMdhN6Hh+zuiNzwX3AIpEspUFTfqXJ6EIhqh/EraDnLnoFBajzihwS1y6a+ZyXYKa5pxbFsslmzms+ozcTaJ4mSMiC+DHbGYdOAEzwx2nsEt7UKyrlnl5h2kQFusUPmnXXEorIxhpS2Lul+zEBo1wIDAQABMA0GCSqGSIb3DQEBCwUAA4GBABClwXaJ8S66GmeySf1thOPc1GxIHuubezIjcBbECLZQqn7iwuzp+eft1vtnqNP7BWM1xBZkSe+/2xUsArc1rb1ffZHF3k92+WLbpDh3+NsQIod/91HRWUuu/S2g9oMK4b7BH8JrmBgy3ewtpNZwOaKF613GPCeGv3ya5Z24vBu+");
    static byte[] extInvV2Trust = Base64.decode("MIIBmjCCAQMCBgFd2NhVgTANBgkqhkiG9w0BAQsFADATMREwDwYDVQQDDAhLUDEgUk9PVDAeFw0xNzA4MTIyMzQ3MThaFw0xNzA4MTMwMDE3MjNaMBMxETAPBgNVBAMMCEtQMSBST09UMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCQaASWM5avAAJ57eHQ2zQ0k/mAiYSOkRKDLEzptDPYfzuQtTdAlBPn7tsYx+Ylge4YQwtx5bQZbc3apinBK9tn+c++go0kUF1cec2bacYyFokSP2r48j6ZhlY4MYGfrvfWHULrG2JL2BMeuZVP+wiqXktXCEKVG1fh1m6RY0TJPwIDAQABMA0GCSqGSIb3DQEBCwUAA4GBAC9mXO2i2vltBZZa7RMkizvhzhsehDHbEqvJd2aoWE9JG4sDo2tiIVN5vbq9EWLZVga3ejFzmQ+FI1Ty0xX3fwDgvUyxsveGTs40xwA9TEgVk1KNTQQs+sLE9rRB7L0giKn2DDmHFsOPL1KwxdzqD7vYhJr5av3eAsJpMxF+Anyg");
    static byte[] extInvV2CA = Base64.decode("MIICKDCCAZGgAwIBAgIGAV3Y2FWCMA0GCSqGSIb3DQEBCwUAMBMxETAPBgNVBAMMCEtQMSBST09UMB4XDTE3MDgxMjIzNDcxOFoXDTE3MDgxMzAwMTcyM1owETEPMA0GA1UEAwwGS1AxIENBMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCgb8h3h9d/FzhIc+PMbF0vwdiDKw7N3dNyY6TrmzCMC1mYDXSKmxxDwNKZCKj6VSNfbTDqxYKlZMoGVT8Cl/iE/+XEhOKYLv73rzTqzdMizqcQTCvwps1enGxI5wPBYKGCMWrpJui5RWV9wH6hMvmzSSZq7bdWTvc/pIltCpIj8wIDAQABo4GIMIGFMEAGA1UdIwQ5MDeAFMOcs/uWpVOkGRQJrVIp6cN6tCJQoRekFTATMREwDwYDVQQDDAhLUDEgUk9PVIIGAV3Y2FWBMB0GA1UdDgQWBBTsZ2B5JbgKm9/up2hOcYVyOaM1SjASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB/wQEAwIBhjANBgkqhkiG9w0BAQsFAAOBgQBI8J1bKh/e+uEZtfngKMADS1PSHztAPFFKXgeIfYeJDRznnamtbheensdxrA+aoriJbJfHxmjecr4xA8+s0uN9GPtQ3+ad1K5Sg6mfzsXtNPf3xa9y0pIWOGZavr1s/QugoPLQxEiuHrvkHX5+sZlx47KoBQJ8LBRmJydeSvxz1g==");
    static byte[] extInvV2EE = Base64.decode("MIICJjCCAY+gAwIBAQIGAV3Y2FWDMA0GCSqGSIb3DQEBCwUAMBExDzANBgNVBAMMBktQMSBDQTAeFw0xNzA4MTIyMzQ3MThaFw0xNzA4MTMwMDE3MjNaMBExDzANBgNVBAMMBktQMSBFRTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAzWXxtMpnjz8Q1qTdwpB66W2D0vEHhqow2PTsvfQdENL4AFESE1C7Cj3lLBTei1vRHCnpM0jdNghBW8k/u2b2tqeeWLBqwul0tEGbjtUwkYV2WgtTGmiYZZFfMH35HIvqlZMwIIdZqz4lEdkPiAPEUOELvycpVDFnWjF0qah5LqsCAwEAAaOBiDCBhTBABgNVHSMEOTA3gBTsZ2B5JbgKm9/up2hOcYVyOaM1SqEXpBUwEzERMA8GA1UEAwwIS1AxIFJPT1SCBgFd2NhVgjAdBgNVHQ4EFgQUfeKdn63Gmlkub8m8bwjqJook5ywwEgYDVR0TAQH/BAgwBgEB/wIBADAOBgNVHQ8BAf8EBAMCAYYwDQYJKoZIhvcNAQELBQADgYEAco35KYLE683l53J6V1q2tcMV3EpM39tifkL7Kl38oX9d3SGiKkEO6YFeQekRyto0Z91mPq7Pe/oOfDrfsY3r9KX7oqnhOKBnnR/58atM9udVLvuLfCJpxiroAldSkhRKvHG5MrFwZyDcVkTZF4GDrP6bojp32wVfU5EYkfwcJN8=");
    static byte[] extInvVersionTrust = Base64.decode("MIIBmjCCAQMCBgFd2RZiPjANBgkqhkiG9w0BAQsFADATMREwDwYDVQQDDAhLUDEgUk9PVDAeFw0xNzA4MTMwMDU1MDRaFw0xNzA4MTMwMTI1MDlaMBMxETAPBgNVBAMMCEtQMSBST09UMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCPn6zObnrjGPUb0ozc3MCOOcHwtQABZmUHtB1jxRXWwYXKo+iTms2wJjDS5fhz2UmUptsbdFwPdvT2t7K8cpaZBcovC3jLvEAMmjO+nU3FQrdopZ6MhBjpgIezAvJ9LUhrYctqUJzfViqtLl0dL+YRjaVdfCz5z0iZn4rv2VSf3QIDAQABMA0GCSqGSIb3DQEBCwUAA4GBAHtS9RjMIRzeEpH9MKIaMLR7wVb55MYW7E2CVuIbsHmT+KyDBFsYbAylgc76cH1b8F53ECygS9jCpzfKtO61WVPPlUhsL13i2XbzCtj8DSPXaW5pgvpwClQZ+dpGFz8D/MYLSdjTdls8dbhJ5O08ckSKcrIGHcF90oeepVXOmiTw");
    static byte[] extInvVersionCA = Base64.decode("MIICKDCCAZGgAwIBAgIGAV3ZFmI/MA0GCSqGSIb3DQEBCwUAMBMxETAPBgNVBAMMCEtQMSBST09UMB4XDTE3MDgxMzAwNTUwNFoXDTE3MDgxMzAxMjUwOVowETEPMA0GA1UEAwwGS1AxIENBMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQChlaZhX9/eHmtfravHzs/E0g6ZhWTmD9aNNvuuz/GCBF9AMS6QQCGVhEzxESn0gLzs1bM/9M/EaylHS3Ecvi6QYdkrTKRDj38FDzrDhiPlM3TxY0XuUQ3Py590k8yZDcuEeVEQeoUx83qOnO7o/cL+vECfMj9ImYFFgY5sMcKkVQIDAQABo4GIMIGFMEAGA1UdIwQ5MDeAFAfTyJtmNkinVjfd7/2Giy6krDTpoRekFTATMREwDwYDVQQDDAhLUDEgUk9PVIIGAV3ZFmI+MB0GA1UdDgQWBBQkMq+wajXvKQaJtSdpvDJn77bU9zASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB/wQEAwIBhjANBgkqhkiG9w0BAQsFAAOBgQAqmKtykmixemAvppo2tTmekLsL93+/DMR+oz1iK2rjhqYzEF1/pM9VUyG+Ni1924U8tzGbXv2lL3MiToRSyjO50HHfnE7PfOvNiTUj73PTn27tPl03eWO3CtsOTGxtE2vpNyXyFXm4SFZlSicOXE0o/kUrNGVYvnjs/jjcNlPiHQ==");
    static byte[] extInvVersionEE = Base64.decode("MIICJjCCAY+gAwIBBQIGAV3ZFmJAMA0GCSqGSIb3DQEBCwUAMBExDzANBgNVBAMMBktQMSBDQTAeFw0xNzA4MTMwMDU1MDRaFw0xNzA4MTMwMTI1MDlaMBExDzANBgNVBAMMBktQMSBFRTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA6PXdCOvE33+mMcal/rC+I7zdJqcc6OBhn+Lyku29TRcYplMA5mkh7WkjLtRYBUAzHukN/GXb1Mo+dFkvCnKO/l4gLWyVuf23rL6iELt8X1KVJdJlrDElCmTgl6lA0Omq7QhNrsv5Vdk7mK2mbJzl0bj4fcu5dc23nQXEskmGrZsCAwEAAaOBiDCBhTBABgNVHSMEOTA3gBQkMq+wajXvKQaJtSdpvDJn77bU96EXpBUwEzERMA8GA1UEAwwIS1AxIFJPT1SCBgFd2RZiPzAdBgNVHQ4EFgQU3Nw/DFxNqK1fRhc/W8W4o3mkCHQwEgYDVR0TAQH/BAgwBgEB/wIBADAOBgNVHQ8BAf8EBAMCAYYwDQYJKoZIhvcNAQELBQADgYEAjMTiKgLC2Kb5+elvfD/+CM8pNeLt5Y43sMSTpgIrebdWPA2hyvjvW/upsIYIquGrymOYBU/K0abQlkNUbBHpQCQMPQ6iPXuhTQj/P7rt7McLl6OXV/DQqgF+39y0xWAzoZbgMKrQaSr9oRmEVt6xzLM92JS67w8Xgbh39PGBfEg=");
    static byte[] extInvExtTrust = Base64.decode("MIIBmjCCAQMCBgFd2SFqKjANBgkqhkiG9w0BAQsFADATMREwDwYDVQQDDAhLUDEgUk9PVDAeFw0xNzA4MTMwMTA3MDdaFw0xNzA4MTMwMTM3MTJaMBMxETAPBgNVBAMMCEtQMSBST09UMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDEY3toxiphhoeoTd79/Uznb1YyKjYgxtXkYVQLZ+Q76bJFQftVVcUHw25/A/2qgSc8XPflGRpn82Qn/B7s3fxEglgeY0ekdYjea5+jZSJj70p1QcC60yH1NKGxE0ASBuv/22IoHhdu5dOTmiWegikKUXblBD1wAxbbvOcXFs2x/wIDAQABMA0GCSqGSIb3DQEBCwUAA4GBAJPG9wt9edpTaCc0z03xGNF/M6x5cLx5eLgZaBFt+FO3S1xWIVby+iU8Hw2mzHOc58Fghw1jEwLaslQYadx9667NedGu7dYyY318h+VhaDppQqkhJiQl5Q8aTvVNt60fDEVLjvB7E6Z+CafVGR1jNrXxLDe6zVf/BZJK7QrkTKh4");
    static byte[] extInvExtCA = Base64.decode("MIICKDCCAZGgAwIBAgIGAV3ZIWorMA0GCSqGSIb3DQEBCwUAMBMxETAPBgNVBAMMCEtQMSBST09UMB4XDTE3MDgxMzAxMDcwN1oXDTE3MDgxMzAxMzcxMlowETEPMA0GA1UEAwwGS1AxIENBMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCJKySmanEENpLJdPwpM/v0I7H0bW9ZlIxRpiL+/Z4uvF3j0r0O42Tm+dW8Ub42DzHcQ8pK/n/k2Wb4Jf7cP8+TGTAne3bgC24USW131XUZxaunGt4tCqZ0RNWpmBQUcUM0lgntDSfcvyv3QFB+nwLc93GYij9l3FaeUcHkwFiKsQIDAQABo4GIMIGFMEAGA1UdIwQ5MDeAFLnC9UF+JqEqboFH84ab9dEAkwEBoRekFTATMREwDwYDVQQDDAhLUDEgUk9PVIIGAV3ZIWoqMB0GA1UdDgQWBBQkr/0UP1MKPGQH7bkRNctHMsVQsjASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB/wQEAwIBhjANBgkqhkiG9w0BAQsFAAOBgQCZxLwkAPif1H2P398MHK3NLf3mrmLsP41ZphdHnSLNROlY9PdO5I/dfhElzVXW2oxecIIKbOQsjZe0FOSGvZHEhLftQmOdfGc5QfGf5w9CSFCCBe5vHdMjglRLVhNB51jz6DB7Dp0MjFDgkQI4lBHaiMVkE+HUZjNLwBddHH58Sw==");
    static byte[] extInvExtEE = Base64.decode("MIICNjCCAZ+gAwIBAgIGAV3ZIWosMA0GCSqGSIb3DQEBCwUAMBExDzANBgNVBAMMBktQMSBDQTAeFw0xNzA4MTMwMTA3MDdaFw0xNzA4MTMwMTM3MTJaMBExDzANBgNVBAMMBktQMSBFRTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAj6WOoo8xHLLo+CT0l288xZDK3OsF64lPfNVkFnrRI65Ywl89M19nNF5Q24hF1FS6getO5oU+BhvRqft1/De22SME9SzKqs3G6uMxACKrMqgni1QBEOC/DdZ5Uaxh2s4lEgxbN0PQZIarAgLtAIgzRM4CrvofxFMwQy/neUuWmeMCAwEAAaOBmDCBlTBABgNVHSMEOTA3gBQkr/0UP1MKPGQH7bkRNctHMsVQsqEXpBUwEzERMA8GA1UEAwwIS1AxIFJPT1SCBgFd2SFqKzAdBgNVHQ4EFgQU/yuQXlvqXJQsbqB6whCPu5bwFCAwEgYDVR0TAQH/BAgwBgEB/wIBADAOBgNVHQ8BAf8EBAMCAYYwDgYDVR0PAQH/BAQDAgGGMA0GCSqGSIb3DQEBCwUAA4GBABYUGar9s7wlM3Qlnja7uc7U8FqU+xH4e8/Jk64ku7DdwXelEbKo/FTFAzh464aiFP4eMDOH7YThXyTruPudEAvYyWY7eaEgRqA2MmL0uWHSrN+HR9aBeqrMCJK/E2e1egvk2whJHMimhDUFJ3cIPsFhazMvLTnVgWGMjOqQtuP+");

    private void checkCircProcessing() throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate caCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(circCA));
        X509Certificate crlCaCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(circCRLCA));
        X509CRL crl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(circCRL));
        ArrayList<X509Extension> list = new ArrayList<X509Extension>();
        list.add(caCert);
        list.add(crlCaCert);
        list.add(crl);
        CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters(list);
        CertStore store = CertStore.getInstance("Collection", ccsp);
        Date validDate = new Date(crl.getThisUpdate().getTime() + 3600000L);
        ArrayList<X509Certificate> certchain = new ArrayList<X509Certificate>();
        certchain.add(crlCaCert);
        CertPath cp = CertificateFactory.getInstance("X.509", "BC").generateCertPath(certchain);
        HashSet<TrustAnchor> trust = new HashSet<TrustAnchor>();
        trust.add(new TrustAnchor(caCert, null));
        CertPathValidator cpv = CertPathValidator.getInstance("PKIX", "BC");
        PKIXBuilderParameters param = new PKIXBuilderParameters(trust, null);
        X509CertSelector certSelector = new X509CertSelector();
        certSelector.setCertificate(crlCaCert);
        param.setTargetCertConstraints(certSelector);
        param.addCertStore(store);
        param.setRevocationEnabled(true);
        param.setDate(validDate);
        PKIXCertPathValidatorResult result = (PKIXCertPathValidatorResult)cpv.validate(cp, param);
    }

    private void checkPolicyProcessingAtDomainMatch() throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate root = (X509Certificate)cf.generateCertificate(this.getClass().getResourceAsStream("qvRooCa3.crt"));
        X509Certificate ca1 = (X509Certificate)cf.generateCertificate(this.getClass().getResourceAsStream("suvaRoot1.crt"));
        X509Certificate ca2 = (X509Certificate)cf.generateCertificate(this.getClass().getResourceAsStream("suvaEmail1.crt"));
        X509Certificate ee = (X509Certificate)cf.generateCertificate(this.getClass().getResourceAsStream("suvaEE.crt"));
        ArrayList<X509Certificate> certchain = new ArrayList<X509Certificate>();
        certchain.add(ee);
        certchain.add(ca2);
        certchain.add(ca1);
        HashSet<TrustAnchor> trust = new HashSet<TrustAnchor>();
        trust.add(new TrustAnchor(root, null));
        CertPathValidator cpv = CertPathValidator.getInstance("PKIX", "BC");
        PKIXParameters param = new PKIXParameters(trust);
        param.setRevocationEnabled(false);
        param.setDate(new Date(1470025175220L));
        CertPath cp = cf.generateCertPath(certchain);
        MyChecker checker = new MyChecker();
        param.addCertPathChecker(checker);
        PKIXCertPathValidatorResult result = (PKIXCertPathValidatorResult)cpv.validate(cp, param);
    }

    public void testEmptyPath() throws Exception {
        block2: {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate rootCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.rootCertBin));
            ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
            list.add(rootCert);
            CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters(list);
            CertStore store = CertStore.getInstance("Collection", (CertStoreParameters)ccsp, "BC");
            ArrayList certchain = new ArrayList();
            CertPath cp = CertificateFactory.getInstance("X.509", "BC").generateCertPath(certchain);
            HashSet<TrustAnchor> trust = new HashSet<TrustAnchor>();
            trust.add(new TrustAnchor(rootCert, null));
            CertPathValidator cpv = CertPathValidator.getInstance("PKIX", "BC");
            PKIXParameters param = new PKIXParameters(trust);
            param.addCertStore(store);
            MyChecker checker = new MyChecker();
            param.addCertPathChecker(checker);
            try {
                cpv.validate(cp, param);
            }
            catch (CertPathValidatorException e) {
                if ("Certification path is empty.".equals(e.getMessage())) break block2;
                this.fail("message mismatch");
            }
        }
    }

    @Override
    public void performTest() throws Exception {
        block4: {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate rootCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.rootCertBin));
            X509Certificate interCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.interCertBin));
            X509Certificate finalCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.finalCertBin));
            X509CRL rootCrl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(CertPathTest.rootCrlBin));
            X509CRL interCrl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(CertPathTest.interCrlBin));
            ArrayList<X509Extension> list = new ArrayList<X509Extension>();
            list.add(rootCert);
            list.add(interCert);
            list.add(finalCert);
            list.add(rootCrl);
            list.add(interCrl);
            CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters(list);
            CertStore store = CertStore.getInstance("Collection", (CertStoreParameters)ccsp, "BC");
            Date validDate = new Date(rootCrl.getThisUpdate().getTime() + 3600000L);
            ArrayList<X509Certificate> certchain = new ArrayList<X509Certificate>();
            certchain.add(finalCert);
            certchain.add(interCert);
            CertPath cp = CertificateFactory.getInstance("X.509", "BC").generateCertPath(certchain);
            HashSet<TrustAnchor> trust = new HashSet<TrustAnchor>();
            trust.add(new TrustAnchor(rootCert, null));
            CertPathValidator cpv = CertPathValidator.getInstance("PKIX", "BC");
            PKIXParameters param = new PKIXParameters(trust);
            param.addCertStore(store);
            param.setDate(validDate);
            MyChecker checker = new MyChecker();
            param.addCertPathChecker(checker);
            PKIXCertPathValidatorResult result = (PKIXCertPathValidatorResult)cpv.validate(cp, param);
            PolicyNode policyTree = result.getPolicyTree();
            PublicKey subjectPublicKey = result.getPublicKey();
            if (checker.getCount() != 2) {
                this.fail("checker not evaluated for each certificate");
            }
            if (!subjectPublicKey.equals(finalCert.getPublicKey())) {
                this.fail("wrong public key returned");
            }
            this.isTrue(result.getTrustAnchor().getTrustedCert().equals(rootCert));
            certchain.clear();
            certchain.add(finalCert);
            certchain.add(interCert);
            certchain.add(rootCert);
            cp = CertificateFactory.getInstance("X.509", "BC").generateCertPath(certchain);
            cpv = CertPathValidator.getInstance("PKIX", "BC");
            param = new PKIXParameters(trust);
            param.addCertStore(store);
            param.setDate(validDate);
            result = (PKIXCertPathValidatorResult)cpv.validate(cp, param);
            this.isTrue(result.getTrustAnchor().getTrustedCert().equals(rootCert));
            try {
                rootCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(this.AC_RAIZ_ICPBRASIL));
                interCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(this.AC_PR));
                finalCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(this.schefer));
                list = new ArrayList();
                list.add(rootCert);
                list.add(interCert);
                list.add(finalCert);
                ccsp = new CollectionCertStoreParameters(list);
                store = CertStore.getInstance("Collection", ccsp);
                validDate = new Date(finalCert.getNotBefore().getTime() + 3600000L);
                certchain = new ArrayList();
                certchain.add(finalCert);
                certchain.add(interCert);
                cp = CertificateFactory.getInstance("X.509", "BC").generateCertPath(certchain);
                trust = new HashSet();
                trust.add(new TrustAnchor(rootCert, null));
                cpv = CertPathValidator.getInstance("PKIX", "BC");
                param = new PKIXParameters(trust);
                param.addCertStore(store);
                param.setRevocationEnabled(false);
                param.setDate(validDate);
                result = (PKIXCertPathValidatorResult)cpv.validate(cp, param);
                policyTree = result.getPolicyTree();
                subjectPublicKey = result.getPublicKey();
                this.fail("Invalid path validated");
            }
            catch (Exception e) {
                if (e instanceof CertPathValidatorException && e.getMessage().startsWith("Could not validate certificate signature.")) break block4;
                this.fail("unexpected exception", e);
            }
        }
        this.checkCircProcessing();
        this.checkPolicyProcessingAtDomainMatch();
        this.validateWithExtendedKeyUsage();
        this.testEmptyPath();
        this.checkInvalidCertPath();
    }

    private void validateWithExtendedKeyUsage() throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate rootCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(extTrust));
        X509Certificate interCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(extCA));
        X509Certificate finalCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(extEE));
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        list.add(rootCert);
        list.add(interCert);
        list.add(finalCert);
        CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters(list);
        CertStore store = CertStore.getInstance("Collection", (CertStoreParameters)ccsp, "BC");
        Date validDate = new Date(rootCert.getNotBefore().getTime() + 3600000L);
        ArrayList<X509Certificate> certchain = new ArrayList<X509Certificate>();
        certchain.add(finalCert);
        certchain.add(interCert);
        CertPath cp = CertificateFactory.getInstance("X.509", "BC").generateCertPath(certchain);
        HashSet<TrustAnchor> trust = new HashSet<TrustAnchor>();
        trust.add(new TrustAnchor(rootCert, null));
        CertPathValidator cpv = CertPathValidator.getInstance("PKIX", "BC");
        PKIXParameters param = new PKIXParameters(trust);
        param.addCertStore(store);
        param.setDate(validDate);
        param.setRevocationEnabled(false);
        PKIXCertPathValidatorResult result = (PKIXCertPathValidatorResult)cpv.validate(cp, param);
    }

    private void checkInvalidCertPath() throws Exception {
        this.checkInvalidPath(extInvTrust, extInvCA, extInvEE, "version 1 certificate contains extra data");
        this.checkInvalidPath(extInvV2Trust, extInvV2CA, extInvV2EE, "version 2 certificate cannot contain extensions");
        this.checkInvalidPath(extInvVersionTrust, extInvVersionCA, extInvVersionEE, "version number not recognised");
        this.checkInvalidPath(extInvExtTrust, extInvExtCA, extInvExtEE, "repeated extension found: 2.5.29.15");
    }

    private void checkInvalidPath(byte[] root, byte[] inter, byte[] ee, String expected) throws Exception {
        X509CertificateObject rootCert = new X509CertificateObject(X509CertificateStructure.getInstance(root));
        X509CertificateObject interCert = new X509CertificateObject(X509CertificateStructure.getInstance(inter));
        X509CertificateObject finalCert = new X509CertificateObject(X509CertificateStructure.getInstance(ee));
        ArrayList<X509CertificateObject> list = new ArrayList<X509CertificateObject>();
        list.add(rootCert);
        list.add(interCert);
        list.add(finalCert);
        CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters(list);
        CertStore store = CertStore.getInstance("Collection", (CertStoreParameters)ccsp, "BC");
        Date validDate = new Date(((X509Certificate)rootCert).getNotBefore().getTime() + 60000L);
        ArrayList<X509CertificateObject> certchain = new ArrayList<X509CertificateObject>();
        certchain.add(finalCert);
        certchain.add(interCert);
        CertPath cp = CertificateFactory.getInstance("X.509", "BC").generateCertPath(certchain);
        HashSet<TrustAnchor> trust = new HashSet<TrustAnchor>();
        trust.add(new TrustAnchor(rootCert, null));
        CertPathValidator cpv = CertPathValidator.getInstance("PKIX", "BC");
        PKIXParameters param = new PKIXParameters(trust);
        param.addCertStore(store);
        param.setDate(validDate);
        param.setRevocationEnabled(false);
        try {
            PKIXCertPathValidatorResult result = (PKIXCertPathValidatorResult)cpv.validate(cp, param);
            this.fail("valid path passed");
        }
        catch (CertPathValidatorException e) {
            this.isTrue(e.getMessage().equals(expected));
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        try {
            cf.generateCertificate(new ByteArrayInputStream(ee));
        }
        catch (CertificateException e) {
            this.isTrue(e.getMessage().equals("parsing issue: " + expected));
        }
    }

    @Override
    public String getName() {
        return "CertPathValidator";
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        CertPathValidatorTest.runTest(new CertPathValidatorTest());
    }

    private static class MyChecker
    extends PKIXCertPathChecker {
        private static int count;

        private MyChecker() {
        }

        @Override
        public void init(boolean forward) throws CertPathValidatorException {
        }

        @Override
        public boolean isForwardCheckingSupported() {
            return true;
        }

        public Set getSupportedExtensions() {
            return null;
        }

        public void check(Certificate cert, Collection unresolvedCritExts) throws CertPathValidatorException {
            ++count;
        }

        public int getCount() {
            return count;
        }
    }

    public static class X509CertificateObject
    extends X509Certificate {
        static final String CERTIFICATE_POLICIES = Extension.certificatePolicies.getId();
        static final String POLICY_MAPPINGS = Extension.policyMappings.getId();
        static final String INHIBIT_ANY_POLICY = Extension.inhibitAnyPolicy.getId();
        static final String ISSUING_DISTRIBUTION_POINT = Extension.issuingDistributionPoint.getId();
        static final String FRESHEST_CRL = Extension.freshestCRL.getId();
        static final String DELTA_CRL_INDICATOR = Extension.deltaCRLIndicator.getId();
        static final String POLICY_CONSTRAINTS = Extension.policyConstraints.getId();
        static final String BASIC_CONSTRAINTS = Extension.basicConstraints.getId();
        static final String CRL_DISTRIBUTION_POINTS = Extension.cRLDistributionPoints.getId();
        static final String SUBJECT_ALTERNATIVE_NAME = Extension.subjectAlternativeName.getId();
        static final String NAME_CONSTRAINTS = Extension.nameConstraints.getId();
        static final String AUTHORITY_KEY_IDENTIFIER = Extension.authorityKeyIdentifier.getId();
        static final String KEY_USAGE = Extension.keyUsage.getId();
        static final String CRL_NUMBER = Extension.cRLNumber.getId();
        static final String ANY_POLICY = "2.5.29.32.0";
        private X509CertificateStructure c;
        private BasicConstraints basicConstraints;
        private boolean[] keyUsage;
        private boolean hashValueSet;
        private int hashValue;

        public X509CertificateObject(X509CertificateStructure c) throws CertificateParsingException {
            byte[] bytes;
            this.c = c;
            try {
                bytes = this.getExtensionBytes("2.5.29.19");
                if (bytes != null) {
                    this.basicConstraints = BasicConstraints.getInstance(ASN1Primitive.fromByteArray(bytes));
                }
            }
            catch (Exception e) {
                throw new CertificateParsingException("cannot construct BasicConstraints: " + e);
            }
            try {
                bytes = this.getExtensionBytes("2.5.29.15");
                if (bytes != null) {
                    DERBitString bits = DERBitString.getInstance(ASN1Primitive.fromByteArray(bytes));
                    int length = (bytes = bits.getBytes()).length * 8 - bits.getPadBits();
                    this.keyUsage = new boolean[length < 9 ? 9 : length];
                    int i = 0;
                    while (i != length) {
                        this.keyUsage[i] = (bytes[i / 8] & 128 >>> i % 8) != 0;
                        ++i;
                    }
                } else {
                    this.keyUsage = null;
                }
            }
            catch (Exception e) {
                throw new CertificateParsingException("cannot construct KeyUsage: " + e);
            }
        }

        @Override
        public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
            this.checkValidity(new Date());
        }

        @Override
        public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
            if (date.getTime() > this.getNotAfter().getTime()) {
                throw new CertificateExpiredException("certificate expired on " + this.c.getEndDate().getTime());
            }
            if (date.getTime() < this.getNotBefore().getTime()) {
                throw new CertificateNotYetValidException("certificate not valid till " + this.c.getStartDate().getTime());
            }
        }

        @Override
        public int getVersion() {
            return this.c.getVersion();
        }

        @Override
        public BigInteger getSerialNumber() {
            return this.c.getSerialNumber().getValue();
        }

        @Override
        public Principal getIssuerDN() {
            try {
                return new X509Principal(X500Name.getInstance(this.c.getIssuer().getEncoded()));
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        public X500Principal getIssuerX500Principal() {
            try {
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                ASN1OutputStream aOut = new ASN1OutputStream(bOut);
                aOut.writeObject(this.c.getIssuer());
                return new X500Principal(bOut.toByteArray());
            }
            catch (IOException e) {
                throw new IllegalStateException("can't encode issuer DN");
            }
        }

        @Override
        public Principal getSubjectDN() {
            return new X509Principal(X500Name.getInstance(this.c.getSubject().toASN1Primitive()));
        }

        @Override
        public X500Principal getSubjectX500Principal() {
            try {
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                ASN1OutputStream aOut = new ASN1OutputStream(bOut);
                aOut.writeObject(this.c.getSubject());
                return new X500Principal(bOut.toByteArray());
            }
            catch (IOException e) {
                throw new IllegalStateException("can't encode issuer DN");
            }
        }

        @Override
        public Date getNotBefore() {
            return this.c.getStartDate().getDate();
        }

        @Override
        public Date getNotAfter() {
            return this.c.getEndDate().getDate();
        }

        @Override
        public byte[] getTBSCertificate() throws CertificateEncodingException {
            try {
                return this.c.getTBSCertificate().getEncoded("DER");
            }
            catch (IOException e) {
                throw new CertificateEncodingException(e.toString());
            }
        }

        @Override
        public byte[] getSignature() {
            return this.c.getSignature().getOctets();
        }

        @Override
        public String getSigAlgName() {
            String algName;
            Provider prov = Security.getProvider("BC");
            if (prov != null && (algName = prov.getProperty("Alg.Alias.Signature." + this.getSigAlgOID())) != null) {
                return algName;
            }
            Provider[] provs = Security.getProviders();
            int i = 0;
            while (i != provs.length) {
                String algName2 = provs[i].getProperty("Alg.Alias.Signature." + this.getSigAlgOID());
                if (algName2 != null) {
                    return algName2;
                }
                ++i;
            }
            return this.getSigAlgOID();
        }

        @Override
        public String getSigAlgOID() {
            return this.c.getSignatureAlgorithm().getAlgorithm().getId();
        }

        @Override
        public byte[] getSigAlgParams() {
            if (this.c.getSignatureAlgorithm().getParameters() != null) {
                try {
                    return this.c.getSignatureAlgorithm().getParameters().toASN1Primitive().getEncoded("DER");
                }
                catch (IOException e) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public boolean[] getIssuerUniqueID() {
            DERBitString id = this.c.getTBSCertificate().getIssuerUniqueId();
            if (id != null) {
                byte[] bytes = id.getBytes();
                boolean[] boolId = new boolean[bytes.length * 8 - id.getPadBits()];
                int i = 0;
                while (i != boolId.length) {
                    boolId[i] = (bytes[i / 8] & 128 >>> i % 8) != 0;
                    ++i;
                }
                return boolId;
            }
            return null;
        }

        @Override
        public boolean[] getSubjectUniqueID() {
            DERBitString id = this.c.getTBSCertificate().getSubjectUniqueId();
            if (id != null) {
                byte[] bytes = id.getBytes();
                boolean[] boolId = new boolean[bytes.length * 8 - id.getPadBits()];
                int i = 0;
                while (i != boolId.length) {
                    boolId[i] = (bytes[i / 8] & 128 >>> i % 8) != 0;
                    ++i;
                }
                return boolId;
            }
            return null;
        }

        @Override
        public boolean[] getKeyUsage() {
            return this.keyUsage;
        }

        public List getExtendedKeyUsage() throws CertificateParsingException {
            byte[] bytes = this.getExtensionBytes("2.5.29.37");
            if (bytes != null) {
                try {
                    ASN1InputStream dIn = new ASN1InputStream(bytes);
                    ASN1Sequence seq = (ASN1Sequence)dIn.readObject();
                    ArrayList<String> list = new ArrayList<String>();
                    int i = 0;
                    while (i != seq.size()) {
                        list.add(((ASN1ObjectIdentifier)seq.getObjectAt(i)).getId());
                        ++i;
                    }
                    return Collections.unmodifiableList(list);
                }
                catch (Exception e) {
                    throw new CertificateParsingException("error processing extended key usage extension");
                }
            }
            return null;
        }

        @Override
        public int getBasicConstraints() {
            if (this.basicConstraints != null) {
                if (this.basicConstraints.isCA()) {
                    if (this.basicConstraints.getPathLenConstraint() == null) {
                        return Integer.MAX_VALUE;
                    }
                    return this.basicConstraints.getPathLenConstraint().intValue();
                }
                return -1;
            }
            return -1;
        }

        public Collection getSubjectAlternativeNames() throws CertificateParsingException {
            return X509CertificateObject.getAlternativeNames(this.getExtensionBytes(Extension.subjectAlternativeName.getId()));
        }

        public Collection getIssuerAlternativeNames() throws CertificateParsingException {
            return X509CertificateObject.getAlternativeNames(this.getExtensionBytes(Extension.issuerAlternativeName.getId()));
        }

        public Set getCriticalExtensionOIDs() {
            if (this.getVersion() == 3) {
                HashSet<String> set = new HashSet<String>();
                X509Extensions extensions = this.c.getTBSCertificate().getExtensions();
                if (extensions != null) {
                    Enumeration e = extensions.oids();
                    while (e.hasMoreElements()) {
                        ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)e.nextElement();
                        org.bouncycastle.asn1.x509.X509Extension ext = extensions.getExtension(oid);
                        if (!ext.isCritical()) continue;
                        set.add(oid.getId());
                    }
                    return set;
                }
            }
            return null;
        }

        private byte[] getExtensionBytes(String oid) {
            org.bouncycastle.asn1.x509.X509Extension ext;
            X509Extensions exts = this.c.getTBSCertificate().getExtensions();
            if (exts != null && (ext = exts.getExtension(new ASN1ObjectIdentifier(oid))) != null) {
                return ext.getValue().getOctets();
            }
            return null;
        }

        @Override
        public byte[] getExtensionValue(String oid) {
            org.bouncycastle.asn1.x509.X509Extension ext;
            X509Extensions exts = this.c.getTBSCertificate().getExtensions();
            if (exts != null && (ext = exts.getExtension(new ASN1ObjectIdentifier(oid))) != null) {
                try {
                    return ext.getValue().getEncoded();
                }
                catch (Exception e) {
                    throw new IllegalStateException("error parsing " + e.toString());
                }
            }
            return null;
        }

        public Set getNonCriticalExtensionOIDs() {
            if (this.getVersion() == 3) {
                HashSet<String> set = new HashSet<String>();
                X509Extensions extensions = this.c.getTBSCertificate().getExtensions();
                if (extensions != null) {
                    Enumeration e = extensions.oids();
                    while (e.hasMoreElements()) {
                        ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)e.nextElement();
                        org.bouncycastle.asn1.x509.X509Extension ext = extensions.getExtension(oid);
                        if (ext.isCritical()) continue;
                        set.add(oid.getId());
                    }
                    return set;
                }
            }
            return null;
        }

        @Override
        public boolean hasUnsupportedCriticalExtension() {
            X509Extensions extensions;
            if (this.getVersion() == 3 && (extensions = this.c.getTBSCertificate().getExtensions()) != null) {
                Enumeration e = extensions.oids();
                while (e.hasMoreElements()) {
                    org.bouncycastle.asn1.x509.X509Extension ext;
                    ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)e.nextElement();
                    String oidId = oid.getId();
                    if (oidId.equals(KEY_USAGE) || oidId.equals(CERTIFICATE_POLICIES) || oidId.equals(POLICY_MAPPINGS) || oidId.equals(INHIBIT_ANY_POLICY) || oidId.equals(CRL_DISTRIBUTION_POINTS) || oidId.equals(ISSUING_DISTRIBUTION_POINT) || oidId.equals(DELTA_CRL_INDICATOR) || oidId.equals(POLICY_CONSTRAINTS) || oidId.equals(BASIC_CONSTRAINTS) || oidId.equals(SUBJECT_ALTERNATIVE_NAME) || oidId.equals(NAME_CONSTRAINTS) || !(ext = extensions.getExtension(oid)).isCritical()) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public PublicKey getPublicKey() {
            try {
                return BouncyCastleProvider.getPublicKey(this.c.getSubjectPublicKeyInfo());
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        public byte[] getEncoded() throws CertificateEncodingException {
            try {
                return this.c.getEncoded("DER");
            }
            catch (IOException e) {
                throw new CertificateEncodingException(e.toString());
            }
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Certificate)) {
                return false;
            }
            Certificate other = (Certificate)o;
            try {
                byte[] b1 = this.getEncoded();
                byte[] b2 = other.getEncoded();
                return Arrays.areEqual(b1, b2);
            }
            catch (CertificateEncodingException e) {
                return false;
            }
        }

        @Override
        public synchronized int hashCode() {
            if (!this.hashValueSet) {
                this.hashValue = this.calculateHashCode();
                this.hashValueSet = true;
            }
            return this.hashValue;
        }

        private int calculateHashCode() {
            try {
                int hashCode = 0;
                byte[] certData = this.getEncoded();
                int i = 1;
                while (i < certData.length) {
                    hashCode += certData[i] * i;
                    ++i;
                }
                return hashCode;
            }
            catch (CertificateEncodingException e) {
                return 0;
            }
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer();
            String nl = Strings.lineSeparator();
            buf.append("  [0]         Version: ").append(this.getVersion()).append(nl);
            buf.append("         SerialNumber: ").append(this.getSerialNumber()).append(nl);
            buf.append("             IssuerDN: ").append(this.getIssuerDN()).append(nl);
            buf.append("           Start Date: ").append(this.getNotBefore()).append(nl);
            buf.append("           Final Date: ").append(this.getNotAfter()).append(nl);
            buf.append("            SubjectDN: ").append(this.getSubjectDN()).append(nl);
            buf.append("           Public Key: ").append(this.getPublicKey()).append(nl);
            buf.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(nl);
            byte[] sig = this.getSignature();
            buf.append("            Signature: ").append(new String(Hex.encode(sig, 0, 20))).append(nl);
            int i = 20;
            while (i < sig.length) {
                if (i < sig.length - 20) {
                    buf.append("                       ").append(new String(Hex.encode(sig, i, 20))).append(nl);
                } else {
                    buf.append("                       ").append(new String(Hex.encode(sig, i, sig.length - i))).append(nl);
                }
                i += 20;
            }
            X509Extensions extensions = this.c.getTBSCertificate().getExtensions();
            if (extensions != null) {
                Enumeration e = extensions.oids();
                if (e.hasMoreElements()) {
                    buf.append("       Extensions: \n");
                }
                while (e.hasMoreElements()) {
                    ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)e.nextElement();
                    org.bouncycastle.asn1.x509.X509Extension ext = extensions.getExtension(oid);
                    if (ext.getValue() != null) {
                        byte[] octs = ext.getValue().getOctets();
                        ASN1InputStream dIn = new ASN1InputStream(octs);
                        buf.append("                       critical(").append(ext.isCritical()).append(") ");
                        try {
                            if (oid.equals(Extension.basicConstraints)) {
                                buf.append(BasicConstraints.getInstance(dIn.readObject())).append(nl);
                                continue;
                            }
                            if (oid.equals(Extension.keyUsage)) {
                                buf.append(KeyUsage.getInstance(dIn.readObject())).append(nl);
                                continue;
                            }
                            if (oid.equals(MiscObjectIdentifiers.netscapeCertType)) {
                                buf.append(new NetscapeCertType((DERBitString)dIn.readObject())).append(nl);
                                continue;
                            }
                            if (oid.equals(MiscObjectIdentifiers.netscapeRevocationURL)) {
                                buf.append(new NetscapeRevocationURL((DERIA5String)dIn.readObject())).append(nl);
                                continue;
                            }
                            if (oid.equals(MiscObjectIdentifiers.verisignCzagExtension)) {
                                buf.append(new VerisignCzagExtension((DERIA5String)dIn.readObject())).append(nl);
                                continue;
                            }
                            buf.append(oid.getId());
                            buf.append(" value = ").append(ASN1Dump.dumpAsString(dIn.readObject())).append(nl);
                        }
                        catch (Exception ex) {
                            buf.append(oid.getId());
                            buf.append(" value = ").append("*****").append(nl);
                        }
                        continue;
                    }
                    buf.append(nl);
                }
            }
            return buf.toString();
        }

        @Override
        public final void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            Signature signature;
            String sigName = "SHA256withRSA";
            try {
                signature = Signature.getInstance(sigName, "BC");
            }
            catch (Exception e) {
                signature = Signature.getInstance(sigName);
            }
            this.checkSignature(key, signature);
        }

        @Override
        public final void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            String sigName = "SHA256withRSA";
            Signature signature = sigProvider != null ? Signature.getInstance(sigName, sigProvider) : Signature.getInstance(sigName);
            this.checkSignature(key, signature);
        }

        @Override
        public final void verify(PublicKey key, Provider sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
            String sigName = "SHA256withRSA";
            Signature signature = sigProvider != null ? Signature.getInstance(sigName, sigProvider) : Signature.getInstance(sigName);
            this.checkSignature(key, signature);
        }

        private void checkSignature(PublicKey key, Signature signature) throws CertificateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
            if (!this.isAlgIdEqual(this.c.getSignatureAlgorithm(), this.c.getTBSCertificate().getSignature())) {
                throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
            }
            ASN1Encodable params = this.c.getSignatureAlgorithm().getParameters();
            signature.initVerify(key);
            signature.update(this.getTBSCertificate());
            if (!signature.verify(this.getSignature())) {
                throw new SignatureException("certificate does not verify with supplied key");
            }
        }

        private boolean isAlgIdEqual(AlgorithmIdentifier id1, AlgorithmIdentifier id2) {
            if (!id1.getAlgorithm().equals(id2.getAlgorithm())) {
                return false;
            }
            if (id1.getParameters() == null) {
                return id2.getParameters() == null || id2.getParameters().equals(DERNull.INSTANCE);
            }
            if (id2.getParameters() == null) {
                return id1.getParameters() == null || id1.getParameters().equals(DERNull.INSTANCE);
            }
            return id1.getParameters().equals(id2.getParameters());
        }

        private static Collection getAlternativeNames(byte[] extVal) throws CertificateParsingException {
            ArrayList temp;
            block14: {
                if (extVal == null) {
                    return null;
                }
                try {
                    temp = new ArrayList();
                    Enumeration it = ASN1Sequence.getInstance(extVal).getObjects();
                    block12: while (it.hasMoreElements()) {
                        GeneralName genName = GeneralName.getInstance(it.nextElement());
                        ArrayList<Object> list = new ArrayList<Object>();
                        list.add(Integers.valueOf(genName.getTagNo()));
                        switch (genName.getTagNo()) {
                            case 0: 
                            case 3: 
                            case 5: {
                                list.add(genName.getEncoded());
                                break;
                            }
                            case 4: {
                                list.add(X500Name.getInstance(RFC4519Style.INSTANCE, genName.getName()).toString());
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 6: {
                                list.add(((ASN1String)((Object)genName.getName())).getString());
                                break;
                            }
                            case 8: {
                                list.add(ASN1ObjectIdentifier.getInstance(genName.getName()).getId());
                                break;
                            }
                            case 7: {
                                String addr;
                                byte[] addrBytes = DEROctetString.getInstance(genName.getName()).getOctets();
                                try {
                                    addr = InetAddress.getByAddress(addrBytes).getHostAddress();
                                }
                                catch (UnknownHostException e) {
                                    continue block12;
                                }
                                list.add(addr);
                                break;
                            }
                            default: {
                                throw new IOException("Bad tag number: " + genName.getTagNo());
                            }
                        }
                        temp.add(Collections.unmodifiableList(list));
                    }
                    if (temp.size() != 0) break block14;
                    return null;
                }
                catch (Exception e) {
                    throw new CertificateParsingException(e.getMessage());
                }
            }
            return Collections.unmodifiableCollection(temp);
        }
    }
}

