/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.bc.BCObjectIdentifiers;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.jcajce.PKCS12Key;
import org.bouncycastle.jcajce.PKCS12KeyWithParameters;
import org.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class PBETest
extends SimpleTest {
    private PKCS12Test[] pkcs12Tests = new PKCS12Test[]{new PKCS12Test("DESede", "PBEWITHSHAAND3-KEYTRIPLEDES-CBC", new SHA1Digest(), 192, 64), new PKCS12Test("DESede", "PBEWITHSHAAND2-KEYTRIPLEDES-CBC", new SHA1Digest(), 128, 64), new PKCS12Test("RC4", "PBEWITHSHAAND128BITRC4", new SHA1Digest(), 128, 0), new PKCS12Test("RC4", "PBEWITHSHAAND40BITRC4", new SHA1Digest(), 40, 0), new PKCS12Test("RC2", "PBEWITHSHAAND128BITRC2-CBC", new SHA1Digest(), 128, 64), new PKCS12Test("RC2", "PBEWITHSHAAND40BITRC2-CBC", new SHA1Digest(), 40, 64), new PKCS12Test("AES", "PBEWithSHA1And128BitAES-CBC-BC", new SHA1Digest(), 128, 128), new PKCS12Test("AES", "PBEWithSHA1And192BitAES-CBC-BC", new SHA1Digest(), 192, 128), new PKCS12Test("AES", "PBEWithSHA1And256BitAES-CBC-BC", new SHA1Digest(), 256, 128), new PKCS12Test("AES", "PBEWithSHA256And128BitAES-CBC-BC", new SHA256Digest(), 128, 128), new PKCS12Test("AES", "PBEWithSHA256And192BitAES-CBC-BC", new SHA256Digest(), 192, 128), new PKCS12Test("AES", "PBEWithSHA256And256BitAES-CBC-BC", new SHA256Digest(), 256, 128), new PKCS12Test("Twofish", "PBEWithSHAAndTwofish-CBC", new SHA1Digest(), 256, 128), new PKCS12Test("IDEA", "PBEWithSHAAndIDEA-CBC", new SHA1Digest(), 128, 64), new PKCS12Test("AES", BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes128_cbc.getId(), new SHA1Digest(), 128, 128), new PKCS12Test("AES", BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes192_cbc.getId(), new SHA1Digest(), 192, 128), new PKCS12Test("AES", BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes256_cbc.getId(), new SHA1Digest(), 256, 128), new PKCS12Test("AES", BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes128_cbc.getId(), new SHA256Digest(), 128, 128), new PKCS12Test("AES", BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes192_cbc.getId(), new SHA256Digest(), 192, 128), new PKCS12Test("AES", BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes256_cbc.getId(), new SHA256Digest(), 256, 128)};
    private OpenSSLTest[] openSSLTests = new OpenSSLTest[]{new OpenSSLTest("AES", "PBEWITHMD5AND128BITAES-CBC-OPENSSL", 128, 128), new OpenSSLTest("AES", "PBEWITHMD5AND192BITAES-CBC-OPENSSL", 192, 128), new OpenSSLTest("AES", "PBEWITHMD5AND256BITAES-CBC-OPENSSL", 256, 128)};
    static byte[] message = Hex.decode("4869205468657265");
    private byte[] hMac1 = Hex.decode("bcc42174ccb04f425d9a5c8c4a95d6fd7c372911");
    private byte[] hMac2 = Hex.decode("cb1d8bdb6aca9e3fa8980d6eb41ab28a7eb2cfd6");
    private byte[] hMac3 = Hex.decode("514aa173a302c770689269aac08eb8698e5879ac");

    private Cipher makePBECipherUsingParam(String algorithm, int mode, char[] password, byte[] salt, int iterationCount) throws Exception {
        PBEKeySpec pbeSpec = new PBEKeySpec(password);
        SecretKeyFactory keyFact = SecretKeyFactory.getInstance(algorithm, "BC");
        PBEParameterSpec defParams = new PBEParameterSpec(salt, iterationCount);
        Cipher cipher = Cipher.getInstance(algorithm, "BC");
        cipher.init(mode, (Key)keyFact.generateSecret(pbeSpec), defParams);
        return cipher;
    }

    private Cipher makePBECipherWithoutParam(String algorithm, int mode, char[] password, byte[] salt, int iterationCount) throws Exception {
        PBEKeySpec pbeSpec = new PBEKeySpec(password, salt, iterationCount);
        SecretKeyFactory keyFact = SecretKeyFactory.getInstance(algorithm, "BC");
        Cipher cipher = Cipher.getInstance(algorithm, "BC");
        cipher.init(mode, keyFact.generateSecret(pbeSpec));
        return cipher;
    }

    public void testPBEHMac(String hmacName, byte[] output) {
        Mac mac;
        SecretKey key;
        try {
            SecretKeyFactory fact = SecretKeyFactory.getInstance(hmacName, "BC");
            key = fact.generateSecret(new PBEKeySpec("hello".toCharArray()));
            mac = Mac.getInstance(hmacName, "BC");
        }
        catch (Exception e) {
            this.fail("Failed - exception " + e.toString(), e);
            return;
        }
        try {
            mac.init(key, new PBEParameterSpec(new byte[20], 100));
        }
        catch (Exception e) {
            this.fail("Failed - exception " + e.toString(), e);
            return;
        }
        mac.reset();
        mac.update(message, 0, message.length);
        byte[] out = mac.doFinal();
        if (!Arrays.areEqual(out, output)) {
            this.fail("Failed - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(out)));
        }
    }

    public void testPKCS12HMac(String hmacName, byte[] output) {
        Mac mac;
        try {
            mac = Mac.getInstance(hmacName, "BC");
        }
        catch (Exception e) {
            this.fail("Failed - exception " + e.toString(), e);
            return;
        }
        try {
            mac.init(new PKCS12Key("hello".toCharArray()), new PBEParameterSpec(new byte[20], 100));
        }
        catch (Exception e) {
            this.fail("Failed - exception " + e.toString(), e);
            return;
        }
        mac.reset();
        mac.update(message, 0, message.length);
        byte[] out = mac.doFinal();
        if (!Arrays.areEqual(out, output)) {
            this.fail("Failed - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(out)));
        }
    }

    public void testPBEonSecretKeyHmac(String hmacName, byte[] output) {
        Mac mac;
        SecretKey key;
        try {
            SecretKeyFactory fact = SecretKeyFactory.getInstance(hmacName, "BC");
            key = fact.generateSecret(new PBEKeySpec("hello".toCharArray(), new byte[20], 100, 160));
            mac = Mac.getInstance("HMAC-SHA1", "BC");
        }
        catch (Exception e) {
            this.fail("Failed - exception " + e.toString(), e);
            return;
        }
        try {
            mac.init(key);
        }
        catch (Exception e) {
            this.fail("Failed - exception " + e.toString(), e);
            return;
        }
        mac.reset();
        mac.update(message, 0, message.length);
        byte[] out = mac.doFinal();
        if (!Arrays.areEqual(out, output)) {
            this.fail("Failed - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(out)));
        }
    }

    private void testCipherNameWithWrap(String name, String simpleName) throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance("AES");
        kg.init(new SecureRandom());
        SecretKey key = kg.generateKey();
        byte[] salt = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
        char[] password = new char[]{'p', 'a', 's', 's', 'w', 'o', 'r', 'd'};
        PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, 20);
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
        SecretKeyFactory keyFac = SecretKeyFactory.getInstance(name);
        SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
        Cipher pbeEncryptCipher = Cipher.getInstance(name, "BC");
        pbeEncryptCipher.init(3, (Key)pbeKey, pbeParamSpec);
        byte[] symKeyBytes = pbeEncryptCipher.wrap(key);
        Cipher simpleCipher = Cipher.getInstance(simpleName, "BC");
        simpleCipher.init(4, (Key)pbeKey, pbeParamSpec);
        SecretKey unwrappedKey = (SecretKey)simpleCipher.unwrap(symKeyBytes, "AES", 3);
        if (!Arrays.areEqual(unwrappedKey.getEncoded(), key.getEncoded())) {
            this.fail("key mismatch on unwrapping");
        }
    }

    public void testNullSalt() throws Exception {
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBEWITHSHAAND128BITAES-CBC-BC");
        SecretKey key = skf.generateSecret(new PBEKeySpec("secret".toCharArray()));
        Cipher cipher = Cipher.getInstance("PBEWITHSHAAND128BITAES-CBC-BC");
        try {
            cipher.init(1, (Key)key, (AlgorithmParameterSpec)null);
            this.fail("no exception");
        }
        catch (InvalidAlgorithmParameterException e) {
            this.isTrue("wrong message", "PBEKey requires parameters to specify salt".equals(e.getMessage()));
        }
    }

    @Override
    public void performTest() throws Exception {
        byte[] input = Hex.decode("1234567890abcdefabcdef1234567890fedbca098765");
        Cipher cEnc = Cipher.getInstance("DES/CBC/PKCS7Padding", "BC");
        cEnc.init(1, (Key)new SecretKeySpec(Hex.decode("30e69252758e5346"), "DES"), new IvParameterSpec(Hex.decode("7c1c1ab9c454a688")));
        byte[] out = cEnc.doFinal(input);
        char[] password = new char[]{'p', 'a', 's', 's', 'w', 'o', 'r', 'd'};
        Cipher cDec = this.makePBECipherUsingParam("PBEWithSHA1AndDES", 2, password, Hex.decode("7d60435f02e9e0ae"), 2048);
        byte[] in = cDec.doFinal(out);
        if (!Arrays.areEqual(input, in)) {
            this.fail("DES failed");
        }
        if (!Arrays.areEqual(input, in = (cDec = this.makePBECipherWithoutParam("PBEWithSHA1AndDES", 2, password, Hex.decode("7d60435f02e9e0ae"), 2048)).doFinal(out))) {
            this.fail("DES failed without param");
        }
        cEnc = Cipher.getInstance("DESede/CBC/PKCS7Padding", "BC");
        cEnc.init(1, (Key)new SecretKeySpec(Hex.decode("732f2d33c801732b7206756cbd44f9c1c103ddd97c7cbe8e"), "DES"), new IvParameterSpec(Hex.decode("b07bf522c8d608b8")));
        out = cEnc.doFinal(input);
        cDec = this.makePBECipherUsingParam("PBEWithSHAAnd3-KeyTripleDES-CBC", 2, password, Hex.decode("7d60435f02e9e0ae"), 2048);
        in = cDec.doFinal(out);
        if (!Arrays.areEqual(input, in)) {
            this.fail("DESede failed");
        }
        cEnc = Cipher.getInstance("RC2/CBC/PKCS7Padding", "BC");
        cEnc.init(1, (Key)new SecretKeySpec(Hex.decode("732f2d33c8"), "RC2"), new IvParameterSpec(Hex.decode("b07bf522c8d608b8")));
        out = cEnc.doFinal(input);
        cDec = this.makePBECipherUsingParam("PBEWithSHAAnd40BitRC2-CBC", 2, password, Hex.decode("7d60435f02e9e0ae"), 2048);
        in = cDec.doFinal(out);
        if (!Arrays.areEqual(input, in)) {
            this.fail("RC2 failed");
        }
        cEnc = Cipher.getInstance("RC4", "BC");
        cEnc.init(1, new SecretKeySpec(Hex.decode("732f2d33c801732b7206756cbd44f9c1"), "RC4"));
        out = cEnc.doFinal(input);
        cDec = this.makePBECipherUsingParam("PBEWithSHAAnd128BitRC4", 2, password, Hex.decode("7d60435f02e9e0ae"), 2048);
        in = cDec.doFinal(out);
        if (!Arrays.areEqual(input, in)) {
            this.fail("RC4 failed");
        }
        if (!Arrays.areEqual(input, in = (cDec = this.makePBECipherWithoutParam("PBEWithSHAAnd128BitRC4", 2, password, Hex.decode("7d60435f02e9e0ae"), 2048)).doFinal(out))) {
            this.fail("RC4 failed without param");
        }
        int i = 0;
        while (i != this.pkcs12Tests.length) {
            this.pkcs12Tests[i].perform();
            ++i;
        }
        i = 0;
        while (i != this.openSSLTests.length) {
            this.openSSLTests[i].perform();
            ++i;
        }
        this.testPKCS12Interop();
        this.testPBEHMac("PBEWithHMacSHA1", this.hMac1);
        this.testPBEHMac("PBEWithHMacRIPEMD160", this.hMac2);
        this.testPBEonSecretKeyHmac("PBKDF2WithHmacSHA1", this.hMac3);
        this.testCipherNameWithWrap("PBEWITHSHA256AND128BITAES-CBC-BC", "AES/CBC/PKCS5Padding");
        this.testCipherNameWithWrap("PBEWITHSHAAND40BITRC4", "RC4");
        this.testCipherNameWithWrap("PBEWITHSHAAND128BITRC4", "RC4");
        this.checkPBE("PBKDF2WithHmacSHA1", true, "f14687fc31a66e2f7cc01d0a65f687961bd27e20", "6f6579193d6433a3e4600b243bb390674f04a615");
        this.testPKCS12HMac("HMacSHA1", Hex.decode("bcc42174ccb04f425d9a5c8c4a95d6fd7c372911"));
        this.testPKCS12HMac("HMacSHA256", Hex.decode("e1ae77e2d1dcc56a8befa3867ea3ff8c2163b01885504379412e525b120bf9ce"));
        this.testPKCS12HMac("HMacSHA384", Hex.decode("1256a861351db2082f2ba827ca72cede54ee851f533962bba1fd97b500b6d6eb42aa4a51920aca0c817955feaf52d7f8"));
        this.testPKCS12HMac("HMacSHA512", Hex.decode("9090898971914cb2e65eb1b083f1cad1ce9a9d386f963a2e2ede965fbce0a7121526b5f8aed83f81db60b97ced0bc4b0c27cf23407028cc2f289957f607cec98"));
        this.testPKCS12HMac("HMacRIPEMD160", Hex.decode("cb1d8bdb6aca9e3fa8980d6eb41ab28a7eb2cfd6"));
        try {
            Mac mac = Mac.getInstance("HMacRIPEMD256", "BC");
            mac.init(new PKCS12Key("hello".toCharArray()), new PBEParameterSpec(new byte[20], 100));
            this.fail("no exception");
        }
        catch (InvalidAlgorithmParameterException e) {
            this.isTrue("wrong exception", "no PKCS12 mapping for HMAC: RIPEMD256/HMAC".equals(e.getMessage()));
        }
        this.testMixedKeyTypes();
        this.testNullSalt();
    }

    private void testPKCS12Interop() throws Exception {
        String algorithm = "PBEWithSHA256And192BitAES-CBC-BC";
        PBEKeySpec keySpec = new PBEKeySpec("foo123".toCharArray(), Hex.decode("01020304050607080910"), 1024);
        SecretKeyFactory fact = SecretKeyFactory.getInstance("PBEWithSHA256And192BitAES-CBC-BC", "BC");
        BCPBEKey bcpbeKey = (BCPBEKey)fact.generateSecret(keySpec);
        Cipher c1 = Cipher.getInstance("PBEWithSHA256And192BitAES-CBC-BC", "BC");
        c1.init(1, new PKCS12KeyWithParameters("foo123".toCharArray(), Hex.decode("01020304050607080910"), 1024));
        Cipher c2 = Cipher.getInstance("AES/CBC/PKCS7Padding", "BC");
        c2.init(2, (Key)new SecretKeySpec(bcpbeKey.getEncoded(), "AES"), new IvParameterSpec(((ParametersWithIV)bcpbeKey.getParam()).getIV()));
        if (!Arrays.areEqual(Hex.decode("deadbeef"), c2.doFinal(c1.doFinal(Hex.decode("deadbeef"))))) {
            this.fail("new key failed");
        }
        c1.init(1, bcpbeKey);
        if (!Arrays.areEqual(Hex.decode("deadbeef"), c2.doFinal(c1.doFinal(Hex.decode("deadbeef"))))) {
            this.fail("old key failed");
        }
    }

    private void checkPBE(String baseAlg, boolean defIsUTF8, String utf8, String eightBit) throws Exception {
        PBEKeySpec ks2;
        PBEKeySpec ks1;
        SecretKeyFactory f;
        byte[] utf8K = Hex.decode(utf8);
        byte[] ascK = Hex.decode(eightBit);
        if (!Arrays.areEqual(defIsUTF8 ? utf8K : ascK, (f = SecretKeyFactory.getInstance(baseAlg, "BC")).generateSecret(ks1 = new PBEKeySpec("\u0141\u0142".toCharArray(), new byte[20], 4096, 160)).getEncoded())) {
            this.fail(String.valueOf(baseAlg) + " wrong PBKDF2 k1 key generated, got : " + new String(Hex.encode(f.generateSecret(ks1).getEncoded())));
        }
        if (!Arrays.areEqual(ascK, f.generateSecret(ks2 = new PBEKeySpec("AB".toCharArray(), new byte[20], 4096, 160)).getEncoded())) {
            this.fail(String.valueOf(baseAlg) + " wrong PBKDF2 k2 key generated");
        }
        if (!Arrays.areEqual(utf8K, (f = SecretKeyFactory.getInstance(String.valueOf(baseAlg) + "AndUTF8", "BC")).generateSecret(ks1 = new PBEKeySpec("\u0141\u0142".toCharArray(), new byte[20], 4096, 160)).getEncoded())) {
            this.fail(String.valueOf(baseAlg) + " wrong PBKDF2 k1 utf8 key generated");
        }
        if (!Arrays.areEqual(ascK, f.generateSecret(ks2 = new PBEKeySpec("AB".toCharArray(), new byte[20], 4096, 160)).getEncoded())) {
            this.fail(String.valueOf(baseAlg) + " wrong PBKDF2 k2 utf8 key generated");
        }
        if (!Arrays.areEqual(ascK, (f = SecretKeyFactory.getInstance(String.valueOf(baseAlg) + "And8BIT", "BC")).generateSecret(ks1 = new PBEKeySpec("\u0141\u0142".toCharArray(), new byte[20], 4096, 160)).getEncoded())) {
            this.fail(String.valueOf(baseAlg) + " wrong PBKDF2 k1 8bit key generated");
        }
        if (!Arrays.areEqual(ascK, f.generateSecret(ks2 = new PBEKeySpec("AB".toCharArray(), new byte[20], 4096, 160)).getEncoded())) {
            this.fail(String.valueOf(baseAlg) + " wrong PBKDF2 k2 8bit key generated");
        }
    }

    public void testMixedKeyTypes() throws Exception {
        String provider = "BC";
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WITHHMACSHA1", provider);
        PBEKeySpec pbeks = new PBEKeySpec("password".toCharArray(), Strings.toByteArray("salt"), 100, 128);
        SecretKey secretKey = skf.generateSecret(pbeks);
        PBEParameterSpec paramSpec = new PBEParameterSpec(pbeks.getSalt(), pbeks.getIterationCount());
        Cipher cipher = Cipher.getInstance("PBEWITHSHAAND128BITAES-CBC-BC", provider);
        try {
            cipher.init(1, secretKey);
            this.fail("no exception");
        }
        catch (InvalidKeyException e) {
            this.isTrue("wrong exception", "Algorithm requires a PBE key suitable for PKCS12".equals(e.getMessage()));
        }
    }

    @Override
    public String getName() {
        return "PBETest";
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        PBETest.runTest(new PBETest());
    }

    private class OpenSSLTest
    extends SimpleTest {
        char[] password;
        String baseAlgorithm;
        String algorithm;
        int keySize;
        int ivSize;

        OpenSSLTest(String baseAlgorithm, String algorithm, int keySize, int ivSize) {
            this.password = algorithm.toCharArray();
            this.baseAlgorithm = baseAlgorithm;
            this.algorithm = algorithm;
            this.keySize = keySize;
            this.ivSize = ivSize;
        }

        @Override
        public String getName() {
            return "OpenSSLPBE";
        }

        @Override
        public void performTest() throws Exception {
            Cipher c;
            byte[] salt = new byte[16];
            int iCount = 100;
            int i = 0;
            while (i != salt.length) {
                salt[i] = (byte)i;
                ++i;
            }
            OpenSSLPBEParametersGenerator pGen = new OpenSSLPBEParametersGenerator();
            pGen.init(PBEParametersGenerator.PKCS5PasswordToBytes(this.password), salt, iCount);
            ParametersWithIV params = (ParametersWithIV)pGen.generateDerivedParameters(this.keySize, this.ivSize);
            SecretKeySpec encKey = new SecretKeySpec(((KeyParameter)params.getParameters()).getKey(), this.baseAlgorithm);
            if (this.baseAlgorithm.equals("RC4")) {
                c = Cipher.getInstance(this.baseAlgorithm, "BC");
                c.init(1, encKey);
            } else {
                c = Cipher.getInstance(String.valueOf(this.baseAlgorithm) + "/CBC/PKCS7Padding", "BC");
                c.init(1, (Key)encKey, new IvParameterSpec(params.getIV()));
            }
            byte[] enc = c.doFinal(salt);
            c = Cipher.getInstance(this.algorithm, "BC");
            PBEKeySpec keySpec = new PBEKeySpec(this.password, salt, iCount);
            SecretKeyFactory fact = SecretKeyFactory.getInstance(this.algorithm, "BC");
            c.init(2, fact.generateSecret(keySpec));
            byte[] dec = c.doFinal(enc);
            if (!Arrays.areEqual(salt, dec)) {
                this.fail(this.algorithm + "failed encryption/decryption test");
            }
        }
    }

    private class PKCS12Test
    extends SimpleTest {
        char[] password;
        String baseAlgorithm;
        String algorithm;
        Digest digest;
        int keySize;
        int ivSize;

        PKCS12Test(String baseAlgorithm, String algorithm, Digest digest, int keySize, int ivSize) {
            this.password = algorithm.toCharArray();
            this.baseAlgorithm = baseAlgorithm;
            this.algorithm = algorithm;
            this.digest = digest;
            this.keySize = keySize;
            this.ivSize = ivSize;
        }

        @Override
        public String getName() {
            return "PKCS12PBE";
        }

        @Override
        public void performTest() throws Exception {
            Cipher c;
            byte[] salt = new byte[this.digest.getDigestSize()];
            int iCount = 100;
            this.digest.doFinal(salt, 0);
            PKCS12ParametersGenerator pGen = new PKCS12ParametersGenerator(this.digest);
            pGen.init(PBEParametersGenerator.PKCS12PasswordToBytes(this.password), salt, iCount);
            ParametersWithIV params = (ParametersWithIV)pGen.generateDerivedParameters(this.keySize, this.ivSize);
            SecretKeySpec encKey = new SecretKeySpec(((KeyParameter)params.getParameters()).getKey(), this.baseAlgorithm);
            if (this.baseAlgorithm.equals("RC4")) {
                c = Cipher.getInstance(this.baseAlgorithm, "BC");
                c.init(1, encKey);
            } else {
                c = Cipher.getInstance(String.valueOf(this.baseAlgorithm) + "/CBC/PKCS7Padding", "BC");
                c.init(1, (Key)encKey, new IvParameterSpec(params.getIV()));
            }
            byte[] enc = c.doFinal(salt);
            c = Cipher.getInstance(this.algorithm, "BC");
            PBEKeySpec keySpec = new PBEKeySpec(this.password, salt, iCount);
            SecretKeyFactory fact = SecretKeyFactory.getInstance(this.algorithm, "BC");
            c.init(2, fact.generateSecret(keySpec));
            byte[] dec = c.doFinal(enc);
            if (!Arrays.areEqual(salt, dec)) {
                this.fail(this.algorithm + "failed encryption/decryption test");
            }
            AlgorithmParameters param = this.checkParameters(c, salt, iCount);
            c = Cipher.getInstance(this.algorithm, "BC");
            keySpec = new PBEKeySpec(this.password);
            c.init(2, (Key)fact.generateSecret(keySpec), param);
            this.checkParameters(c, salt, iCount);
            dec = c.doFinal(enc);
            if (!Arrays.areEqual(salt, dec)) {
                this.fail(this.algorithm + "failed encryption/decryption test");
            }
            c = Cipher.getInstance(this.algorithm, "BC");
            keySpec = new PBEKeySpec(this.password);
            c.init(2, (Key)fact.generateSecret(keySpec), param.getParameterSpec(PBEParameterSpec.class));
            this.checkParameters(c, salt, iCount);
            dec = c.doFinal(enc);
            if (!Arrays.areEqual(salt, dec)) {
                this.fail(this.algorithm + "failed encryption/decryption test");
            }
        }

        private AlgorithmParameters checkParameters(Cipher c, byte[] salt, int iCount) throws InvalidParameterSpecException {
            AlgorithmParameters param = c.getParameters();
            PBEParameterSpec spec = param.getParameterSpec(PBEParameterSpec.class);
            if (!Arrays.areEqual(salt, spec.getSalt())) {
                this.fail(this.algorithm + "failed salt test");
            }
            if (iCount != spec.getIterationCount()) {
                this.fail(this.algorithm + "failed count test");
            }
            return param;
        }
    }
}

