/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.rainbow;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.MessageSigner;
import org.bouncycastle.pqc.crypto.rainbow.Layer;
import org.bouncycastle.pqc.crypto.rainbow.RainbowKeyParameters;
import org.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import org.bouncycastle.pqc.crypto.rainbow.util.ComputeInField;
import org.bouncycastle.pqc.crypto.rainbow.util.GF2Field;

public class RainbowSigner
implements MessageSigner {
    private static final int MAXITS = 65536;
    private SecureRandom random;
    int signableDocumentLength;
    private short[] x;
    private ComputeInField cf = new ComputeInField();
    RainbowKeyParameters key;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (RainbowPrivateKeyParameters)rParam.getParameters();
            } else {
                this.random = new SecureRandom();
                this.key = (RainbowPrivateKeyParameters)param;
            }
        } else {
            this.key = (RainbowPublicKeyParameters)param;
        }
        this.signableDocumentLength = this.key.getDocLength();
    }

    private short[] initSign(Layer[] layer, short[] msg) {
        short[] tmpVec = new short[msg.length];
        tmpVec = this.cf.addVect(((RainbowPrivateKeyParameters)this.key).getB1(), msg);
        short[] Y_ = this.cf.multiplyMatrix(((RainbowPrivateKeyParameters)this.key).getInvA1(), tmpVec);
        int i = 0;
        while (i < layer[0].getVi()) {
            this.x[i] = (short)this.random.nextInt();
            this.x[i] = (short)(this.x[i] & 0xFF);
            ++i;
        }
        return Y_;
    }

    @Override
    public byte[] generateSignature(byte[] message) {
        boolean ok;
        Layer[] layer = ((RainbowPrivateKeyParameters)this.key).getLayers();
        int numberOfLayers = layer.length;
        this.x = new short[((RainbowPrivateKeyParameters)this.key).getInvA2().length];
        byte[] S = new byte[layer[numberOfLayers - 1].getViNext()];
        short[] msgHashVals = this.makeMessageRepresentative(message);
        int itCount = 0;
        do {
            ok = true;
            int counter = 0;
            try {
                short[] Y_ = this.initSign(layer, msgHashVals);
                int i = 0;
                while (i < numberOfLayers) {
                    short[] y_i = new short[layer[i].getOi()];
                    short[] solVec = new short[layer[i].getOi()];
                    int k = 0;
                    while (k < layer[i].getOi()) {
                        y_i[k] = Y_[counter];
                        ++counter;
                        ++k;
                    }
                    solVec = this.cf.solveEquation(layer[i].plugInVinegars(this.x), y_i);
                    if (solVec == null) {
                        throw new Exception("LES is not solveable!");
                    }
                    int j = 0;
                    while (j < solVec.length) {
                        this.x[layer[i].getVi() + j] = solVec[j];
                        ++j;
                    }
                    ++i;
                }
                short[] tmpVec = this.cf.addVect(((RainbowPrivateKeyParameters)this.key).getB2(), this.x);
                short[] signature = this.cf.multiplyMatrix(((RainbowPrivateKeyParameters)this.key).getInvA2(), tmpVec);
                i = 0;
                while (i < S.length) {
                    S[i] = (byte)signature[i];
                    ++i;
                }
            }
            catch (Exception se) {
                ok = false;
            }
        } while (!ok && ++itCount < 65536);
        if (itCount == 65536) {
            throw new IllegalStateException("unable to generate signature - LES not solvable");
        }
        return S;
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] signature) {
        short[] sigInt = new short[signature.length];
        int i = 0;
        while (i < signature.length) {
            short tmp = signature[i];
            sigInt[i] = tmp = (short)(tmp & 0xFF);
            ++i;
        }
        short[] msgHashVal = this.makeMessageRepresentative(message);
        short[] verificationResult = this.verifySignatureIntern(sigInt);
        boolean verified = true;
        if (msgHashVal.length != verificationResult.length) {
            return false;
        }
        int i2 = 0;
        while (i2 < msgHashVal.length) {
            verified = verified && msgHashVal[i2] == verificationResult[i2];
            ++i2;
        }
        return verified;
    }

    private short[] verifySignatureIntern(short[] signature) {
        short[][] coeff_quadratic = ((RainbowPublicKeyParameters)this.key).getCoeffQuadratic();
        short[][] coeff_singular = ((RainbowPublicKeyParameters)this.key).getCoeffSingular();
        short[] coeff_scalar = ((RainbowPublicKeyParameters)this.key).getCoeffScalar();
        short[] rslt = new short[coeff_quadratic.length];
        int n = coeff_singular[0].length;
        int offset = 0;
        short tmp = 0;
        int p = 0;
        while (p < coeff_quadratic.length) {
            offset = 0;
            int x = 0;
            while (x < n) {
                int y = x;
                while (y < n) {
                    tmp = GF2Field.multElem(coeff_quadratic[p][offset], GF2Field.multElem(signature[x], signature[y]));
                    rslt[p] = GF2Field.addElem(rslt[p], tmp);
                    ++offset;
                    ++y;
                }
                tmp = GF2Field.multElem(coeff_singular[p][x], signature[x]);
                rslt[p] = GF2Field.addElem(rslt[p], tmp);
                ++x;
            }
            rslt[p] = GF2Field.addElem(rslt[p], coeff_scalar[p]);
            ++p;
        }
        return rslt;
    }

    private short[] makeMessageRepresentative(byte[] message) {
        short[] output = new short[this.signableDocumentLength];
        int h = 0;
        int i = 0;
        while (i < message.length) {
            output[i] = message[h];
            int n = i++;
            output[n] = (short)(output[n] & 0xFF);
            ++h;
            if (i < output.length) continue;
        }
        return output;
    }
}

