/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import junit.framework.TestCase;
import org.bouncycastle.pqc.crypto.ntru.NTRUEncryptionKeyGenerationParameters;

public class NTRUEncryptionParametersTest
extends TestCase {
    public void testLoadSave() throws IOException {
        NTRUEncryptionKeyGenerationParameters params = NTRUEncryptionKeyGenerationParameters.EES1499EP1;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        params.writeTo(os);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        NTRUEncryptionParametersTest.assertEquals((Object)params, (Object)new NTRUEncryptionKeyGenerationParameters(is));
    }

    public void testEqualsHashCode() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        NTRUEncryptionKeyGenerationParameters.EES1499EP1.writeTo(os);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        NTRUEncryptionKeyGenerationParameters params = new NTRUEncryptionKeyGenerationParameters(is);
        NTRUEncryptionParametersTest.assertEquals((Object)params, (Object)NTRUEncryptionKeyGenerationParameters.EES1499EP1);
        NTRUEncryptionParametersTest.assertEquals((int)params.hashCode(), (int)NTRUEncryptionKeyGenerationParameters.EES1499EP1.hashCode());
        ++params.N;
        NTRUEncryptionParametersTest.assertFalse((boolean)params.equals(NTRUEncryptionKeyGenerationParameters.EES1499EP1));
        NTRUEncryptionParametersTest.assertFalse((boolean)NTRUEncryptionKeyGenerationParameters.EES1499EP1.equals(params));
        NTRUEncryptionParametersTest.assertFalse((params.hashCode() == NTRUEncryptionKeyGenerationParameters.EES1499EP1.hashCode() ? 1 : 0) != 0);
    }

    public void testClone() {
        NTRUEncryptionKeyGenerationParameters params = NTRUEncryptionKeyGenerationParameters.APR2011_439;
        NTRUEncryptionParametersTest.assertEquals((Object)params, (Object)params.clone());
        params = NTRUEncryptionKeyGenerationParameters.APR2011_439_FAST;
        NTRUEncryptionParametersTest.assertEquals((Object)params, (Object)params.clone());
    }
}

