/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import junit.framework.TestCase;
import org.bouncycastle.pqc.crypto.ntru.NTRUSigningKeyGenerationParameters;

public class NTRUSigningParametersTest
extends TestCase {
    public void testLoadSave() throws IOException {
        NTRUSigningKeyGenerationParameters[] nTRUSigningKeyGenerationParametersArray = new NTRUSigningKeyGenerationParameters[]{NTRUSigningKeyGenerationParameters.TEST157, NTRUSigningKeyGenerationParameters.TEST157_PROD};
        int n = nTRUSigningKeyGenerationParametersArray.length;
        int n2 = 0;
        while (n2 < n) {
            NTRUSigningKeyGenerationParameters params = nTRUSigningKeyGenerationParametersArray[n2];
            this.testLoadSave(params);
            ++n2;
        }
    }

    private void testLoadSave(NTRUSigningKeyGenerationParameters params) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        params.writeTo(os);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        NTRUSigningParametersTest.assertEquals((Object)params, (Object)new NTRUSigningKeyGenerationParameters(is));
    }

    public void testEqualsHashCode() throws IOException {
        NTRUSigningKeyGenerationParameters[] nTRUSigningKeyGenerationParametersArray = new NTRUSigningKeyGenerationParameters[]{NTRUSigningKeyGenerationParameters.TEST157, NTRUSigningKeyGenerationParameters.TEST157_PROD};
        int n = nTRUSigningKeyGenerationParametersArray.length;
        int n2 = 0;
        while (n2 < n) {
            NTRUSigningKeyGenerationParameters params = nTRUSigningKeyGenerationParametersArray[n2];
            this.testEqualsHashCode(params);
            ++n2;
        }
    }

    private void testEqualsHashCode(NTRUSigningKeyGenerationParameters params) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        params.writeTo(os);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        NTRUSigningKeyGenerationParameters params2 = new NTRUSigningKeyGenerationParameters(is);
        NTRUSigningParametersTest.assertEquals((Object)params, (Object)params2);
        NTRUSigningParametersTest.assertEquals((int)params.hashCode(), (int)params2.hashCode());
        ++params.N;
        NTRUSigningParametersTest.assertFalse((boolean)params.equals(params2));
        NTRUSigningParametersTest.assertFalse((boolean)params.equals(params2));
        NTRUSigningParametersTest.assertFalse((params.hashCode() == params2.hashCode() ? 1 : 0) != 0);
    }

    public void testClone() {
        NTRUSigningKeyGenerationParameters[] nTRUSigningKeyGenerationParametersArray = new NTRUSigningKeyGenerationParameters[]{NTRUSigningKeyGenerationParameters.TEST157, NTRUSigningKeyGenerationParameters.TEST157_PROD};
        int n = nTRUSigningKeyGenerationParametersArray.length;
        int n2 = 0;
        while (n2 < n) {
            NTRUSigningKeyGenerationParameters params = nTRUSigningKeyGenerationParametersArray[n2];
            NTRUSigningParametersTest.assertEquals((Object)params, (Object)params.clone());
            ++n2;
        }
    }
}

