/*
 * Decompiled with CFR 0.152.
 */
package com.huangzhimin.contacts.email;

import com.huangzhimin.contacts.Contact;
import com.huangzhimin.contacts.email.EmailImporter;
import com.huangzhimin.contacts.exception.ContactsException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.NameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneThreeNineImporter
extends EmailImporter {
    private String loginUrl = "https://mail.139.com/Login/Login.ashx";

    public OneThreeNineImporter(String email, String password) {
        super(email, password, "GBK");
    }

    @Override
    protected void doLogin() throws ContactsException {
        try {
            NameValuePair[] params = new NameValuePair[]{new NameValuePair("UserName", this.getUsername(this.email)), new NameValuePair("Password", this.password), new NameValuePair("VerifyCode", "")};
            String responseStr = this.doPost(this.loginUrl, params, "http://mail.139.com");
            String redirectUrl = this.getHrefUrl(responseStr, "http://");
            String string = this.doGet(redirectUrl, this.loginUrl);
        }
        catch (Exception e) {
            throw new ContactsException("139 protocol has changed", e);
        }
    }

    @Override
    protected List<Contact> parseContacts() throws ContactsException {
        try {
            ArrayList<Contact> contacts = new ArrayList<Contact>();
            String sid = this.getSid();
            String randNum = "0.0754233067456439";
            String contactsUrl = "http://mail.139.com/addr/apiserver/GetContactsDataByJs.ashx?sid=" + sid + "&rnd=" + randNum;
            String content = this.doGet(contactsUrl);
            JSONObject jsonObj = this.parseJSON(content, "GetUserAddrDataResp=");
            JSONArray jsonContacts = jsonObj.getJSONArray("Contacts");
            for (int i = 0; i < jsonContacts.length(); ++i) {
                JSONObject jsonContact = (JSONObject)jsonContacts.get(i);
                String username = jsonContact.getString("c");
                String email = jsonContact.getString("y");
                contacts.add(new Contact(username, email));
            }
            return contacts;
        }
        catch (Exception e) {
            throw new ContactsException("139 protocol has changed", e);
        }
    }

    private String getSid() {
        Cookie[] cookies;
        String sid = null;
        for (Cookie cookie : cookies = this.client.getState().getCookies()) {
            if (!cookie.getName().equals("Os_SSo_Sid")) continue;
            sid = cookie.getValue();
            break;
        }
        return sid;
    }
}

