/*
 * Decompiled with CFR 0.152.
 */
package com.huangzhimin.contacts.email;

import com.huangzhimin.contacts.Contact;
import com.huangzhimin.contacts.email.EmailImporter;
import com.huangzhimin.contacts.exception.ContactsException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.NameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinaImporter
extends EmailImporter {
    private String loginUrl = "http://mail.sina.com.cn/cgi-bin/login.cgi";

    public SinaImporter(String email, String password) {
        super(email, password);
    }

    @Override
    public void doLogin() throws ContactsException {
        try {
            NameValuePair[] params = new NameValuePair[]{new NameValuePair("logintype", "uid"), new NameValuePair("u", this.getUsername(this.email)), new NameValuePair("psw", this.password)};
            this.client.getState().addCookies(new Cookie[]{new Cookie("mail.sina.com.cn", "sina_free_mail_recid", "false", "/", null, false), new Cookie("mail.sina.com.cn", "sina_vip_mail_recid", "false", "/", null, false)});
            this.doPost(this.loginUrl, params, "http://mail.sina.com.cn");
        }
        catch (Exception e) {
            throw new ContactsException("sina protocol has changed", e);
        }
    }

    @Override
    public List<Contact> parseContacts() throws ContactsException {
        try {
            NameValuePair[] params = new NameValuePair[]{new NameValuePair("act", "list"), new NameValuePair("sort_item", "letter"), new NameValuePair("sort_type", "desc")};
            String contactsUrl = this.lastUrl.substring(0, this.lastUrl.lastIndexOf("/")) + "/addr_member.php";
            String json = this.doPost(contactsUrl, params);
            JSONTokener jsonTokener = new JSONTokener(json);
            Object o = jsonTokener.nextValue();
            JSONObject jsonObj = (JSONObject)o;
            JSONObject jsonData = jsonObj.getJSONObject("data");
            JSONArray jsonContacts = jsonData.getJSONArray("contact");
            ArrayList<Contact> contacts = new ArrayList<Contact>();
            for (int i = 0; i < jsonContacts.length(); ++i) {
                jsonObj = jsonContacts.getJSONObject(i);
                if (!jsonObj.has("name") || !jsonObj.has("email")) continue;
                contacts.add(new Contact(jsonObj.getString("name").replaceAll("&nbsp;", " "), jsonObj.getString("email")));
            }
            return contacts;
        }
        catch (Exception e) {
            throw new ContactsException("sina protocol has changed", e);
        }
    }
}

