/*
 * Decompiled with CFR 0.152.
 */
package com.huangzhimin.contacts.email;

import com.huangzhimin.contacts.Contact;
import com.huangzhimin.contacts.email.EmailImporter;
import com.huangzhimin.contacts.exception.ContactsException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.httpclient.Cookie;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SohuImporter
extends EmailImporter {
    private String beforeLoginUrl = "http://passport.sohu.com/sso/login.jsp?userid=%email&password=%md5_pwd&appid=1000&persistentcookie=0&s=%time&b=2&w=1024&pwdtype=1";
    private String loginUrl = "http://login.mail.sohu.com/servlet/LoginServlet";
    private String contactsUrl = null;
    private static final String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    private static String byteArrayToHexString(byte[] b) {
        StringBuffer resultSb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            resultSb.append(SohuImporter.byteToHexString(b[i]));
        }
        return resultSb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }

    public SohuImporter(String email, String password) {
        super(email, password);
    }

    @Override
    public void doLogin() throws ContactsException {
        try {
            String encode_email = URLEncoder.encode(this.email, "UTF-8");
            MessageDigest md = MessageDigest.getInstance("MD5");
            String md5_pwd = SohuImporter.byteArrayToHexString(md.digest(this.password.getBytes()));
            long time = Calendar.getInstance().getTimeInMillis();
            String encodeBeforeLoginUrl = this.beforeLoginUrl.replaceFirst("%email", encode_email).replaceFirst("%md5_pwd", md5_pwd).replaceFirst("%time", "" + time);
            this.doGet(encodeBeforeLoginUrl, "http://mail.sohu.com/");
            Calendar calendar = Calendar.getInstance();
            calendar.add(10, 36);
            this.client.getState().addCookie(new Cookie(".sohu.com", "crossdomain", "" + calendar.getTimeInMillis(), "/", calendar.getTime(), false));
            this.doGet(this.loginUrl, "http://mail.sohu.com");
            this.contactsUrl = this.lastUrl + "#addressList";
        }
        catch (Exception e) {
            throw new ContactsException("sohu protocol has changed", e);
        }
    }

    @Override
    public List<Contact> parseContacts() throws ContactsException {
        try {
            String content = this.doGet(this.contactsUrl);
            JSONObject jsonObj = this.parseJSON(content, "ADDRESSES = '", "';");
            JSONArray jsonContacts = jsonObj.getJSONArray("contact");
            ArrayList<Contact> contacts = new ArrayList<Contact>(jsonContacts.length());
            for (int i = 0; i < jsonContacts.length(); ++i) {
                jsonObj = jsonContacts.getJSONObject(i);
                if (!jsonObj.has("nickname") || !jsonObj.has("email")) continue;
                contacts.add(new Contact(jsonObj.getString("nickname"), jsonObj.getString("email")));
            }
            return contacts;
        }
        catch (Exception e) {
            throw new ContactsException("sohu protocol has changed", e);
        }
    }
}

