/*
 * Decompiled with CFR 0.152.
 */
package com.huangzhimin.contacts.email;

import com.huangzhimin.contacts.Contact;
import com.huangzhimin.contacts.email.EmailImporter;
import com.huangzhimin.contacts.exception.ContactsException;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.NameValuePair;
import org.cyberneko.html.parsers.DOMParser;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomImporter
extends EmailImporter {
    private String loginUrl = "http://login.mail.tom.com/cgi/login";
    private String contactsUrl = "http://bjapp6.mail.tom.com/cgi/ldvcapp?funcid=address&sid=%sid&tempname=address%2Faddress.htm&showlist=all&ifirstv=all&listnum=0";
    private String indexPage = null;
    private Pattern SidPattern = Pattern.compile("sid=([^\"]*)\"");

    public TomImporter(String email, String password) {
        super(email, password, "GBK");
    }

    @Override
    public void doLogin() throws ContactsException {
        try {
            NameValuePair[] params = new NameValuePair[]{new NameValuePair("type", "0"), new NameValuePair("style", "10"), new NameValuePair("user", this.getUsername(this.email)), new NameValuePair("pass", this.password), new NameValuePair("verifycookie", "y")};
            this.indexPage = this.doPost(this.loginUrl, params, "http://mail.tom.com");
        }
        catch (Exception e) {
            throw new ContactsException("tom protocol has changed", e);
        }
    }

    @Override
    public List<Contact> parseContacts() throws ContactsException {
        try {
            String sid = this.getSid(this.indexPage, "folder");
            String content = this.doGet(this.contactsUrl.replaceFirst("%sid", sid));
            ArrayList<Contact> contacts = new ArrayList<Contact>();
            DOMParser parser = new DOMParser();
            InputSource is = new InputSource(new ByteArrayInputStream(content.getBytes("GBK")));
            is.setEncoding("GBK");
            parser.parse(is);
            NodeList nodes = parser.getDocument().getElementsByTagName("td");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getAttributes().getNamedItem("class") == null || !node.getAttributes().getNamedItem("class").getNodeValue().equals("Addr_Td_Name")) continue;
                String username = node.getTextContent().trim();
                String email = nodes.item(++i).getTextContent().trim();
                contacts.add(new Contact(username, email));
            }
            return contacts;
        }
        catch (Exception e) {
            throw new ContactsException("tom protocol has changed", e);
        }
    }

    private String getSid(String content, String frameName) {
        int indexEnd;
        int indexMid = content.indexOf("name=\"" + frameName + "\"");
        int indexBegin = content.substring(0, indexMid).lastIndexOf("<");
        Matcher matcher = this.SidPattern.matcher(content.substring(indexBegin, indexEnd = content.indexOf("<", indexMid)));
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

