/*
 * Decompiled with CFR 0.152.
 */
package com.huangzhimin.contacts.email;

import com.huangzhimin.contacts.Contact;
import com.huangzhimin.contacts.email.EmailImporter;
import com.huangzhimin.contacts.exception.ContactsException;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.NameValuePair;
import org.cyberneko.html.parsers.DOMParser;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YahooImporter
extends EmailImporter {
    private String beforeLoginUrl = "http://mail.cn.yahoo.com/";
    private String loginUrl = "https://edit.bjs.yahoo.com/config/login";
    private String contactsUrl = "http://cn.address.yahoo.com/yab/cn?VPC=contact_list";

    public YahooImporter(String email, String password) {
        super(email, password);
    }

    @Override
    public void doLogin() throws ContactsException {
        try {
            String content = this.doGet(this.beforeLoginUrl);
            String challenge = this.getInputValue(".challenge", content);
            NameValuePair[] params = new NameValuePair[]{new NameValuePair(".intl", this.getInputValue(".intl", content)), new NameValuePair(".done", this.getInputValue(".done", content)), new NameValuePair(".src", this.getInputValue(".src", content)), new NameValuePair(".cnrid", this.getInputValue(".cnrid", content)), new NameValuePair(".challenge", challenge), new NameValuePair("login", this.email), new NameValuePair("passwd", this.password)};
            content = this.doPost(this.loginUrl, params, this.beforeLoginUrl);
            this.client.getState().addCookie(new Cookie("mail.cn.yahoo.com", "cn_challenge", challenge, "/", null, false));
            String redirectUrl = this.getJSRedirectLocation(content);
            this.doGet(redirectUrl);
        }
        catch (Exception e) {
            throw new ContactsException("Yahoo protocol has changed", e);
        }
    }

    @Override
    public List<Contact> parseContacts() throws ContactsException {
        try {
            String content = this.doGet(this.contactsUrl);
            ArrayList<Contact> contacts = new ArrayList<Contact>();
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(new ByteArrayInputStream(content.getBytes())));
            NodeList nodes = parser.getDocument().getElementsByTagName("td");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getAttributes().getNamedItem("class") == null || !node.getAttributes().getNamedItem("class").getNodeValue().equals("nobottom")) continue;
                String username = node.getChildNodes().item(1).getTextContent().trim();
                String email = nodes.item(++i).getChildNodes().item(1).getChildNodes().item(1).getTextContent().trim();
                contacts.add(new Contact(username, email));
            }
            return contacts;
        }
        catch (Exception e) {
            throw new ContactsException("Yahoo protocol has changed", e);
        }
    }
}

