/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import lombok.core.AnnotationValues;
import lombok.extern.apachecommons.CommonsLog;
import lombok.extern.java.Log;
import lombok.extern.log4j.Log4j;
import lombok.extern.log4j.Log4j2;
import lombok.extern.slf4j.Slf4j;
import lombok.extern.slf4j.XSlf4j;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.JavacTreeMaker;
import lombok.javac.handlers.JavacHandlerUtil;

public class HandleLog {
    private HandleLog() {
        throw new UnsupportedOperationException();
    }

    public static void processAnnotation(LoggingFramework framework, AnnotationValues<?> annotation, JavacNode annotationNode) {
        JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, framework.getAnnotationClass());
        JavacNode typeNode = (JavacNode)annotationNode.up();
        switch (typeNode.getKind()) {
            case TYPE: {
                if ((((JCTree.JCClassDecl)typeNode.get()).mods.flags & 0x200L) != 0L) {
                    annotationNode.addError("@Log is legal only on classes and enums.");
                    return;
                }
                if (JavacHandlerUtil.fieldExists("log", typeNode) != JavacHandlerUtil.MemberExistsResult.NOT_EXISTS) {
                    annotationNode.addWarning("Field 'log' already exists.");
                    return;
                }
                JCTree.JCFieldAccess loggingType = HandleLog.selfType(typeNode);
                HandleLog.createField(framework, typeNode, loggingType, (JCTree)annotationNode.get());
                break;
            }
            default: {
                annotationNode.addError("@Log is legal only on types.");
            }
        }
    }

    public static JCTree.JCFieldAccess selfType(JavacNode typeNode) {
        JavacTreeMaker maker = typeNode.getTreeMaker();
        Name name = ((JCTree.JCClassDecl)typeNode.get()).name;
        return maker.Select(maker.Ident(name), typeNode.toName("class"));
    }

    public static boolean createField(LoggingFramework framework, JavacNode typeNode, JCTree.JCFieldAccess loggingType, JCTree source) {
        JavacTreeMaker maker = typeNode.getTreeMaker();
        JCTree.JCExpression loggerType = JavacHandlerUtil.chainDotsString(typeNode, framework.getLoggerTypeName());
        JCTree.JCExpression factoryMethod = JavacHandlerUtil.chainDotsString(typeNode, framework.getLoggerFactoryMethodName());
        JCTree.JCExpression loggerName = framework.createFactoryParameter(typeNode, loggingType);
        JCTree.JCMethodInvocation factoryMethodCall = maker.Apply(List.<JCTree.JCExpression>nil(), factoryMethod, List.of(loggerName));
        JCTree.JCVariableDecl fieldDecl = JavacHandlerUtil.recursiveSetGeneratedBy(maker.VarDef(maker.Modifiers(26L), typeNode.toName("log"), loggerType, factoryMethodCall), source, typeNode.getContext());
        JavacHandlerUtil.injectFieldSuppressWarnings(typeNode, fieldDecl);
        return true;
    }

    static enum LoggingFramework {
        COMMONS(CommonsLog.class, "org.apache.commons.logging.Log", "org.apache.commons.logging.LogFactory.getLog"),
        JUL(Log.class, "java.util.logging.Logger", "java.util.logging.Logger.getLogger"){

            @Override
            public JCTree.JCExpression createFactoryParameter(JavacNode typeNode, JCTree.JCFieldAccess loggingType) {
                JavacTreeMaker maker = typeNode.getTreeMaker();
                JCTree.JCFieldAccess method = maker.Select(loggingType, typeNode.toName("getName"));
                return maker.Apply(List.<JCTree.JCExpression>nil(), method, List.<JCTree.JCExpression>nil());
            }
        }
        ,
        LOG4J(Log4j.class, "org.apache.log4j.Logger", "org.apache.log4j.Logger.getLogger"),
        LOG4J2(Log4j2.class, "org.apache.logging.log4j.Logger", "org.apache.logging.log4j.LogManager.getLogger"),
        SLF4J(Slf4j.class, "org.slf4j.Logger", "org.slf4j.LoggerFactory.getLogger"),
        XSLF4J(XSlf4j.class, "org.slf4j.ext.XLogger", "org.slf4j.ext.XLoggerFactory.getXLogger");

        private final Class<? extends Annotation> annotationClass;
        private final String loggerTypeName;
        private final String loggerFactoryName;

        private LoggingFramework(Class<? extends Annotation> annotationClass, String loggerTypeName, String loggerFactoryName) {
            this.annotationClass = annotationClass;
            this.loggerTypeName = loggerTypeName;
            this.loggerFactoryName = loggerFactoryName;
        }

        final Class<? extends Annotation> getAnnotationClass() {
            return this.annotationClass;
        }

        final String getLoggerTypeName() {
            return this.loggerTypeName;
        }

        final String getLoggerFactoryMethodName() {
            return this.loggerFactoryName;
        }

        JCTree.JCExpression createFactoryParameter(JavacNode typeNode, JCTree.JCFieldAccess loggingType) {
            return loggingType;
        }
    }

    public static class HandleXSlf4jLog
    extends JavacAnnotationHandler<XSlf4j> {
        @Override
        public void handle(AnnotationValues<XSlf4j> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
            HandleLog.processAnnotation(LoggingFramework.XSLF4J, annotation, annotationNode);
        }
    }

    public static class HandleSlf4jLog
    extends JavacAnnotationHandler<Slf4j> {
        @Override
        public void handle(AnnotationValues<Slf4j> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
            HandleLog.processAnnotation(LoggingFramework.SLF4J, annotation, annotationNode);
        }
    }

    public static class HandleLog4j2Log
    extends JavacAnnotationHandler<Log4j2> {
        @Override
        public void handle(AnnotationValues<Log4j2> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
            HandleLog.processAnnotation(LoggingFramework.LOG4J2, annotation, annotationNode);
        }
    }

    public static class HandleLog4jLog
    extends JavacAnnotationHandler<Log4j> {
        @Override
        public void handle(AnnotationValues<Log4j> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
            HandleLog.processAnnotation(LoggingFramework.LOG4J, annotation, annotationNode);
        }
    }

    public static class HandleJulLog
    extends JavacAnnotationHandler<Log> {
        @Override
        public void handle(AnnotationValues<Log> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
            HandleLog.processAnnotation(LoggingFramework.JUL, annotation, annotationNode);
        }
    }

    public static class HandleCommonsLog
    extends JavacAnnotationHandler<CommonsLog> {
        @Override
        public void handle(AnnotationValues<CommonsLog> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
            HandleLog.processAnnotation(LoggingFramework.COMMONS, annotation, annotationNode);
        }
    }
}

