/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel;

import com.greenpineyu.fel.Expression;
import com.greenpineyu.fel.FelEngine;
import com.greenpineyu.fel.common.FelBuilder;
import com.greenpineyu.fel.compile.CompileService;
import com.greenpineyu.fel.context.ArrayCtxImpl;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.context.Var;
import com.greenpineyu.fel.function.FunMgr;
import com.greenpineyu.fel.function.Function;
import com.greenpineyu.fel.optimizer.Optimizer;
import com.greenpineyu.fel.optimizer.VarVisitOpti;
import com.greenpineyu.fel.parser.AntlrParser;
import com.greenpineyu.fel.parser.FelNode;
import com.greenpineyu.fel.parser.Parser;
import com.greenpineyu.fel.security.SecurityMgr;

public class FelEngineImpl
implements FelEngine {
    private FelContext context;
    private CompileService compiler;
    private Parser parser;
    private FunMgr funMgr;
    private SecurityMgr securityMgr = FelBuilder.newSecurityMgr();

    @Override
    public SecurityMgr getSecurityMgr() {
        return this.securityMgr;
    }

    @Override
    public void setSecurityMgr(SecurityMgr securityMgr) {
        this.securityMgr = securityMgr;
    }

    public FelEngineImpl(FelContext felContext) {
        this.context = felContext;
        this.compiler = new CompileService();
        this.parser = new AntlrParser(this);
        this.funMgr = new FunMgr();
    }

    public FelEngineImpl() {
        this(new ArrayCtxImpl());
    }

    @Override
    public FelNode parse(String string) {
        return this.parser.parse(string);
    }

    @Override
    public Object eval(String string) {
        return this.eval(string, this.context);
    }

    public Object eval(String string, Var ... varArray) {
        FelNode felNode = this.parse(string);
        VarVisitOpti varVisitOpti = new VarVisitOpti(varArray);
        felNode = varVisitOpti.call(this.context, felNode);
        return felNode.eval(this.context);
    }

    @Override
    public Object eval(String string, FelContext felContext) {
        return this.parse(string).eval(felContext);
    }

    public Expression compile(String string, Var ... varArray) {
        return this.compile(string, null, new VarVisitOpti(varArray));
    }

    @Override
    public Expression compile(String string, FelContext felContext, Optimizer ... optimizerArray) {
        if (felContext == null) {
            felContext = this.context;
        }
        FelNode felNode = this.parse(string);
        if (optimizerArray != null) {
            for (Optimizer optimizer : optimizerArray) {
                if (optimizer == null) continue;
                felNode = optimizer.call(felContext, felNode);
            }
        }
        return this.compiler.compile(felContext, felNode, string);
    }

    public String toString() {
        return "FelEngine";
    }

    @Override
    public void addFun(Function function) {
        this.funMgr.add(function);
    }

    @Override
    public FelContext getContext() {
        return this.context;
    }

    @Override
    public CompileService getCompiler() {
        return this.compiler;
    }

    @Override
    public void setCompiler(CompileService compileService) {
        this.compiler = compileService;
    }

    @Override
    public Parser getParser() {
        return this.parser;
    }

    @Override
    public void setParser(Parser parser) {
        this.parser = parser;
    }

    @Override
    public FunMgr getFunMgr() {
        return this.funMgr;
    }

    @Override
    public void setFunMgr(FunMgr funMgr) {
        this.funMgr = funMgr;
    }

    @Override
    public void setContext(FelContext felContext) {
        this.context = felContext;
    }
}

