/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.common;

import com.greenpineyu.fel.FelEngine;
import com.greenpineyu.fel.FelEngineImpl;
import com.greenpineyu.fel.function.FunMgr;
import com.greenpineyu.fel.function.operator.big.BigAdd;
import com.greenpineyu.fel.function.operator.big.BigDiv;
import com.greenpineyu.fel.function.operator.big.BigGreaterThan;
import com.greenpineyu.fel.function.operator.big.BigGreaterThanEqual;
import com.greenpineyu.fel.function.operator.big.BigLessThan;
import com.greenpineyu.fel.function.operator.big.BigLessThanEqual;
import com.greenpineyu.fel.function.operator.big.BigMod;
import com.greenpineyu.fel.function.operator.big.BigMul;
import com.greenpineyu.fel.function.operator.big.BigSub;
import com.greenpineyu.fel.parser.AntlrParser;
import com.greenpineyu.fel.parser.NodeAdaptor;
import com.greenpineyu.fel.security.RegexSecurityMgr;
import com.greenpineyu.fel.security.SecurityMgr;
import java.io.File;
import java.math.BigDecimal;
import java.util.HashSet;

public class FelBuilder {
    public static SecurityMgr newSecurityMgr() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(System.class.getCanonicalName() + ".*");
        hashSet.add(Runtime.class.getCanonicalName() + ".*");
        hashSet.add(Process.class.getCanonicalName() + ".*");
        hashSet.add(File.class.getCanonicalName() + ".*");
        hashSet.add("java.net.*");
        hashSet.add("com.greenpineyu.fel.compile.*");
        hashSet.add("com.greenpineyu.fel.security.*");
        return new RegexSecurityMgr(null, hashSet);
    }

    public static void main(String[] stringArray) {
        System.out.println(System.class.getCanonicalName());
        System.out.println(Long.toBinaryString(0xFFFFFFFFL));
        System.out.println(Long.toBinaryString(Long.MAX_VALUE).length());
        System.out.println(Long.MAX_VALUE);
    }

    public static FelEngine bigNumberEngine() {
        return FelBuilder.bigNumberEngine(100);
    }

    public static FelEngine engine() {
        return new FelEngineImpl();
    }

    public static FelEngine bigNumberEngine(int n) {
        FelEngineImpl felEngineImpl = new FelEngineImpl();
        FunMgr funMgr = felEngineImpl.getFunMgr();
        felEngineImpl.setParser(new AntlrParser(felEngineImpl, new NodeAdaptor(){

            @Override
            protected Number newFloatNumber(String string) {
                char c = string.charAt(string.length() - 1);
                if (c == 'l' || c == 'L' || c == 'd' || c == 'D' || c == 'f' || c == 'F') {
                    string = string.substring(0, string.length() - 1);
                }
                return new BigDecimal(string);
            }
        }));
        funMgr.add(new BigAdd());
        funMgr.add(new BigSub());
        funMgr.add(new BigMul());
        funMgr.add(new BigDiv(n));
        funMgr.add(new BigMod());
        funMgr.add(new BigGreaterThan());
        funMgr.add(new BigGreaterThanEqual());
        funMgr.add(new BigLessThan());
        funMgr.add(new BigLessThanEqual());
        return felEngineImpl;
    }
}

