/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.compile;

import com.greenpineyu.fel.Expression;
import com.greenpineyu.fel.common.StringUtils;
import com.greenpineyu.fel.compile.CompileService;
import com.greenpineyu.fel.compile.FelCompiler;
import com.greenpineyu.fel.compile.FileClassLoader;
import com.greenpineyu.fel.compile.JavaSource;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class AbstCompiler
implements FelCompiler {
    static final String CLASS_DIR;
    private String classpath4compile = this.classPathToString();
    private static final String BASE_DIR;
    static ClassLoader loader;
    private static ExecutorService exeService;

    static String getClassPackageDir(String string) {
        return CLASS_DIR + AbstCompiler.packageToPath(string) + File.separator;
    }

    protected String classPathToString() {
        List<String> list = CompileService.getClassPath(this.getClass().getClassLoader());
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string + File.pathSeparator);
        }
        return stringBuilder.toString();
    }

    static String getSrcPackageDir(String string) {
        return BASE_DIR + "src" + File.separator + AbstCompiler.packageToPath(string) + File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expression compile(JavaSource javaSource) {
        try {
            Class<Expression> clazz = this.compileToClass(javaSource);
            Expression expression = clazz.newInstance();
            return expression;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        finally {
            String string = javaSource.getName();
            String string2 = javaSource.getPackageName();
            String string3 = AbstCompiler.getSrcPackageDir(string2);
            this.clean(string3, AbstCompiler.getClassPackageDir(string2), string);
        }
        return null;
    }

    abstract Class<Expression> compileToClass(JavaSource var1) throws ClassNotFoundException;

    static void createClassDir() {
        new File(CLASS_DIR).mkdirs();
    }

    private static ExecutorService initThreadPool() {
        return new ThreadPoolExecutor(0, 10, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    void clean(final String string, final String string2, final String string3) {
        if (exeService.isShutdown()) {
            exeService = AbstCompiler.initThreadPool();
        }
        exeService.execute(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setPriority(1);
                AbstCompiler.this.delFile(string, string2, string3);
            }
        });
    }

    void delFile(String string, String string2, String string3) {
        String string4 = string + string3 + ".java";
        this.deleteFile(string4);
        String string5 = string2 + string3 + ".class";
        this.deleteFile(string5);
    }

    void deleteFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
    }

    List<String> getCompileOption() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-encoding");
        arrayList.add("UTF-8");
        arrayList.add("-d");
        arrayList.add(CLASS_DIR);
        if (StringUtils.isNotEmpty(this.classpath4compile)) {
            arrayList.add("-classpath");
            arrayList.add(this.classpath4compile);
        }
        return arrayList;
    }

    private static String packageToPath(String string) {
        String string2 = File.separator;
        return StringUtils.replace(string, ".", string2);
    }

    static {
        String string = System.getProperty("user.dir");
        BASE_DIR = string + File.separator + "fel" + File.separator;
        CLASS_DIR = BASE_DIR + "classes" + File.separator;
        loader = new FileClassLoader(AbstCompiler.class.getClassLoader(), CLASS_DIR);
        AbstCompiler.createClassDir();
        exeService = AbstCompiler.initThreadPool();
    }
}

