/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.context;

import com.greenpineyu.fel.context.ArrayCtx;
import com.greenpineyu.fel.context.Var;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ArrayCtxImpl
implements ArrayCtx {
    private Var[] vars = new Var[10];
    private Map<String, Integer> indexMap = new HashMap<String, Integer>();

    public ArrayCtxImpl() {
    }

    public ArrayCtxImpl(Map<String, Object> map) {
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                this.set(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public Object get(int n) {
        return this.vars[n].getValue();
    }

    @Override
    public int getIndex(String string) {
        Integer n = this.indexMap.get(string);
        return n != null ? n : -1;
    }

    @Override
    public Object get(String string) {
        Var var = this.getVar(string);
        return var != null ? var.getValue() : null;
    }

    @Override
    public Var getVar(String string) {
        int n = this.getIndex(string);
        if (n == -1) {
            return null;
        }
        return this.vars[n];
    }

    private Var getVarWithoutNull(String string) {
        Var var = this.getVar(string);
        if (var == null) {
            var = new Var(string, null);
            this.setVar(var);
        }
        return var;
    }

    public void ensureCapacity(int n) {
        int n2 = this.vars.length;
        if (n > n2) {
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.vars = Arrays.copyOf(this.vars, n3);
        }
    }

    @Override
    public void set(String string, Object object) {
        this.getVarWithoutNull(string).setValue(object);
    }

    @Override
    public void setVar(Var var) {
        int n = this.addToIndexMap(var.getName());
        if (n >= this.vars.length) {
            this.ensureCapacity(n + 1);
        }
        this.vars[n] = var;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addToIndexMap(String string) {
        Map<String, Integer> map = this.indexMap;
        synchronized (map) {
            Integer n = this.indexMap.get(string);
            if (n != null) {
                return n;
            }
            int n2 = this.indexMap.size();
            this.indexMap.put(string, n2);
            return n2;
        }
    }
}

