/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.function.operator;

import com.greenpineyu.fel.common.NumberUtil;
import com.greenpineyu.fel.common.ReflectUtil;
import com.greenpineyu.fel.compile.FelMethod;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.exception.CompileException;
import com.greenpineyu.fel.exception.EvalException;
import com.greenpineyu.fel.function.StableFunction;
import com.greenpineyu.fel.parser.FelNode;
import java.util.List;

public class Sub
extends StableFunction {
    private void appendArg(StringBuilder stringBuilder, SourceBuilder sourceBuilder, FelContext felContext, FelNode felNode) {
        Class<?> clazz = sourceBuilder.returnType(felContext, felNode);
        stringBuilder.append("(");
        if (ReflectUtil.isPrimitiveOrWrapNumber(clazz)) {
            stringBuilder.append(sourceBuilder.source(felContext, felNode));
        } else if (CharSequence.class.isAssignableFrom(clazz)) {
            // empty if block
        }
        stringBuilder.append(")");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public FelMethod toMethod(FelNode felNode, FelContext felContext) {
        Object object;
        List<FelNode> list = felNode.getChildren();
        StringBuilder stringBuilder = new StringBuilder();
        Class<?> clazz = null;
        if (list.size() == 2) {
            object = list.get(0);
            SourceBuilder sourceBuilder = object.toMethod(felContext);
            Class<?> clazz2 = sourceBuilder.returnType(felContext, (FelNode)object);
            this.appendArg(stringBuilder, sourceBuilder, felContext, (FelNode)object);
            FelNode felNode2 = list.get(1);
            SourceBuilder sourceBuilder2 = felNode2.toMethod(felContext);
            Class<?> clazz3 = sourceBuilder2.returnType(felContext, felNode2);
            stringBuilder.append("-");
            this.appendArg(stringBuilder, sourceBuilder2, felContext, felNode2);
            if (!ReflectUtil.isPrimitiveOrWrapNumber(clazz2)) throw new CompileException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b[" + ReflectUtil.getClassName(clazz2) + "\u3001" + ReflectUtil.getClassName(clazz3) + "]\u3002\u51cf[-]\u8fd0\u7b97\u53ea\u652f\u6301\u6570\u503c\u7c7b\u578b");
            if (!ReflectUtil.isPrimitiveOrWrapNumber(clazz3)) throw new CompileException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b[" + ReflectUtil.getClassName(clazz2) + "\u3001" + ReflectUtil.getClassName(clazz3) + "]\u3002\u51cf[-]\u8fd0\u7b97\u53ea\u652f\u6301\u6570\u503c\u7c7b\u578b");
            clazz = NumberUtil.arithmeticClass(clazz2, clazz3);
            return new FelMethod(clazz, stringBuilder.toString());
        } else {
            if (list.size() != 1) return new FelMethod(clazz, stringBuilder.toString());
            object = list.get(0);
            SourceBuilder sourceBuilder = object.toMethod(felContext);
            Class<?> clazz4 = sourceBuilder.returnType(felContext, (FelNode)object);
            stringBuilder.append("-");
            this.appendArg(stringBuilder, sourceBuilder, felContext, (FelNode)object);
            if (!ReflectUtil.isPrimitiveOrWrapNumber(clazz4)) return new FelMethod(clazz, stringBuilder.toString());
            clazz = clazz4;
        }
        return new FelMethod(clazz, stringBuilder.toString());
    }

    @Override
    public String getName() {
        return "-";
    }

    @Override
    public Object call(FelNode felNode, FelContext felContext) {
        List<FelNode> list = felNode.getChildren();
        if (list.size() == 2) {
            FelNode felNode2 = list.get(0);
            Object object = felNode2.eval(felContext);
            FelNode felNode3 = list.get(1);
            Object object2 = felNode3.eval(felContext);
            if (object instanceof Number && object2 instanceof Number) {
                double d = NumberUtil.toDouble(object);
                double d2 = NumberUtil.toDouble(object2);
                return NumberUtil.parseNumber(d - d2);
            }
            throw new EvalException("\u6267\u884c\u51cf\u6cd5\u51fa\u9519\uff0c\u53c2\u6570\u5fc5\u987b\u662f\u6570\u503c\u578b");
        }
        if (list.size() == 1) {
            FelNode felNode4 = list.get(0);
            Object object = felNode4.eval(felContext);
            if (object instanceof Number) {
                if (NumberUtil.isFloatingPoint(object)) {
                    return NumberUtil.toDouble(object) * -1.0;
                }
                return NumberUtil.parseNumber(((Number)object).longValue() * -1L);
            }
            throw new EvalException("\u6267\u884c\u51cf\u6cd5\u51fa\u9519\uff0c\u53c2\u6570\u5fc5\u987b\u662f\u6570\u503c\u578b");
        }
        throw new EvalException("\u6267\u884c\u51cf\u6cd5\u51fa\u9519\uff0c\u53c2\u6570\u957f\u5ea6\u5fc5\u987b\u662f1\u62162");
    }

    public static void main(String[] stringArray) {
        int n = -1;
        System.out.println(n);
    }
}

