/*
 * Decompiled with CFR 0.152.
 */
package com.ifp.wechat.service;

import com.ifp.wechat.util.StringUtil;
import com.ifp.wechat.util.WeixinUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QRcodeService {
    private static final Logger a = LoggerFactory.getLogger(QRcodeService.class);
    static String QRCODE_ACTION = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=TOKEN";
    static String QRCODE_IMG_URL = "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=TICKET";
    public static final String QRCODE_SCENE = "QR_SCENE";
    public static final String QRCODE_LIMIT_SCENE = "QR_LIMIT_SCENE";
    public static final int ExpireSeconds = 300000;

    public static String getTicket(String actionName, int sceneId) {
        String url = QRCODE_ACTION.replace("TOKEN", WeixinUtil.getToken());
        String ticket = "";
        String qrdata = "{" + (actionName.equals(QRCODE_SCENE) ? "\"expire_seconds\":300000," : "") + " \"action_name\": \"" + actionName + "\", \"action_info\": {\"scene\": {\"scene_id\": " + sceneId + "}}}";
        JSONObject jsonObject = WeixinUtil.httpsRequest(url, "POST", qrdata);
        if (jsonObject != null) {
            if (StringUtil.isNotEmpty(jsonObject.get("errcode")) && jsonObject.get("errcode") != "0") {
                a.error("\u4e8c\u7ef4\u7801ticket\u8bf7\u6c42\u5931\u8d25\uff0cerrcode:" + jsonObject.getInt("errcode") + "\uff0cerrmsg:" + jsonObject.getString("errmsg"));
            } else {
                ticket = jsonObject.getString("ticket");
            }
        }
        return ticket;
    }

    public static String getQrCodeImgURL(String ticket) {
        try {
            ticket = URLEncoder.encode(ticket, "utf-8");
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        return QRCODE_IMG_URL.replace("TICKET", ticket);
    }
}

