/*
 * Decompiled with CFR 0.152.
 */
package com.ifp.wechat.util;

import com.ifp.wechat.entity.message.resp.Article;
import com.ifp.wechat.entity.message.resp.NewsMessage;
import com.ifp.wechat.entity.message.resp.TextMessage;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.core.util.QuickWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class MessageUtil {
    private static XStream a = new XStream(new XppDriver(){

        @Override
        public HierarchicalStreamWriter createWriter(Writer out) {
            return new PrettyPrintWriter(out){
                boolean cdata;
                {
                    this.cdata = true;
                }

                @Override
                protected void writeText(QuickWriter writer, String text) {
                    if (this.cdata) {
                        writer.write("<![CDATA[");
                        writer.write(text);
                        writer.write("]]>");
                    } else {
                        writer.write(text);
                    }
                }
            };
        }
    });

    public static Map<String, String> parseXml(HttpServletRequest request) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        ServletInputStream inputStream = request.getInputStream();
        SAXReader reader = new SAXReader();
        Document document = reader.read(inputStream);
        Element root = document.getRootElement();
        List elementList = root.elements();
        for (Element e2 : elementList) {
            map.put(e2.getName(), e2.getText());
        }
        inputStream.close();
        inputStream = null;
        return map;
    }

    public static String messageToXml(Object message) {
        a.alias("xml", message.getClass());
        return a.toXML(message);
    }

    public static String textMessageToXml(TextMessage textMessage) {
        a.alias("xml", textMessage.getClass());
        return a.toXML(textMessage);
    }

    public static String newsMessageToXml(NewsMessage newsMessage) {
        a.alias("xml", newsMessage.getClass());
        a.alias("item", new Article().getClass());
        return a.toXML(newsMessage);
    }

    public static String emoji(int hexEmoji) {
        return String.valueOf(Character.toChars(hexEmoji));
    }
}

