/*
 * Decompiled with CFR 0.152.
 */
package com.ifp.wechat.util;

import com.ifp.wechat.constant.ConstantWeChat;
import com.ifp.wechat.entity.AccessToken;
import com.ifp.wechat.service.UserGroupService;
import com.ifp.wechat.util.MyX509TrustManager;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.URL;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeixinUtil {
    private static final Logger a = LoggerFactory.getLogger(UserGroupService.class);
    public static final String ACCESS_TOKEN = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET";

    public static AccessToken getAccessToken(String appid, String appsecret) {
        AccessToken accessToken = null;
        String requestUrl = ACCESS_TOKEN.replace("APPID", appid).replace("APPSECRET", appsecret);
        JSONObject jsonObject = WeixinUtil.httpsRequest(requestUrl, "GET", null);
        if (jsonObject != null) {
            try {
                accessToken = new AccessToken();
                accessToken.setToken(jsonObject.getString("access_token"));
                accessToken.setExpiresIn(jsonObject.getInt("expires_in"));
            }
            catch (JSONException e2) {
                accessToken = null;
                a.error("\u83b7\u53d6token\u5931\u8d25 errcode:" + jsonObject.getInt("errcode") + "\uff0cerrmsg:" + jsonObject.getString("errmsg"));
            }
        }
        return accessToken;
    }

    public static String getToken() {
        AccessToken at2 = WeixinUtil.getAccessToken(ConstantWeChat.APPID, ConstantWeChat.APPSECRET);
        if (at2 != null) {
            return at2.getToken();
        }
        return null;
    }

    public static JSONObject httpsRequest(String requestUrl, String requestMethod, String outputStr) {
        JSONObject jsonObject = null;
        StringBuffer buffer = new StringBuffer();
        try {
            TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            URL url = new URL(requestUrl);
            HttpsURLConnection httpUrlConn = (HttpsURLConnection)url.openConnection();
            httpUrlConn.setSSLSocketFactory(ssf);
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            httpUrlConn.setRequestMethod(requestMethod);
            if ("GET".equalsIgnoreCase(requestMethod)) {
                httpUrlConn.connect();
            }
            if (outputStr != null) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                outputStream.write(outputStr.getBytes("UTF-8"));
                outputStream.close();
            }
            InputStream inputStream = httpUrlConn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            inputStream = null;
            httpUrlConn.disconnect();
            jsonObject = JSONObject.fromObject(buffer.toString());
        }
        catch (ConnectException ce2) {
            a.error("server connection timed out.");
        }
        catch (Exception e2) {
            a.error("https request error:", e2);
        }
        return jsonObject;
    }

    public static String formatTime(String createTime) {
        long msgCreateTime = Long.parseLong(createTime) * 1000L;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(new Date(msgCreateTime));
    }
}

