/*
 * Decompiled with CFR 0.152.
 */
package org.app.calendar;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.app.common.enums.ECalNoticeType;
import org.app.common.enums.ECalendarSource;
import org.app.common.enums.EUrgentType;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.common.db.AbsPojoEntity;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(value={"user"})
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class Calendar
extends AbsPojoEntity
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(Calendar.class);
    private Long id;
    private long cid = EUrgentType.\u666e\u901a.getValue();
    private String title;
    @JsonProperty(value="start")
    private Date cal_start;
    @JsonProperty(value="end")
    private Date cal_end;
    private String notes;
    private Boolean ad = false;
    private String rem;
    @JsonIgnore
    private ECalNoticeType[] noticeType;
    private String noticeType_FMT = "";
    private Boolean gx = false;
    private String fabuRen;
    private Boolean isEditor;
    private Long creater;
    private Long createTime;
    private ECalendarSource source = ECalendarSource.\u65e5\u5386;
    private Long assPid;

    public String getStartJs() {
        SimpleDateFormat form = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return form.format(this.cal_start);
    }

    public String getSimpleStartJs() {
        SimpleDateFormat form = new SimpleDateFormat("M/d\u65e5 H:mm");
        return form.format(this.cal_start);
    }

    public String getEndJs() {
        SimpleDateFormat form = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return form.format(this.cal_end);
    }

    public String getSimpleEndJs() {
        SimpleDateFormat form = new SimpleDateFormat("M/d\u65e5 H:mm");
        return form.format(this.cal_end);
    }

    public void setNoticeType(ECalNoticeType[] n2) {
        if (n2 != null && n2.length > 0) {
            this.noticeType = n2;
            this.noticeType_FMT = "";
            ECalNoticeType[] eCalNoticeTypeArray = n2;
            int n3 = n2.length;
            int n4 = 0;
            while (n4 < n3) {
                ECalNoticeType e2 = eCalNoticeTypeArray[n4];
                this.noticeType_FMT = String.valueOf(this.noticeType_FMT) + (Object)((Object)e2) + ",";
                ++n4;
            }
        }
    }

    public ECalNoticeType[] getNoticeType() {
        String[] types;
        if (StringUtils.isNotBlank(this.noticeType_FMT) && (types = this.noticeType_FMT.split("\\,")) != null && types.length > 0) {
            this.noticeType = new ECalNoticeType[types.length];
            int n2 = 0;
            while (n2 < types.length) {
                if (StringUtils.isNotBlank(types[n2])) {
                    try {
                        this.noticeType[n2] = Enum.valueOf(ECalNoticeType.class, types[n2]);
                    }
                    catch (Exception ex) {
                        logger.error("types:{},err:{}", (Object)types[n2], (Object)ex);
                    }
                }
                ++n2;
            }
        }
        return this.noticeType;
    }

    public void setNoticeType_FMT(String str) {
        String string = this.noticeType_FMT = str == null ? "" : str;
        if (StringUtils.isNotBlank(str) && str.endsWith(",")) {
            this.noticeType_FMT = str.substring(0, str.length() - 1);
        }
    }

    public String getCreater_FMT() {
        return dt.a(this.creater);
    }

    public String getCreateTime_FMT() {
        if (this.createTime != null) {
            return ck.d(this.createTime);
        }
        return "";
    }

    public Long getId() {
        return this.id;
    }

    public long getCid() {
        return this.cid;
    }

    public String getTitle() {
        return this.title;
    }

    public Date getCal_start() {
        return this.cal_start;
    }

    public Date getCal_end() {
        return this.cal_end;
    }

    public String getNotes() {
        return this.notes;
    }

    public Boolean getAd() {
        return this.ad;
    }

    public String getRem() {
        return this.rem;
    }

    public String getNoticeType_FMT() {
        return this.noticeType_FMT;
    }

    public Boolean getGx() {
        return this.gx;
    }

    public String getFabuRen() {
        return this.fabuRen;
    }

    public Boolean getIsEditor() {
        return this.isEditor;
    }

    public Long getCreater() {
        return this.creater;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public ECalendarSource getSource() {
        return this.source;
    }

    public Long getAssPid() {
        return this.assPid;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCid(long cid) {
        this.cid = cid;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCal_start(Date cal_start) {
        this.cal_start = cal_start;
    }

    public void setCal_end(Date cal_end) {
        this.cal_end = cal_end;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public void setAd(Boolean ad2) {
        this.ad = ad2;
    }

    public void setRem(String rem) {
        this.rem = rem;
    }

    public void setGx(Boolean gx) {
        this.gx = gx;
    }

    public void setFabuRen(String fabuRen) {
        this.fabuRen = fabuRen;
    }

    public void setIsEditor(Boolean isEditor) {
        this.isEditor = isEditor;
    }

    public void setCreater(Long creater) {
        this.creater = creater;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setSource(ECalendarSource source) {
        this.source = source;
    }

    public void setAssPid(Long assPid) {
        this.assPid = assPid;
    }
}

