/*
 * Decompiled with CFR 0.152.
 */
package org.app.contactsmanager.importer.log;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.app.common.enums.EImportCategory;
import org.app.common.enums.EImportDuplicateStrategy;
import org.app.common.enums.EImportFileType;
import org.app.common.enums.EImportNameConflict;
import org.app.common.enums.EImportNewContactWay;
import org.app.contactsmanager.Contacts;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.common.db.AbsPojoEntity;
import org.group.user.User;

@Entity
@Table(name="cc_importlog")
public class ImportLog
extends AbsPojoEntity {
    private String fileName;
    private EImportFileType fileType;
    private String charsetType;
    private boolean firstLineHeader;
    private EImportCategory categroy;
    private String dependField;
    private String categroyPid;
    private String categroyName;
    private EImportDuplicateStrategy dupStrategy;
    private EImportNewContactWay newContactWay = EImportNewContactWay.\u5408\u5e76;
    private EImportNameConflict nameConflict = EImportNameConflict.\u5907\u6ce8;
    private String errLogFileName;
    private int successCnt;
    private int failCnt;
    private long importTime;
    @JsonIgnore
    @ManyToOne
    private User user;
    @JsonIgnore
    @OneToMany(mappedBy="\u5bfc\u5165\u65e5\u5fd7")
    private Set<Contacts> contacts = new HashSet<Contacts>();

    public String getImportTime_FMT() {
        return ck.e(ci.a(this.importTime));
    }

    public String getUserName() {
        if (this.user != null) {
            return this.user.getUserName();
        }
        return "";
    }

    public String genErrLogFn() {
        String baseName = FilenameUtils.getBaseName(this.fileName);
        String ext = FilenameUtils.getExtension(this.fileName);
        if (StringUtils.isBlank(ext)) {
            ext = this.fileType.name().toLowerCase();
        }
        return String.valueOf(baseName) + "_err_" + this.importTime + "." + ext;
    }

    public String getFileName() {
        return this.fileName;
    }

    public EImportFileType getFileType() {
        return this.fileType;
    }

    public String getCharsetType() {
        return this.charsetType;
    }

    public boolean isFirstLineHeader() {
        return this.firstLineHeader;
    }

    public EImportCategory getCategroy() {
        return this.categroy;
    }

    public String getDependField() {
        return this.dependField;
    }

    public String getCategroyPid() {
        return this.categroyPid;
    }

    public String getCategroyName() {
        return this.categroyName;
    }

    public EImportDuplicateStrategy getDupStrategy() {
        return this.dupStrategy;
    }

    public EImportNewContactWay getNewContactWay() {
        return this.newContactWay;
    }

    public EImportNameConflict getNameConflict() {
        return this.nameConflict;
    }

    public String getErrLogFileName() {
        return this.errLogFileName;
    }

    public int getSuccessCnt() {
        return this.successCnt;
    }

    public int getFailCnt() {
        return this.failCnt;
    }

    public long getImportTime() {
        return this.importTime;
    }

    public User getUser() {
        return this.user;
    }

    public Set<Contacts> getContacts() {
        return this.contacts;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFileType(EImportFileType fileType) {
        this.fileType = fileType;
    }

    public void setCharsetType(String charsetType) {
        this.charsetType = charsetType;
    }

    public void setFirstLineHeader(boolean firstLineHeader) {
        this.firstLineHeader = firstLineHeader;
    }

    public void setCategroy(EImportCategory categroy) {
        this.categroy = categroy;
    }

    public void setDependField(String dependField) {
        this.dependField = dependField;
    }

    public void setCategroyPid(String categroyPid) {
        this.categroyPid = categroyPid;
    }

    public void setCategroyName(String categroyName) {
        this.categroyName = categroyName;
    }

    public void setDupStrategy(EImportDuplicateStrategy dupStrategy) {
        this.dupStrategy = dupStrategy;
    }

    public void setNewContactWay(EImportNewContactWay newContactWay) {
        this.newContactWay = newContactWay;
    }

    public void setNameConflict(EImportNameConflict nameConflict) {
        this.nameConflict = nameConflict;
    }

    public void setErrLogFileName(String errLogFileName) {
        this.errLogFileName = errLogFileName;
    }

    public void setSuccessCnt(int successCnt) {
        this.successCnt = successCnt;
    }

    public void setFailCnt(int failCnt) {
        this.failCnt = failCnt;
    }

    public void setImportTime(long importTime) {
        this.importTime = importTime;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setContacts(Set<Contacts> contacts) {
        this.contacts = contacts;
    }
}

