/*
 * Decompiled with CFR 0.152.
 */
package org.app.sms;

import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.app.callBill.CallBillView;
import org.app.common.enums.ECalNoticeType;
import org.app.common.enums.ESmsTiggerType;
import org.app.common.enums.ETimeSpanType;
import org.app.contactsmanager.Contacts;
import org.app.sms.SmsTpl;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.common.db.AbsPojoEntity;
import org.common.enums.LaiDianQuDian;
import org.common.phone.CCPhoneNumber;
import org.group.user.User;

@Entity
@Table(name="cc_smsnotice")
public class SmsNotice
extends AbsPojoEntity {
    @JsonIgnore
    @Transient
    private ECalNoticeType[] remindType = new ECalNoticeType[]{ECalNoticeType.\u77ed\u4fe1, ECalNoticeType.\u5fae\u4fe1\u63d0\u9192};
    private String remindType_FMT = "";
    @Column
    private ESmsTiggerType noticeType;
    @Column
    private boolean includeNullPhone = false;
    @Column
    private boolean includeUnknowNum = true;
    @Column
    private int talkMinSecond = 3;
    @Column
    private int ringNumOrMore = 3;
    @Column
    private Integer startHour = 0;
    @Column
    private Integer endHour = 23;
    @Column(name="creater")
    private Long \u521b\u5efa\u4eba;
    @Column(name="createtime", length=15)
    private Long \u521b\u5efa\u65f6\u95f4;
    @JsonIgnore
    @ManyToOne
    private SmsTpl smsTpl;
    @Column
    private int timeSpan = 0;
    @Column
    private ETimeSpanType timeSpanType = ETimeSpanType.\u5206\u949f;
    private String ownerPhoneNum;
    private boolean enabled = false;
    private String[] type;

    @JsonIgnore
    public void setRemindType(ECalNoticeType[] n2) {
        if (n2 != null && n2.length > 0) {
            this.remindType = n2;
            this.remindType_FMT = "";
            ECalNoticeType[] eCalNoticeTypeArray = n2;
            int n3 = n2.length;
            int n4 = 0;
            while (n4 < n3) {
                ECalNoticeType e2 = eCalNoticeTypeArray[n4];
                this.remindType_FMT = String.valueOf(this.remindType_FMT) + (Object)((Object)e2) + ",";
                ++n4;
            }
        }
    }

    @JsonIgnore
    public ECalNoticeType[] getRemindType() {
        String[] types;
        if (StringUtils.isNotBlank(this.remindType_FMT) && (types = this.remindType_FMT.split("\\,")) != null && types.length > 0) {
            this.remindType = new ECalNoticeType[types.length];
            int n2 = 0;
            while (n2 < types.length) {
                if (StringUtils.isNotBlank(types[n2])) {
                    this.remindType[n2] = Enum.valueOf(ECalNoticeType.class, types[n2]);
                }
                ++n2;
            }
        }
        return this.remindType;
    }

    public void setRemindType_FMT(String str) {
        String string = this.remindType_FMT = str == null ? "" : str;
        if (StringUtils.isNotBlank(str) && str.endsWith(",")) {
            this.remindType_FMT = str.substring(0, str.length() - 1);
        }
    }

    public Integer getStartHour() {
        return this.startHour == null ? 0 : this.startHour;
    }

    public Integer getEndHour() {
        return this.endHour == null ? 23 : this.endHour;
    }

    public String get\u521b\u5efa\u65f6\u95f4_FMT() {
        if (this.\u521b\u5efa\u65f6\u95f4 != null) {
            return ck.d(this.\u521b\u5efa\u65f6\u95f4);
        }
        return "";
    }

    public long getSmsTplID() {
        if (this.smsTpl != null) {
            return this.smsTpl.getPid();
        }
        return 0L;
    }

    private long a() {
        if (this.timeSpanType == ETimeSpanType.\u5206\u949f) {
            return this.timeSpan * 60;
        }
        if (this.timeSpanType == ETimeSpanType.\u5c0f\u65f6) {
            return this.timeSpan * 3600;
        }
        if (this.timeSpanType == ETimeSpanType.\u5929) {
            return this.timeSpan * 3600 * 24;
        }
        return 0L;
    }

    public boolean hasWXRemindType(User currUser) {
        return this.remindType != null && currUser.isWXBinded() && ArrayUtils.contains((Object[])this.remindType, (Object)ECalNoticeType.\u5fae\u4fe1\u63d0\u9192);
    }

    public boolean hasSMSRemindType() {
        return this.remindType != null && ArrayUtils.contains((Object[])this.remindType, (Object)ECalNoticeType.\u77ed\u4fe1) && StringUtils.isNotBlank(this.ownerPhoneNum);
    }

    public boolean canNotice(Contacts c2, String phNum, LaiDianQuDian ldqd, long talkSec, int ringNum, User currUser) {
        boolean flag = false;
        boolean isUnAnswerType = false;
        CCPhoneNumber ccph = ax.a.a(phNum);
        Calendar cal = Calendar.getInstance();
        int hour = cal.get(11);
        if (this.enabled && hour >= this.getStartHour() && hour <= this.getEndHour()) {
            if (this.noticeType == ESmsTiggerType.\u672a\u63a5\u6765\u7535) {
                if ((this.hasWXRemindType(currUser) || this.hasSMSRemindType()) && ringNum >= this.ringNumOrMore && (StringUtils.isNotBlank(phNum) || this.includeNullPhone) && (c2 != null || this.includeUnknowNum)) {
                    flag = true;
                    isUnAnswerType = true;
                }
            } else if (this.noticeType == ESmsTiggerType.\u672a\u63a5\u81f4\u6b49) {
                if (ringNum >= this.ringNumOrMore && this.smsTpl != null && StringUtils.isNotBlank(phNum) && ccph.is\u624b\u673a\u53f7()) {
                    flag = true;
                    isUnAnswerType = true;
                }
            } else if (this.type != null && this.type.length > 0 && this.smsTpl != null && StringUtils.isNotBlank(phNum) && ccph.is\u624b\u673a\u53f7() && (c2 != null || this.includeUnknowNum) && talkSec >= (long)this.talkMinSecond) {
                String t2;
                int n2;
                if (ldqd == LaiDianQuDian.\u6765\u7535) {
                    String[] stringArray = this.type;
                    int n3 = this.type.length;
                    n2 = 0;
                    while (n2 < n3) {
                        t2 = stringArray[n2];
                        if (t2.equals(ESmsTiggerType.\u6765\u7535\u6302\u673a.name())) {
                            flag = true;
                            break;
                        }
                        ++n2;
                    }
                } else if (ldqd == LaiDianQuDian.\u53bb\u7535) {
                    String[] stringArray = this.type;
                    int n4 = this.type.length;
                    n2 = 0;
                    while (n2 < n4) {
                        t2 = stringArray[n2];
                        if (t2.equals(ESmsTiggerType.\u53bb\u7535\u6302\u673a.name())) {
                            flag = true;
                            break;
                        }
                        ++n2;
                    }
                }
            }
            if (flag) {
                CallBillView cbv = ak.a(phNum, "d.\u77ed\u4fe1\u53d1\u9001\u72b6\u6001 = 1 and d.\u901a\u8bdd\u65f6\u957f " + (isUnAnswerType ? "<=" : ">") + " 0", null);
                if (cbv != null) {
                    long s2 = cm.a(cbv.get\u901a\u8bdd\u7ed3\u675f\u65f6\u95f4(), ci.a());
                    if (s2 >= this.a()) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            flag = false;
        }
        return flag;
    }

    public String getRemindType_FMT() {
        return this.remindType_FMT;
    }

    public ESmsTiggerType getNoticeType() {
        return this.noticeType;
    }

    public boolean isIncludeNullPhone() {
        return this.includeNullPhone;
    }

    public boolean isIncludeUnknowNum() {
        return this.includeUnknowNum;
    }

    public int getTalkMinSecond() {
        return this.talkMinSecond;
    }

    public int getRingNumOrMore() {
        return this.ringNumOrMore;
    }

    public Long get\u521b\u5efa\u4eba() {
        return this.\u521b\u5efa\u4eba;
    }

    public Long get\u521b\u5efa\u65f6\u95f4() {
        return this.\u521b\u5efa\u65f6\u95f4;
    }

    public SmsTpl getSmsTpl() {
        return this.smsTpl;
    }

    public int getTimeSpan() {
        return this.timeSpan;
    }

    public ETimeSpanType getTimeSpanType() {
        return this.timeSpanType;
    }

    public String getOwnerPhoneNum() {
        return this.ownerPhoneNum;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String[] getType() {
        return this.type;
    }

    public void setNoticeType(ESmsTiggerType noticeType) {
        this.noticeType = noticeType;
    }

    public void setIncludeNullPhone(boolean includeNullPhone) {
        this.includeNullPhone = includeNullPhone;
    }

    public void setIncludeUnknowNum(boolean includeUnknowNum) {
        this.includeUnknowNum = includeUnknowNum;
    }

    public void setTalkMinSecond(int talkMinSecond) {
        this.talkMinSecond = talkMinSecond;
    }

    public void setRingNumOrMore(int ringNumOrMore) {
        this.ringNumOrMore = ringNumOrMore;
    }

    public void setStartHour(Integer startHour) {
        this.startHour = startHour;
    }

    public void setEndHour(Integer endHour) {
        this.endHour = endHour;
    }

    public void set\u521b\u5efa\u4eba(Long \u521b\u5efa\u4eba) {
        this.\u521b\u5efa\u4eba = \u521b\u5efa\u4eba;
    }

    public void set\u521b\u5efa\u65f6\u95f4(Long \u521b\u5efa\u65f6\u95f4) {
        this.\u521b\u5efa\u65f6\u95f4 = \u521b\u5efa\u65f6\u95f4;
    }

    public void setSmsTpl(SmsTpl smsTpl) {
        this.smsTpl = smsTpl;
    }

    public void setTimeSpan(int timeSpan) {
        this.timeSpan = timeSpan;
    }

    public void setTimeSpanType(ETimeSpanType timeSpanType) {
        this.timeSpanType = timeSpanType;
    }

    public void setOwnerPhoneNum(String ownerPhoneNum) {
        this.ownerPhoneNum = ownerPhoneNum;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setType(String[] type) {
        this.type = type;
    }
}

