/*
 * Decompiled with CFR 0.152.
 */
package org.common.zip;

import com.update.UpdateHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ZipUtils {
    private static final Logger a = LoggerFactory.getLogger(UpdateHelper.class);
    private static ZipParameters a = new ZipParameters();

    static {
        a.setCompressionMethod(8);
        a.setCompressionLevel(5);
    }

    public static void main(String[] args) throws IOException, DataFormatException {
        if (args.length >= 5 && args[0].toLowerCase().startsWith("a")) {
            ZipUtils.a(args[1], args[2], args[3], args[4]);
            return;
        }
        if (args.length >= 4 && args[0].toLowerCase().startsWith("x")) {
            ZipUtils.a(args[1], args[2], args[3]);
            return;
        }
        System.out.println("\u7528\u6cd5:\n  zipUtils <a|x> SrcFile DstZipFile Password\n");
    }

    public static byte[] a(byte[] data) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(baos);
        gos.write(data, 0, data.length);
        gos.finish();
        byte[] output = baos.toByteArray();
        baos.flush();
        baos.close();
        return output;
    }

    public static void a(Set<String> srcFiles, String destZipFile) throws ZipException {
        File pathFile;
        String path = FilenameUtils.getFullPath(destZipFile);
        if (StringUtils.isNotBlank(path) && !(pathFile = new File(path)).exists()) {
            pathFile.mkdirs();
        }
        ArrayList<File> srcs = new ArrayList<File>();
        for (String sf : srcFiles) {
            File f2 = new File(sf);
            if (f2 == null || !f2.isFile() || !f2.exists() || !f2.canRead()) continue;
            srcs.add(f2);
        }
        ZipFile zipFile = new ZipFile(destZipFile);
        zipFile.addFiles(srcs, a);
    }

    public static void a(String srcFile, String dstZipFile, String password, String relativePathInZip) throws IOException {
        G.a(new File(srcFile), new File(dstZipFile), password, new M(), relativePathInZip);
    }

    public static void a(List<String> srcFiles, String dstZipFile, String password) throws IOException {
        G aesZip = new G(dstZipFile, (L)new M());
        for (String srcFile : srcFiles) {
            aesZip.a(new File(srcFile), password);
        }
        aesZip.a();
    }

    public static void a(String srcZipFile, String dstDir, String password) throws IOException, DataFormatException {
        String dir = dstDir == null ? "" : (dstDir.endsWith("/") || dstDir.endsWith("\\") ? dstDir : String.valueOf(dstDir) + "/");
        F decrypter = new F(new File(srcZipFile), new J());
        List<S> zipEntries = decrypter.a();
        for (S zipEntry : zipEntries) {
            File f2;
            File outFile = new File(String.valueOf(dir) + zipEntry.getName());
            String parentPath = outFile.getParent();
            if (parentPath != null && parentPath.trim().length() > 0 && !(f2 = new File(parentPath)).exists()) {
                f2.mkdirs();
            }
            decrypter.b(zipEntry, outFile, password);
        }
    }

    public static byte[] a(String zipFile, String entryName) {
        try {
            java.util.zip.ZipFile zf = new java.util.zip.ZipFile(zipFile);
            ZipEntry ze = zf.getEntry(entryName);
            InputStream is = zf.getInputStream(ze);
            ByteArrayOutputStream outBuf = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            int n2 = 0;
            while ((n2 = is.read(buf)) > 0) {
                outBuf.write(buf, 0, n2);
            }
            return outBuf.toByteArray();
        }
        catch (IOException e2) {
            a.error("", e2);
            return null;
        }
    }

    public static byte[] a(String zipFile, String entryName, String pwd) {
        try {
            File zf = new File(zipFile);
            F decrypter = new F(zf, new J());
            S ze = decrypter.a(entryName);
            if (ze != null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream((int)ze.getSize());
                decrypter.a(ze, out, pwd);
                return out.toByteArray();
            }
        }
        catch (Exception e2) {
            a.error("", e2);
        }
        return null;
    }
}

