/*
 * Decompiled with CFR 0.152.
 */
package org.embedded.browser;

import java.text.DecimalFormat;
import javax.swing.filechooser.FileSystemView;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class DownloadWindow {
    static String init_path = FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath();
    static Display display = new Display();
    final int unit = 1024;
    final int S_DOWNLOADING = 1;
    final int S_DOWNLOADED = 2;
    final int S_ERROR = 3;
    int dh;
    int bid;
    int status;
    String filename;
    String mime_type;
    String sz;
    long size;
    long received;
    volatile boolean loaded = false;
    Shell shell = new Shell(display);
    ProgressBar bar;
    Label lbl;

    static {
        System.loadLibrary("./cef_runtime/chromium_loader_win");
    }

    public DownloadWindow(String fn, long fsize, String mime) {
        this.filename = fn;
        this.size = fsize;
        this.mime_type = mime;
        this.sz = this.setSize(this.size);
        this.received = 0L;
    }

    String setSize(long size) {
        String sz;
        if (size < 1024L) {
            sz = String.valueOf(size) + " B";
        } else {
            long kb = size / 1024L;
            if (kb < 1024L) {
                sz = String.valueOf(kb) + " KB";
            } else {
                DecimalFormat df2 = new DecimalFormat();
                df2.setMinimumFractionDigits(0);
                df2.setMaximumFractionDigits(1);
                double mb = (double)size / 1024.0 / 1024.0;
                sz = String.valueOf(df2.format(mb)) + " MB";
            }
        }
        return sz;
    }

    String getPathAndInit() {
        final FileDialog dialog = new FileDialog(this.shell, 8192);
        dialog.setFilterPath(init_path);
        dialog.setText(String.valueOf(this.filename) + ", " + this.sz + ", " + this.mime_type);
        dialog.setFileName(this.filename);
        String path = dialog.open();
        this.shell.dispose();
        if (path == null) {
            path = "";
        } else {
            new Thread(){

                @Override
                public void run() {
                    final Display display = new Display();
                    DownloadWindow.this.shell = new Shell(display, 192);
                    FillLayout fl = new FillLayout();
                    fl.type = 512;
                    fl.marginHeight = 8;
                    fl.marginWidth = 8;
                    DownloadWindow.this.shell.setLayout(fl);
                    DownloadWindow.this.lbl = new Label(DownloadWindow.this.shell, 0);
                    DownloadWindow.this.lbl.setText(String.valueOf(dialog.getFileName()) + ", " + DownloadWindow.this.sz + ", " + DownloadWindow.this.mime_type);
                    DownloadWindow.this.bar = DownloadWindow.this.size > 0L ? new ProgressBar(DownloadWindow.this.shell, 65536) : new ProgressBar(DownloadWindow.this.shell, 65538);
                    DownloadWindow.this.bar.setSelection(0);
                    DownloadWindow.this.shell.pack();
                    DownloadWindow.this.shell.open();
                    new Thread(){

                        @Override
                        public void run() {
                            while (cf.b) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                if (!(this).DownloadWindow.this.loaded) continue;
                                if ((this).DownloadWindow.this.status == 1 || (this).DownloadWindow.this.status == 2) {
                                    if (display.isDisposed() || (this).DownloadWindow.this.bar.isDisposed() || (this).DownloadWindow.this.shell.isDisposed()) {
                                        return;
                                    }
                                    final long r2 = DownloadWindow.this.getReceived((this).DownloadWindow.this.dh);
                                    final long delta = r2 - (this).DownloadWindow.this.received;
                                    (this).DownloadWindow.this.received = r2;
                                    display.syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (((this).this).DownloadWindow.this.bar.isDisposed() || ((this).this).DownloadWindow.this.lbl.isDisposed()) {
                                                return;
                                            }
                                            if (r2 > 0L) {
                                                double d2 = (double)r2 / (double)((this).this).DownloadWindow.this.size * 100.0;
                                                if (((this).this).DownloadWindow.this.size < 0L) {
                                                    d2 = 0.0;
                                                }
                                                int percent = (int)d2;
                                                ((this).this).DownloadWindow.this.shell.setText(String.valueOf(percent) + "%, " + DownloadWindow.this.setSize(r2) + ", " + DownloadWindow.this.setSize(delta) + "/s");
                                                ((this).this).DownloadWindow.this.bar.setSelection(percent);
                                            }
                                        }
                                    });
                                    if (r2 == -10L) {
                                        (this).DownloadWindow.this.status = 3;
                                    }
                                }
                                if ((this).DownloadWindow.this.status != 2 && (this).DownloadWindow.this.status != 3) continue;
                                display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (((this).this).DownloadWindow.this.status == 3) {
                                            MessageBox err = new MessageBox(((this).this).DownloadWindow.this.shell, 33);
                                            err.setText("Download Failed");
                                            err.setMessage("File" + dialog.getFileName() + "download failed.");
                                            err.open();
                                        }
                                        if (!((this).this).DownloadWindow.this.shell.isDisposed()) {
                                            ((this).this).DownloadWindow.this.shell.dispose();
                                        }
                                    }
                                });
                                break;
                            }
                        }
                    }.start();
                    while (!DownloadWindow.this.shell.isDisposed()) {
                        if (display.readAndDispatch()) continue;
                        display.sleep();
                    }
                    display.dispose();
                }
            }.start();
        }
        return path;
    }

    void set_dhptr(int dhp) {
        this.dh = dhp;
        this.status = 1;
        this.loaded = true;
    }

    void set_status(int s2) {
        this.status = s2;
    }

    long getReceived(int dh2) {
        if (this.status == 1) {
            return this.getReceivedN(dh2);
        }
        return this.size;
    }

    native long getReceivedN(int var1);
}

