/*
 * Decompiled with CFR 0.152.
 */
package org.group.user;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.app.common.enums.ECallInPopScrMode;
import org.app.common.enums.ECallInShellMode;
import org.app.common.enums.ECallOutPopScrMode;
import org.app.common.enums.ECallOutShellMode;
import org.app.common.enums.EDeviceBindType;
import org.app.contactsmanager.importer.log.ImportLog;
import org.app.contactsmanager.tree.ContactTreeNodeRight;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonManagedReference;
import org.common.BaseUser;
import org.common.enums.EPhoneMaskType;
import org.common.enums.ESourceType;
import org.group.user.UserDevice;
import org.group.user.UserRight;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="cc_user")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class User
extends BaseUser {
    @JsonIgnore
    @Transient
    private String coreOldPwdMD5;
    @Column
    private EDeviceBindType devBindType = EDeviceBindType.\u672c\u673a\u7ed1\u5b9a;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="user_pid")
    @JsonManagedReference(value="userDevice")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Set<UserDevice> devices = new HashSet<UserDevice>();
    @Column
    private boolean autoLogin = false;
    @Column
    private ESourceType source = ESourceType.user;
    @Column(length=40)
    private String wxOpenId;
    @Column
    private ECallInPopScrMode callInPopScrMode = ECallInPopScrMode.popOld;
    @Column
    private ECallOutPopScrMode callOutPopScrMode = ECallOutPopScrMode.popOld;
    @Column
    private ECallInShellMode callInShellMode = ECallInShellMode.popAndBubble;
    @Column
    private ECallOutShellMode callOutShellMode = ECallOutShellMode.popAndBubble;
    @Column(length=512)
    private String memo;
    @JsonIgnore
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    @JoinColumn(name="user_pid")
    private Set<UserRight> right = new HashSet<UserRight>();
    @JsonIgnore
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="user_pid")
    private Set<ImportLog> importLog = new HashSet<ImportLog>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="user_pid")
    @JsonIgnore
    private Set<ContactTreeNodeRight> treeRights = new HashSet<ContactTreeNodeRight>();

    public String getOldPwdMD5() {
        return this.pwdMD5;
    }

    public void setOldPwdMD5(String s2) {
        this.coreOldPwdMD5 = s2;
    }

    public String getWXBindStatus() {
        return this.isWXBinded() ? "\u5df2\u7ed1\u5b9a" : "\u672a\u7ed1\u5b9a";
    }

    public boolean isWXBinded() {
        return StringUtils.isNotBlank(this.wxOpenId);
    }

    @JsonIgnore
    @Transient
    public EPhoneMaskType get\u53f7\u7801\u63a9\u7801() {
        if (this.right.size() <= 0) {
            if (this.isAdmin()) {
                return EPhoneMaskType.\u6b63\u5e38\u663e\u793a;
            }
            return new UserRight().\u53f7\u7801\u63a9\u7801;
        }
        return this.right.iterator().next().\u53f7\u7801\u63a9\u7801;
    }

    public String getCoreOldPwdMD5() {
        return this.coreOldPwdMD5;
    }

    public EDeviceBindType getDevBindType() {
        return this.devBindType;
    }

    public Set<UserDevice> getDevices() {
        return this.devices;
    }

    public boolean isAutoLogin() {
        return this.autoLogin;
    }

    public ESourceType getSource() {
        return this.source;
    }

    public String getWxOpenId() {
        return this.wxOpenId;
    }

    public ECallInPopScrMode getCallInPopScrMode() {
        return this.callInPopScrMode;
    }

    public ECallOutPopScrMode getCallOutPopScrMode() {
        return this.callOutPopScrMode;
    }

    public ECallInShellMode getCallInShellMode() {
        return this.callInShellMode;
    }

    public ECallOutShellMode getCallOutShellMode() {
        return this.callOutShellMode;
    }

    public String getMemo() {
        return this.memo;
    }

    public Set<UserRight> getRight() {
        return this.right;
    }

    public Set<ImportLog> getImportLog() {
        return this.importLog;
    }

    public Set<ContactTreeNodeRight> getTreeRights() {
        return this.treeRights;
    }

    public void setCoreOldPwdMD5(String coreOldPwdMD5) {
        this.coreOldPwdMD5 = coreOldPwdMD5;
    }

    public void setDevBindType(EDeviceBindType devBindType) {
        this.devBindType = devBindType;
    }

    public void setDevices(Set<UserDevice> devices) {
        this.devices = devices;
    }

    public void setAutoLogin(boolean autoLogin) {
        this.autoLogin = autoLogin;
    }

    public void setSource(ESourceType source) {
        this.source = source;
    }

    public void setWxOpenId(String wxOpenId) {
        this.wxOpenId = wxOpenId;
    }

    public void setCallInPopScrMode(ECallInPopScrMode callInPopScrMode) {
        this.callInPopScrMode = callInPopScrMode;
    }

    public void setCallOutPopScrMode(ECallOutPopScrMode callOutPopScrMode) {
        this.callOutPopScrMode = callOutPopScrMode;
    }

    public void setCallInShellMode(ECallInShellMode callInShellMode) {
        this.callInShellMode = callInShellMode;
    }

    public void setCallOutShellMode(ECallOutShellMode callOutShellMode) {
        this.callOutShellMode = callOutShellMode;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public void setRight(Set<UserRight> right) {
        this.right = right;
    }

    public void setImportLog(Set<ImportLog> importLog) {
        this.importLog = importLog;
    }

    public void setTreeRights(Set<ContactTreeNodeRight> treeRights) {
        this.treeRights = treeRights;
    }
}

