/*
 * Decompiled with CFR 0.152.
 */
package org.order.pojo;

import java.math.BigDecimal;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.app.common.enums.EPriceType;
import org.app.common.enums.EProductStatus;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonManagedReference;
import org.common.db.AbsPojoEntity;
import org.common.enums.EFieldType;
import org.common.field.TmField;
import org.order.pojo.OrderProductRel;

@Entity
@Table(name="cc_product")
public class Product
extends AbsPojoEntity {
    @OneToMany
    @JoinColumn(name="orderRelas")
    @JsonIgnore
    @JsonManagedReference(value="orderRelas")
    private Set<OrderProductRel> orderRelas = new LinkedHashSet<OrderProductRel>();
    @Column(length=50)
    private String category;
    @TmField(text="\u4ea7\u54c1\u7f16\u53f7", uniqueIgnoreCase=true)
    @Column(length=40)
    private String num;
    @TmField(text="\u4ea7\u54c1\u540d\u79f0")
    @Column(length=200)
    private String name;
    @Column(length=20)
    private String namejp;
    @TmField(text="\u54c1\u724c")
    @Column(length=50)
    private String brand;
    @TmField(text="\u578b\u53f7")
    @Column(length=50)
    private String model;
    @TmField(text="\u89c4\u683c")
    @Column(length=50)
    private String spec;
    @TmField(text="\u5355\u4f4d")
    @Column(length=20)
    private String unit;
    @TmField(text="\u8d2d\u5165\u4ef7\u683c", type=EFieldType.num182, exportFieldName="BuyPrice_FMT")
    @Column(precision=18, scale=2)
    private BigDecimal buyPrice = new BigDecimal(0);
    @TmField(text="\u96f6\u552e\u4ef7\u683c", type=EFieldType.num182, exportFieldName="SellingPrice_FMT")
    @Column(precision=18, scale=2)
    private BigDecimal sellingPrice = new BigDecimal(0);
    @TmField(text="\u6279\u53d1\u4ef7\u683c", type=EFieldType.num182, exportFieldName="WholesalePrice_FMT")
    @Column(precision=18, scale=2)
    private BigDecimal wholesalePrice = new BigDecimal(0);
    @TmField(text="\u4f1a\u5458\u4ef7\u683c", type=EFieldType.num182, exportFieldName="VipPrice_FMT")
    @Column(precision=18, scale=2)
    private BigDecimal vipPrice = new BigDecimal(0);
    @TmField(text="\u5e93\u5b58\u91cf", type=EFieldType.num183, exportFieldName="Stock_FMT")
    @Column(precision=18, scale=3)
    private BigDecimal stock = new BigDecimal(0);
    @TmField(text="\u5907\u6ce8")
    @Column(length=2048)
    private String memo;
    @TmField(text="\u521b\u5efa\u4eba", type=EFieldType.userlist, exportFieldName="Creater_FMT")
    @Column
    private Long creater;
    @TmField(text="\u521b\u5efa\u65f6\u95f4", type=EFieldType.datetime, exportFieldName="CreateTime_FMT")
    @Column(length=15)
    private Long createTime = ci.a();
    @TmField(text="\u4fee\u6539\u4eba", type=EFieldType.userlist, exportFieldName="Modifyer_FMT")
    @Column
    private Long modifyer;
    @TmField(text="\u4fee\u6539\u65f6\u95f4", type=EFieldType.datetime, exportFieldName="ModifyTime_FMT")
    @Column(length=15)
    private Long modifyTime = ci.a();
    @TmField(text="\u4ea7\u54c1\u72b6\u6001", type=EFieldType.radio)
    @Column
    private EProductStatus status = EProductStatus.\u5728\u552e;
    @Transient
    private long productId;
    @Transient
    private BigDecimal orderAmount = new BigDecimal(0);
    @Transient
    private EPriceType orderPriceType;
    @Transient
    private BigDecimal orderPrice = new BigDecimal(0);
    @Transient
    private String orderMemo;
    @Transient
    private Long orderCreater;
    @Transient
    private Long orderCreateTime;
    @Transient
    private Long orderModifyer;
    @Transient
    private String orderModifyTime;

    public void setName(String name) {
        this.name = name;
        if (StringUtils.isNotBlank(name)) {
            String jp = cI.d(name);
            if (StringUtils.isBlank(jp)) {
                jp = aQ.a(name.split(" "));
            }
            if (StringUtils.isNotBlank(jp)) {
                this.setNamejp(jp);
            } else {
                this.setNamejp(null);
            }
        }
    }

    public String getBuyPrice_FMT() {
        return cb.a(this.buyPrice);
    }

    public String getSellingPrice_FMT() {
        return cb.a(this.sellingPrice);
    }

    public String getWholesalePrice_FMT() {
        return cb.a(this.wholesalePrice);
    }

    public String getVipPrice_FMT() {
        return cb.a(this.vipPrice);
    }

    public String getStock_FMT() {
        return this.stock.toString();
    }

    public String getCreater_FMT() {
        return dt.a(this.creater);
    }

    public String getCreateTime_FMT() {
        if (this.createTime != null) {
            return ck.e(this.createTime);
        }
        return "";
    }

    public String getModifyer_FMT() {
        return dt.a(this.modifyer);
    }

    public String getModifyTime_FMT() {
        if (this.modifyTime != null) {
            return ck.e(this.modifyTime);
        }
        return "";
    }

    public String getOrderPrice_FMT() {
        return cb.a(this.orderPrice);
    }

    public Set<OrderProductRel> getOrderRelas() {
        return this.orderRelas;
    }

    public String getCategory() {
        return this.category;
    }

    public String getNum() {
        return this.num;
    }

    public String getName() {
        return this.name;
    }

    public String getNamejp() {
        return this.namejp;
    }

    public String getBrand() {
        return this.brand;
    }

    public String getModel() {
        return this.model;
    }

    public String getSpec() {
        return this.spec;
    }

    public String getUnit() {
        return this.unit;
    }

    public BigDecimal getBuyPrice() {
        return this.buyPrice;
    }

    public BigDecimal getSellingPrice() {
        return this.sellingPrice;
    }

    public BigDecimal getWholesalePrice() {
        return this.wholesalePrice;
    }

    public BigDecimal getVipPrice() {
        return this.vipPrice;
    }

    public BigDecimal getStock() {
        return this.stock;
    }

    public String getMemo() {
        return this.memo;
    }

    public Long getCreater() {
        return this.creater;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public Long getModifyer() {
        return this.modifyer;
    }

    public Long getModifyTime() {
        return this.modifyTime;
    }

    public EProductStatus getStatus() {
        return this.status;
    }

    public long getProductId() {
        return this.productId;
    }

    public BigDecimal getOrderAmount() {
        return this.orderAmount;
    }

    public EPriceType getOrderPriceType() {
        return this.orderPriceType;
    }

    public BigDecimal getOrderPrice() {
        return this.orderPrice;
    }

    public String getOrderMemo() {
        return this.orderMemo;
    }

    public Long getOrderCreater() {
        return this.orderCreater;
    }

    public Long getOrderCreateTime() {
        return this.orderCreateTime;
    }

    public Long getOrderModifyer() {
        return this.orderModifyer;
    }

    public String getOrderModifyTime() {
        return this.orderModifyTime;
    }

    public void setOrderRelas(Set<OrderProductRel> orderRelas) {
        this.orderRelas = orderRelas;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public void setNamejp(String namejp) {
        this.namejp = namejp;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setBuyPrice(BigDecimal buyPrice) {
        this.buyPrice = buyPrice;
    }

    public void setSellingPrice(BigDecimal sellingPrice) {
        this.sellingPrice = sellingPrice;
    }

    public void setWholesalePrice(BigDecimal wholesalePrice) {
        this.wholesalePrice = wholesalePrice;
    }

    public void setVipPrice(BigDecimal vipPrice) {
        this.vipPrice = vipPrice;
    }

    public void setStock(BigDecimal stock) {
        this.stock = stock;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public void setCreater(Long creater) {
        this.creater = creater;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setModifyer(Long modifyer) {
        this.modifyer = modifyer;
    }

    public void setModifyTime(Long modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setStatus(EProductStatus status) {
        this.status = status;
    }

    public void setProductId(long productId) {
        this.productId = productId;
    }

    public void setOrderAmount(BigDecimal orderAmount) {
        this.orderAmount = orderAmount;
    }

    public void setOrderPriceType(EPriceType orderPriceType) {
        this.orderPriceType = orderPriceType;
    }

    public void setOrderPrice(BigDecimal orderPrice) {
        this.orderPrice = orderPrice;
    }

    public void setOrderMemo(String orderMemo) {
        this.orderMemo = orderMemo;
    }

    public void setOrderCreater(Long orderCreater) {
        this.orderCreater = orderCreater;
    }

    public void setOrderCreateTime(Long orderCreateTime) {
        this.orderCreateTime = orderCreateTime;
    }

    public void setOrderModifyer(Long orderModifyer) {
        this.orderModifyer = orderModifyer;
    }

    public void setOrderModifyTime(String orderModifyTime) {
        this.orderModifyTime = orderModifyTime;
    }
}

