/*
 * Decompiled with CFR 0.152.
 */
package org.server.controller;

import java.net.URL;
import java.util.Arrays;
import org.common.ArgUtils;
import org.common.server.IWebServer;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;

public class JettyServer
implements IWebServer {
    private Server server = new Server(IWebServer.PORT);
    private static final String PROJECT_PATH = ArgUtils.a();
    private static final String WEB_APP_PATH = String.valueOf(PROJECT_PATH) + "/WebRoot";

    @Override
    public void startupServer() throws Exception {
        WebAppContext context = new WebAppContext();
        context.setContextPath(IWebServer.CONTEXT_PATH);
        context.setResourceBase(WEB_APP_PATH);
        context.setDescriptor(String.valueOf(WEB_APP_PATH) + "/WEB-INF/web.xml");
        URL classes = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        context.getMetaData().setWebInfClassesDirs(Arrays.asList(Resource.newResource("."), Resource.newResource(classes)));
        context.setConfigurations(new Configuration[]{new AnnotationConfiguration(), new WebXmlConfiguration(), new WebInfConfiguration(), new PlusConfiguration(), new MetaInfConfiguration(), new FragmentConfiguration(), new EnvConfiguration()});
        context.setParentLoaderPriority(true);
        this.server.setHandler(context);
        this.server.start();
        if (cf.a) {
            this.server.dumpStdErr();
        }
    }

    @Override
    public void shutdownServer(int exitCode) throws Exception {
        if (this.server != null && this.server.isRunning()) {
            try {
                this.server.stop();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        System.exit(exitCode);
    }
}

