/*
 * Decompiled with CFR 0.152.
 */
package org.server.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ScheduleServer {
    private static final Logger a = LoggerFactory.getLogger(ScheduleServer.class);
    private static SchedulerFactory a = new StdSchedulerFactory();
    private static Scheduler a;
    private static ScheduleServer a;

    static {
        try {
            a = a.getScheduler();
        }
        catch (SchedulerException e2) {
            e2.printStackTrace();
        }
        a = new ScheduleServer();
    }

    private ScheduleServer() {
    }

    public static ScheduleServer a() {
        return a;
    }

    public boolean a() {
        try {
            a.start();
            return true;
        }
        catch (SchedulerException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public boolean b() {
        try {
            a.shutdown();
            return true;
        }
        catch (SchedulerException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public <T extends Job> boolean a(Class<T> jobClazz, String jobName, String groupName, JobDataMap jobDataMap, Trigger trigger) {
        return this.b(jobClazz, jobName, groupName, jobDataMap, trigger);
    }

    public <T extends Job> boolean a(Class<T> jobClazz, String jobName, JobDataMap jobDataMap, Date runTime) {
        Trigger trigger = TriggerBuilder.newTrigger().startAt(runTime).build();
        return this.b(jobClazz, jobName, null, jobDataMap, trigger);
    }

    public <T extends Job> boolean a(Class<T> jobClazz, JobDataMap jobDataMap, Trigger trigger) {
        return this.b(jobClazz, null, null, jobDataMap, trigger);
    }

    public <T extends Job> boolean b(Class<T> jobClazz, String jobName, String groupName, JobDataMap jobDataMap, Trigger trigger) {
        try {
            JobBuilder jb = JobBuilder.newJob(jobClazz);
            if (jobDataMap != null) {
                jb.usingJobData(jobDataMap);
            }
            if (StringUtils.isNotBlank(jobName) && StringUtils.isNotBlank(groupName)) {
                jb.withIdentity(jobName, groupName);
            } else if (StringUtils.isNotBlank(jobName)) {
                jb.withIdentity(jobName);
            }
            JobDetail job = jb.build();
            Date dt2 = a.scheduleJob(job, trigger);
            return true;
        }
        catch (SchedulerException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public static void a() {
        try {
            for (String groupName : a.getJobGroupNames()) {
                for (JobKey jobKey : a.getJobKeys(GroupMatcher.jobGroupEquals(groupName))) {
                    String jobName = jobKey.getName();
                    String jobGroup = jobKey.getGroup();
                    List<? extends Trigger> triggers = a.getTriggersOfJob(jobKey);
                    a.debug("\n[jobName] : " + jobName + "/" + jobGroup);
                    for (Trigger trigger : triggers) {
                        a.debug("[TriggerName] : " + trigger.getKey().getName() + "/" + trigger.getKey().getGroup() + " - " + trigger.getNextFireTime());
                    }
                }
            }
        }
        catch (SchedulerException e2) {
            e2.printStackTrace();
        }
    }

    public JobKey a(String jobName, String groupName) {
        try {
            for (JobKey jobKey : a.getJobKeys(GroupMatcher.jobGroupEquals(groupName))) {
                if (!jobKey.getName().equals(jobName)) continue;
                return jobKey;
            }
        }
        catch (SchedulerException e2) {
            e2.printStackTrace();
        }
        return null;
    }

    public Trigger a(String triName, String groupName) {
        TriggerKey tkey = new TriggerKey(triName, groupName);
        try {
            return a.getTrigger(tkey);
        }
        catch (SchedulerException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static void a(GroupMatcher gm) {
        try {
            Set<TriggerKey> tks = a.getTriggerKeys(gm);
            if (tks != null && tks.size() > 0) {
                a.unscheduleJobs(new ArrayList<TriggerKey>(tks));
            }
        }
        catch (SchedulerException e2) {
            e2.printStackTrace();
        }
    }

    public void a(String jobName, String jobGroup) {
        JobKey key = this.a(jobName, jobGroup);
        if (key != null) {
            try {
                List<? extends Trigger> triggers = a.getTriggersOfJob(key);
                if (triggers != null) {
                    a.unscheduleJobs(triggers);
                }
                a.deleteJob(key);
            }
            catch (SchedulerException e2) {
                e2.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        ScheduleServer cs2 = ScheduleServer.a();
        cs2.a();
        JobDataMap jdMap = new JobDataMap();
        cs2.a(af.class, "1", jdMap, new Date(new Date().getTime() + 10000L));
        ScheduleServer.a();
        try {
            Thread.sleep(15000L);
            ScheduleServer.a();
            Thread.sleep(2000L);
            ScheduleServer.a();
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        cs2.b();
    }

    public static Scheduler a() {
        return a;
    }
}

