/*
 * Decompiled with CFR 0.152.
 */
package taobe.tec.jcc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JChineseConvertor {
    private Map<Character, Character> ts;
    private Map<Character, Character> st;
    private static JChineseConvertor convertor;

    public static JChineseConvertor getInstance() throws IOException {
        if (convertor == null) {
            convertor = new JChineseConvertor();
        }
        return convertor;
    }

    public String t2s(String s) {
        char[] cs = new char[s.length()];
        int i = 0;
        while (i < s.length()) {
            cs[i] = this.t2s(s.charAt(i)).charValue();
            ++i;
        }
        return new String(cs);
    }

    public String s2t(String s) {
        char[] cs = new char[s.length()];
        int i = 0;
        while (i < s.length()) {
            cs[i] = this.s2t(s.charAt(i)).charValue();
            ++i;
        }
        return new String(cs);
    }

    public Character t2s(char c) {
        if (this.ts.get(Character.valueOf(c)) == null) {
            return Character.valueOf(c);
        }
        return this.ts.get(Character.valueOf(c));
    }

    public Character s2t(char c) {
        if (this.st.get(Character.valueOf(c)) == null) {
            return Character.valueOf(c);
        }
        return this.st.get(Character.valueOf(c));
    }

    private List<Character> loadTable() throws IOException {
        List<Character> cs = this.loadChar("/cfg/ts.tab", "UTF-8");
        if (cs.size() % 2 != 0) {
            throw new RuntimeException("The conversion table may be damaged or not exists");
        }
        return cs;
    }

    private JChineseConvertor() throws IOException {
        List<Character> cs = this.loadTable();
        this.ts = new HashMap<Character, Character>();
        this.st = new HashMap<Character, Character>();
        int i = 0;
        while (i < cs.size()) {
            this.ts.put(cs.get(i), cs.get(i + 1));
            this.st.put(cs.get(i + 1), cs.get(i));
            i += 2;
        }
    }

    private List<Character> loadChar(String file, String charset) throws IOException {
        int c;
        ArrayList<Character> content = new ArrayList<Character>();
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(file), charset));
        while ((c = in.read()) != -1) {
            content.add(Character.valueOf((char)c));
        }
        in.close();
        return content;
    }
}

