/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.IOException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.ExtendedBufferedReader;
import org.apache.commons.csv.Lexer;
import org.apache.commons.csv.Token;

final class CSVLexer
extends Lexer {
    CSVLexer(CSVFormat format, ExtendedBufferedReader in) {
        super(format, in);
    }

    Token nextToken(Token token) throws IOException {
        int lastChar = this.in.getLastChar();
        int c = this.in.read();
        boolean eol = this.readEndOfLine(c);
        if (this.ignoreEmptyLines) {
            while (eol && this.isStartOfLine(lastChar)) {
                lastChar = c;
                c = this.in.read();
                eol = this.readEndOfLine(c);
                if (!this.isEndOfFile(c)) continue;
                token.type = Token.Type.EOF;
                return token;
            }
        }
        if (this.isEndOfFile(lastChar) || !this.isDelimiter(lastChar) && this.isEndOfFile(c)) {
            token.type = Token.Type.EOF;
            return token;
        }
        if (this.isStartOfLine(lastChar) && this.isCommentStart(c)) {
            String comment = this.in.readLine().trim();
            token.content.append(comment);
            token.type = Token.Type.COMMENT;
            return token;
        }
        while (token.type == Token.Type.INVALID) {
            if (this.ignoreSurroundingSpaces) {
                while (this.isWhitespace(c) && !eol) {
                    c = this.in.read();
                    eol = this.readEndOfLine(c);
                }
            }
            if (this.isDelimiter(c)) {
                token.type = Token.Type.TOKEN;
                continue;
            }
            if (eol) {
                token.type = Token.Type.EORECORD;
                continue;
            }
            if (this.isQuoteChar(c)) {
                this.parseEncapsulatedToken(token);
                continue;
            }
            if (this.isEndOfFile(c)) {
                token.type = Token.Type.EOF;
                token.isReady = true;
                continue;
            }
            this.parseSimpleToken(token, c);
        }
        return token;
    }

    private Token parseSimpleToken(Token tkn, int c) throws IOException {
        while (true) {
            if (this.readEndOfLine(c)) {
                tkn.type = Token.Type.EORECORD;
                break;
            }
            if (this.isEndOfFile(c)) {
                tkn.type = Token.Type.EOF;
                tkn.isReady = true;
                break;
            }
            if (this.isDelimiter(c)) {
                tkn.type = Token.Type.TOKEN;
                break;
            }
            if (this.isEscape(c)) {
                int unescaped = this.readEscape();
                if (unescaped == -1) {
                    tkn.content.append((char)c).append((char)this.in.getLastChar());
                } else {
                    tkn.content.append((char)unescaped);
                }
                c = this.in.read();
                continue;
            }
            tkn.content.append((char)c);
            c = this.in.read();
        }
        if (this.ignoreSurroundingSpaces) {
            this.trimTrailingSpaces(tkn.content);
        }
        return tkn;
    }

    private Token parseEncapsulatedToken(Token tkn) throws IOException {
        long startLineNumber = this.getCurrentLineNumber();
        while (true) {
            int c;
            if (this.isEscape(c = this.in.read())) {
                int unescaped = this.readEscape();
                if (unescaped == -1) {
                    tkn.content.append((char)c).append((char)this.in.getLastChar());
                    continue;
                }
                tkn.content.append((char)unescaped);
                continue;
            }
            if (this.isQuoteChar(c)) {
                if (this.isQuoteChar(this.in.lookAhead())) {
                    c = this.in.read();
                    tkn.content.append((char)c);
                    continue;
                }
                do {
                    if (this.isDelimiter(c = this.in.read())) {
                        tkn.type = Token.Type.TOKEN;
                        return tkn;
                    }
                    if (this.isEndOfFile(c)) {
                        tkn.type = Token.Type.EOF;
                        tkn.isReady = true;
                        return tkn;
                    }
                    if (!this.readEndOfLine(c)) continue;
                    tkn.type = Token.Type.EORECORD;
                    return tkn;
                } while (this.isWhitespace(c));
                throw new IOException("(line " + this.getCurrentLineNumber() + ") invalid char between encapsulated token and delimiter");
            }
            if (this.isEndOfFile(c)) {
                throw new IOException("(startline " + startLineNumber + ") EOF reached before encapsulated token finished");
            }
            tkn.content.append((char)c);
        }
    }
}

