/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVRecord
implements Serializable,
Iterable<String> {
    private static final long serialVersionUID = 1L;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final String[] values;
    private final Map<String, Integer> mapping;
    private final String comment;
    private final long recordNumber;

    CSVRecord(String[] values, Map<String, Integer> mapping, String comment, long recordNumber) {
        this.recordNumber = recordNumber;
        this.values = values != null ? values : EMPTY_STRING_ARRAY;
        this.mapping = mapping;
        this.comment = comment;
    }

    public String get(int i) {
        return this.values[i];
    }

    public String get(String name) {
        if (this.mapping == null) {
            throw new IllegalStateException("No header mapping was specified, the record values can't be accessed by name");
        }
        Integer index = this.mapping.get(name);
        try {
            return index != null ? this.values[index] : null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.format("Index for header '%s' is %d but CSVRecord only has %d values!", name, (int)index, this.values.length));
        }
    }

    public boolean isConsistent() {
        return this.mapping == null ? true : this.mapping.size() == this.values.length;
    }

    public boolean isMapped(String name) {
        return this.mapping != null ? this.mapping.containsKey(name) : false;
    }

    public boolean isSet(String name) {
        return this.isMapped(name) && this.mapping.get(name) < this.values.length;
    }

    @Override
    public Iterator<String> iterator() {
        return Arrays.asList(this.values).iterator();
    }

    String[] values() {
        return this.values;
    }

    public String getComment() {
        return this.comment;
    }

    public long getRecordNumber() {
        return this.recordNumber;
    }

    public int size() {
        return this.values.length;
    }

    public String toString() {
        return Arrays.toString(this.values);
    }
}

